/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import net.schmizz.sshj.sftp.PathComponents;

public class PathHelper {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private final Canonicalizer canonicalizer;
    private final String pathSep;
    private String dotDir;

    private synchronized String getDotDir() throws IOException {
        return this.dotDir != null ? this.dotDir : (this.dotDir = this.canonicalizer.canonicalize("."));
    }

    public PathHelper(Canonicalizer canonicalizer, String pathSep) {
        this.canonicalizer = canonicalizer;
        this.pathSep = pathSep;
    }

    public String adjustForParent(String parent, String path) {
        return PathComponents.adjustForParent(parent, path, this.pathSep);
    }

    public String trimTrailingSeparator(String path) {
        return PathComponents.trimTrailingSeparator(path, this.pathSep);
    }

    public String getPathSeparator() {
        return this.pathSep;
    }

    public PathComponents getComponents(String parent, String name) {
        return new PathComponents(parent, name, this.pathSep);
    }

    public PathComponents getComponents(String path) throws IOException {
        String name;
        if (path.equals(this.pathSep)) {
            return this.getComponents("", "");
        }
        if (path.isEmpty() || ".".equals(path) || ("." + this.pathSep).equals(path)) {
            return this.getComponents(this.getDotDir());
        }
        String withoutTrailSep = this.trimTrailingSeparator(path);
        int lastSep = withoutTrailSep.lastIndexOf(this.pathSep);
        String parent = lastSep == -1 ? "" : withoutTrailSep.substring(0, lastSep);
        String string = name = lastSep == -1 ? withoutTrailSep : withoutTrailSep.substring(lastSep + this.pathSep.length());
        if (".".equals(name) || "..".equals(name)) {
            return this.getComponents(this.canonicalizer.canonicalize(path));
        }
        return this.getComponents(parent, name);
    }

    public static interface Canonicalizer {
        public String canonicalize(String var1) throws IOException;
    }
}

