/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local.validation;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.lang.StringUtils;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="integerAndPlaceholder")
public @interface IntegerAndPlaceholderValidator {

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        public void validate(String value, ValidationContext context) {
            if (!this.isPlaceholder(value) && !StringUtils.isNumeric((String)value)) {
                context.error("%s is not a number/placeholder", new Object[]{value});
            }
        }

        private boolean isPlaceholder(String value) {
            return StringUtils.startsWith((String)value, (String)"{{") && StringUtils.endsWith((String)value, (String)"}}");
        }
    }
}

