/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.DistinctErrorLog;

class MappedRawLog
implements RawLog {
    private static final int ONE_GIG = 0x40000000;
    private static final int PAGE_LENGTH = 4096;
    private final int termLength;
    private final UnsafeBuffer[] termBuffers = new UnsafeBuffer[3];
    private final File logFile;
    private final MappedByteBuffer[] mappedBuffers;
    private final UnsafeBuffer logMetaDataBuffer;
    private final DistinctErrorLog errorLog;

    MappedRawLog(File location, boolean useSparseFiles, int termLength, DistinctErrorLog errorLog) {
        this.termLength = termLength;
        this.errorLog = errorLog;
        this.logFile = location;
        try (FileChannel logChannel = FileChannel.open(this.logFile.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            long logLength = LogBufferDescriptor.computeLogLength((int)termLength);
            if (logLength <= Integer.MAX_VALUE) {
                MappedByteBuffer mappedBuffer = logChannel.map(FileChannel.MapMode.READ_WRITE, 0L, logLength);
                if (!useSparseFiles) {
                    MappedRawLog.allocatePages(mappedBuffer, (int)logLength);
                }
                this.mappedBuffers = new MappedByteBuffer[]{mappedBuffer};
                for (int i = 0; i < 3; ++i) {
                    this.termBuffers[i] = new UnsafeBuffer((ByteBuffer)mappedBuffer, i * termLength, termLength);
                }
                this.logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)mappedBuffer, (int)(logLength - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
            } else {
                MappedByteBuffer metaDataMappedBuffer;
                this.mappedBuffers = new MappedByteBuffer[4];
                for (int i = 0; i < 3; ++i) {
                    this.mappedBuffers[i] = logChannel.map(FileChannel.MapMode.READ_WRITE, (long)termLength * (long)i, termLength);
                    if (!useSparseFiles) {
                        MappedRawLog.allocatePages(this.mappedBuffers[i], termLength);
                    }
                    this.termBuffers[i] = new UnsafeBuffer((ByteBuffer)this.mappedBuffers[i]);
                }
                long metaDataSectionOffset = (long)termLength * 3L;
                this.mappedBuffers[3] = metaDataMappedBuffer = logChannel.map(FileChannel.MapMode.READ_WRITE, metaDataSectionOffset, LogBufferDescriptor.LOG_META_DATA_LENGTH);
                this.logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)metaDataMappedBuffer);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public int termLength() {
        return this.termLength;
    }

    @Override
    public void close() {
        for (MappedByteBuffer buffer : this.mappedBuffers) {
            IoUtil.unmap((MappedByteBuffer)buffer);
        }
        try {
            FileChannel ignore = FileChannel.open(this.logFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            Throwable throwable = null;
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        if (!this.logFile.delete()) {
            this.errorLog.record((Throwable)new IllegalStateException("Unable to delete " + this.logFile));
        }
    }

    @Override
    public UnsafeBuffer[] termBuffers() {
        return this.termBuffers;
    }

    @Override
    public UnsafeBuffer metaData() {
        return this.logMetaDataBuffer;
    }

    @Override
    public ByteBuffer[] sliceTerms() {
        ByteBuffer[] terms = new ByteBuffer[3];
        if (this.termLength < 0x40000000) {
            MappedByteBuffer buffer = this.mappedBuffers[0];
            for (int i = 0; i < 3; ++i) {
                buffer.limit(this.termLength * i + this.termLength).position(this.termLength * i);
                terms[i] = buffer.slice();
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                terms[i] = this.mappedBuffers[i].duplicate();
            }
        }
        return terms;
    }

    @Override
    public String fileName() {
        return this.logFile.getAbsolutePath();
    }

    private static void allocatePages(MappedByteBuffer buffer, int length) {
        for (int i = 0; i < length; i += 4096) {
            buffer.put(i, (byte)0);
        }
    }
}

