/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.ProcessConnection;

public class CifsProcessConnection
extends CifsConnection {
    private ProcessConnection processConnection;

    public CifsProcessConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper, true);
        options.set("protocol", type);
        CifsConnectionType cifsConnectionType = options.getEnum("connectionType", CifsConnectionType.class);
        this.processConnection = cifsConnectionType.getProcessConnection(options, mapper, this.workingDirectory);
        this.connected();
    }

    @Override
    public void connect() {
        this.processConnection.connect();
        this.connected();
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        super.setWorkingDirectory(workingDirectory);
        this.processConnection.setWorkingDirectory(workingDirectory);
    }

    @Override
    public void doClose() {
        this.processConnection.close();
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmd) {
        return this.processConnection.startProcess(cmd);
    }
}

