/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

class SYSCHECKSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSCHECKS";
    private static final int SYSCHECKS_COLUMN_COUNT = 3;
    private static final int SYSCHECKS_CONSTRAINTID = 1;
    private static final int SYSCHECKS_CHECKDEFINITION = 2;
    private static final int SYSCHECKS_REFERENCEDCOLUMNS = 3;
    static final int SYSCHECKS_INDEX1_ID = 0;
    private static final boolean[] uniqueness = null;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final String[] uuids = new String[]{"80000056-00d0-fd77-3ed8-000a0a0b1900", "80000059-00d0-fd77-3ed8-000a0a0b1900", "80000058-00d0-fd77-3ed8-000a0a0b1900"};

    SYSCHECKSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(3, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        ReferencedColumns referencedColumns = null;
        String string = null;
        String string2 = null;
        if (tupleDescriptor != null) {
            CheckConstraintDescriptor checkConstraintDescriptor = (CheckConstraintDescriptor)tupleDescriptor;
            string2 = checkConstraintDescriptor.getUUID().toString();
            string = checkConstraintDescriptor.getConstraintText();
            referencedColumns = checkConstraintDescriptor.getReferencedColumnsDescriptor();
        }
        ExecIndexRow execIndexRow = this.getExecutionFactory().getIndexableRow(3);
        execIndexRow.setColumn(1, new SQLChar(string2));
        execIndexRow.setColumn(2, this.dvf.getLongvarcharDataValue(string));
        execIndexRow.setColumn(3, new UserType(referencedColumns));
        return execIndexRow;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        SubCheckConstraintDescriptor subCheckConstraintDescriptor = null;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        ReferencedColumns referencedColumns = (ReferencedColumns)dataValueDescriptor.getObject();
        subCheckConstraintDescriptor = new SubCheckConstraintDescriptor(uUID, string2, referencedColumns);
        return subCheckConstraintDescriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("CONSTRAINTID", false), SystemColumnImpl.getColumn("CHECKDEFINITION", -1, false), SystemColumnImpl.getJavaColumn("REFERENCEDCOLUMNS", "org.apache.derby.catalog.ReferencedColumns", false)};
    }
}

