/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.ConfigurationException;
import akka.actor.ActorSystem;
import akka.dispatch.BalancingDispatcherConfigurator;
import akka.dispatch.CachingConfig;
import akka.dispatch.DispatcherConfigurator;
import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.Dispatchers$;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.PinnedDispatcherConfigurator;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005s!B\u0001\u0003\u0011\u00039\u0011a\u0003#jgB\fGo\u00195feNT!a\u0001\u0003\u0002\u0011\u0011L7\u000f]1uG\"T\u0011!B\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u0017\u0011K7\u000f]1uG\",'o]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\u0006]\t1\u0003R3gCVdG\u000fR5ta\u0006$8\r[3s\u0013\u0012,\u0012\u0001G\b\u00023\u0005\n!$A\u000fbW.\fg&Y2u_JtC-\u001a4bk2$X\u0006Z5ta\u0006$8\r[3s\u0011\u0019a\u0012\u0002)A\u00071\u0005!B)\u001a4bk2$H)[:qCR\u001c\u0007.\u001a:JI\u00022AA\u0003\u0002\u0001=M\u0011Q\u0004\u0004\u0005\tAu\u0011)\u0019!C\u0001C\u0005A1/\u001a;uS:<7/F\u0001#!\t\u0019\u0013F\u0004\u0002%O5\tQE\u0003\u0002'\t\u0005)\u0011m\u0019;pe&\u0011\u0001&J\u0001\f\u0003\u000e$xN]*zgR,W.\u0003\u0002+W\tA1+\u001a;uS:<7O\u0003\u0002)K!AQ&\bB\u0001B\u0003%!%A\u0005tKR$\u0018N\\4tA!Aq&\bBC\u0002\u0013\u0005\u0001'A\u0007qe\u0016\u0014X-];jg&$Xm]\u000b\u0002cA\u0011\u0001BM\u0005\u0003g\t\u0011q\u0003R5ta\u0006$8\r[3s!J,'/Z9vSNLG/Z:\t\u0011Uj\"\u0011!Q\u0001\nE\na\u0002\u001d:fe\u0016\fX/[:ji\u0016\u001c\b\u0005C\u0003\u0014;\u0011\u0005q\u0007F\u00029si\u0002\"\u0001C\u000f\t\u000b\u00012\u0004\u0019\u0001\u0012\t\u000b=2\u0004\u0019A\u0019\t\u000fqj\"\u0019!C\u0001{\u0005i1-Y2iS:<7i\u001c8gS\u001e,\u0012A\u0010\t\u0003\u0011}J!\u0001\u0011\u0002\u0003\u001b\r\u000b7\r[5oO\u000e{gNZ5h\u0011\u0019\u0011U\u0004)A\u0005}\u0005q1-Y2iS:<7i\u001c8gS\u001e\u0004\u0003b\u0002#\u001e\u0005\u0004%\t!R\u0001\u0018I\u00164\u0017-\u001e7u\t&\u001c\b/\u0019;dQ\u0016\u00148i\u001c8gS\u001e,\u0012A\u0012\t\u0003\u000f:k\u0011\u0001\u0013\u0006\u0003\u0013*\u000baaY8oM&<'BA&M\u0003!!\u0018\u0010]3tC\u001a,'\"A'\u0002\u0007\r|W.\u0003\u0002P\u0011\n11i\u001c8gS\u001eDa!U\u000f!\u0002\u00131\u0015\u0001\u00073fM\u0006,H\u000e\u001e#jgB\fGo\u00195fe\u000e{gNZ5hA!)1+\bC\u0001)\u00069B-\u001a4bk2$x\t\\8cC2$\u0015n\u001d9bi\u000eDWM]\u000b\u0002+B\u0011\u0001BV\u0005\u0003/\n\u0011\u0011#T3tg\u0006<W\rR5ta\u0006$8\r[3s\u0011\u001dIVD1A\u0005\ni\u000bq\u0003Z5ta\u0006$8\r[3s\u0007>tg-[4ve\u0006$xN]:\u0016\u0003m\u0003B\u0001X2fa6\tQL\u0003\u0002_?\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0001\f\u0017\u0001B;uS2T\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e;\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005\u0019lgBA4l!\tAg\"D\u0001j\u0015\tQg!\u0001\u0004=e>|GOP\u0005\u0003Y:\ta\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011AN\u0004\t\u0003\u0011EL!A\u001d\u0002\u0003;5+7o]1hK\u0012K7\u000f]1uG\",'oQ8oM&<WO]1u_JDa\u0001^\u000f!\u0002\u0013Y\u0016\u0001\u00073jgB\fGo\u00195fe\u000e{gNZ5hkJ\fGo\u001c:tA!)a/\bC\u0001o\u00061An\\8lkB$\"!\u0016=\t\u000be,\b\u0019A3\u0002\u0005%$\u0007\"B>\u001e\t\u0003a\u0018!\u00045bg\u0012K7\u000f]1uG\",'\u000fF\u0002~\u0003\u0003\u0001\"!\u0004@\n\u0005}t!a\u0002\"p_2,\u0017M\u001c\u0005\u0006sj\u0004\r!\u001a\u0005\b\u0003\u000biB\u0011BA\u0004\u0003Iawn\\6va\u000e{gNZ5hkJ\fGo\u001c:\u0015\u0007A\fI\u0001\u0003\u0004z\u0003\u0007\u0001\r!\u001a\u0005\b\u0003\u001biB\u0011AA\b\u0003Q\u0011XmZ5ti\u0016\u00148i\u001c8gS\u001e,(/\u0019;peR)Q0!\u0005\u0002\u0014!1\u00110a\u0003A\u0002\u0015Dq!!\u0006\u0002\f\u0001\u0007\u0001/\u0001\u0007d_:4\u0017nZ;sCR|'\u000fC\u0004J;\u0011\u0005A!!\u0007\u0015\u0007\u0019\u000bY\u0002\u0003\u0004z\u0003/\u0001\r!\u001a\u0005\b\u0013v!\t\u0001BA\u0010)\u00151\u0015\u0011EA\u0012\u0011\u0019I\u0018Q\u0004a\u0001K\"9\u0011QEA\u000f\u0001\u00041\u0015!C1qa\u000e{gNZ5h\u0011\u001d\tI#\bC\u0005\u0003W\t\u0001\"\u001b3D_:4\u0017n\u001a\u000b\u0004\r\u00065\u0002BB=\u0002(\u0001\u0007Q\r\u0003\u0005\u00022u!\t\u0001BA\u001a\u0003\u00111'o\\7\u0015\u0007U\u000b)\u0004C\u0004\u00028\u0005=\u0002\u0019\u0001$\u0002\u0007\r4w\rC\u0004\u0002<u!I!!\u0010\u0002!\r|gNZ5hkJ\fGo\u001c:Ge>lGc\u00019\u0002@!9\u0011qGA\u001d\u0001\u00041\u0005")
public class Dispatchers {
    private final ActorSystem.Settings settings;
    private final DispatcherPrerequisites prerequisites;
    private final CachingConfig cachingConfig;
    private final Config defaultDispatcherConfig;
    private final ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators;

    public static String DefaultDispatcherId() {
        return Dispatchers$.MODULE$.DefaultDispatcherId();
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public DispatcherPrerequisites prerequisites() {
        return this.prerequisites;
    }

    public CachingConfig cachingConfig() {
        return this.cachingConfig;
    }

    public Config defaultDispatcherConfig() {
        return this.defaultDispatcherConfig;
    }

    public MessageDispatcher defaultGlobalDispatcher() {
        return this.lookup("akka.actor.default-dispatcher");
    }

    private ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators() {
        return this.dispatcherConfigurators;
    }

    public MessageDispatcher lookup(String id) {
        return this.lookupConfigurator(id).dispatcher();
    }

    public boolean hasDispatcher(String id) {
        return this.dispatcherConfigurators().containsKey(id) || this.cachingConfig().hasPath(id);
    }

    private MessageDispatcherConfigurator lookupConfigurator(String id) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        MessageDispatcherConfigurator messageDispatcherConfigurator2 = this.dispatcherConfigurators().get(id);
        if (messageDispatcherConfigurator2 == null) {
            if (!this.cachingConfig().hasPath(id)) {
                throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dispatcher [", "] not configured"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
            }
            MessageDispatcherConfigurator newConfigurator = this.configuratorFrom(this.config(id));
            MessageDispatcherConfigurator messageDispatcherConfigurator3 = this.dispatcherConfigurators().putIfAbsent(id, newConfigurator);
            MessageDispatcherConfigurator messageDispatcherConfigurator4 = messageDispatcherConfigurator3 == null ? newConfigurator : messageDispatcherConfigurator3;
            messageDispatcherConfigurator = messageDispatcherConfigurator4;
        } else {
            messageDispatcherConfigurator = messageDispatcherConfigurator2;
        }
        return messageDispatcherConfigurator;
    }

    public boolean registerConfigurator(String id, MessageDispatcherConfigurator configurator2) {
        return this.dispatcherConfigurators().putIfAbsent(id, configurator2) == null;
    }

    public Config config(String id) {
        return this.config(id, this.settings().config().getConfig(id));
    }

    public Config config(String id, Config appConfig) {
        return this.idConfig(id).withFallback((ConfigMergeable)appConfig).withFallback((ConfigMergeable)ConfigFactory.parseMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)Dispatchers.simpleName$1(id))}))).asJava()))).withFallback((ConfigMergeable)this.defaultDispatcherConfig());
    }

    private Config idConfig(String id) {
        return ConfigFactory.parseMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)id)}))).asJava()));
    }

    public MessageDispatcher from(Config cfg) {
        return this.configuratorFrom(cfg).dispatcher();
    }

    private MessageDispatcherConfigurator configuratorFrom(Config cfg) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        if (!cfg.hasPath("id")) {
            throw new ConfigurationException("Missing dispatcher 'id' property in config: " + cfg.root().render());
        }
        String string = cfg.getString("type");
        if ("Dispatcher".equals(string)) {
            messageDispatcherConfigurator = new DispatcherConfigurator(cfg, this.prerequisites());
        } else {
            if ("BalancingDispatcher".equals(string)) {
                throw new IllegalArgumentException("BalancingDispatcher is deprecated, use a BalancingPool instead. During a migration period you can still use BalancingDispatcher by specifying the full class name: " + BalancingDispatcherConfigurator.class.getName());
            }
            if ("PinnedDispatcher".equals(string)) {
                messageDispatcherConfigurator = new PinnedDispatcherConfigurator(cfg, this.prerequisites());
            } else {
                List args = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(DispatcherPrerequisites.class), (Object)this.prerequisites())}));
                messageDispatcherConfigurator = (MessageDispatcherConfigurator)this.prerequisites().dynamicAccess().createInstanceFor(string, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)args, ClassTag$.MODULE$.apply(MessageDispatcherConfigurator.class)).recover((PartialFunction)new Serializable(null, cfg, string){
                    public static final long serialVersionUID = 0L;
                    private final Config cfg$1;
                    private final String x1$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        throw new ConfigurationException(new StringOps(Predef$.MODULE$.augmentString("Cannot instantiate MessageDispatcherConfigurator type [%s], defined in [%s], make sure it has constructor with [com.typesafe.config.Config] and [akka.dispatch.DispatcherPrerequisites] parameters")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1, this.cfg$1.getString("id")})), A1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.cfg$1 = cfg$1;
                        this.x1$1 = x1$1;
                    }
                }).get();
            }
        }
        return messageDispatcherConfigurator;
    }

    private static final String simpleName$1(String id$1) {
        return id$1.substring(id$1.lastIndexOf(46) + 1);
    }

    public Dispatchers(ActorSystem.Settings settings, DispatcherPrerequisites prerequisites) {
        this.settings = settings;
        this.prerequisites = prerequisites;
        this.cachingConfig = new CachingConfig(settings.config());
        this.defaultDispatcherConfig = this.idConfig("akka.actor.default-dispatcher").withFallback((ConfigMergeable)settings.config().getConfig("akka.actor.default-dispatcher"));
        this.dispatcherConfigurators = new ConcurrentHashMap();
    }
}

