/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.jmx;

import com.tqdev.metrics.core.MetricRegistry;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class JmxReporter
implements DynamicMBean {
    private final MetricRegistry registry;
    private String description;

    public JmxReporter(MetricRegistry registry) {
        this.registry = registry;
        this.description = "";
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeName cannot be null"), "Cannot call getAttribute with null attribute name");
        }
        if (attributeName.equals("enabled")) {
            return this.registry.isEnabled();
        }
        String type = attributeName;
        if (this.registry.hasType(type)) {
            HashMap<String, Long> items = new HashMap<String, Long>();
            for (String key : this.registry.getKeys(type)) {
                items.put(key, this.registry.get(type, key));
            }
            CompositeDataSupport result = null;
            try {
                result = new CompositeDataSupport(this.getCompositeType(type), items);
            }
            catch (OpenDataException e) {
                e.printStackTrace();
            }
            return result;
        }
        throw new AttributeNotFoundException("Cannot find attribute: " + attributeName);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (!attribute.getName().equals("enabled")) {
            throw new AttributeNotFoundException("No writable attribute has been found");
        }
        this.registry.setEnabled(((Boolean)attribute.getValue()).booleanValue());
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot call getAttributes with null attribute names");
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (String attributeName : attributeNames) {
            try {
                Object value = this.getAttribute(attributeName);
                resultList.add(new Attribute(attributeName, value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    @Override
    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName.equals("reset")) {
            this.registry.reset();
            return null;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("Cannot find operation: " + operationName), "Operation not defined for this OpenMBean");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<OpenMBeanAttributeInfoSupport> attributes = new ArrayList<OpenMBeanAttributeInfoSupport>();
        attributes.add(new OpenMBeanAttributeInfoSupport("enabled", "enabled", SimpleType.BOOLEAN, true, true, true));
        for (String type : this.registry.getTypes()) {
            attributes.add(new OpenMBeanAttributeInfoSupport(type, type, this.getCompositeType(type), true, false, false));
        }
        OpenMBeanParameterInfo[] params = new OpenMBeanParameterInfoSupport[]{};
        OpenMBeanOperationInfoSupport reset = new OpenMBeanOperationInfoSupport("reset", "Reset all Metrics", params, SimpleType.VOID, 1);
        OpenMBeanInfoSupport PSOMBInfo = new OpenMBeanInfoSupport(this.getClass().getName(), this.description, attributes.toArray(new OpenMBeanAttributeInfoSupport[0]), new OpenMBeanConstructorInfoSupport[0], new OpenMBeanOperationInfoSupport[]{reset}, new MBeanNotificationInfo[0]);
        return PSOMBInfo;
    }

    private CompositeType getCompositeType(String type) {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<SimpleType<Long>> typeList = new ArrayList<SimpleType<Long>>();
        for (String key : this.registry.getKeys(type)) {
            nameList.add(key);
            typeList.add(SimpleType.LONG);
        }
        String[] nameArray = nameList.toArray(new String[nameList.size()]);
        OpenType[] typeArray = typeList.toArray(new OpenType[typeList.size()]);
        CompositeType compositeType = null;
        try {
            compositeType = new CompositeType(type, type, nameArray, nameArray, typeArray);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
        }
        return compositeType;
    }

    public void register(String domain, String description) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name;
        this.description = description;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (!mbs.isRegistered(name = new ObjectName(domain + ":type=Metrics"))) {
            mbs.registerMBean(this, name);
        }
    }
}

