/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.SearchParameters;
import com.xebialabs.deployit.plugin.api.udm.CandidateValuesFilter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import nl.javadude.scannit.Scannit;

public class SearchParametersFactory {
    static final long DEFAULT_RESULTS_PER_PAGE = 25L;

    public static com.xebialabs.deployit.repository.SearchParameters createSearchParams(Type type, long page, long resultPerPage) {
        com.xebialabs.deployit.repository.SearchParameters searchParams = new com.xebialabs.deployit.repository.SearchParameters();
        if (type != null) {
            searchParams.setType(type);
        }
        searchParams.setPage(page);
        if (resultPerPage > 0L) {
            searchParams.setResultsPerPage(resultPerPage);
        } else if (resultPerPage == 0L) {
            searchParams.setResultsPerPage(25L);
        }
        return searchParams;
    }

    public static com.xebialabs.deployit.repository.SearchParameters createSearchParams(Type typeName, long page, long resultPerPage, String parent, String ancestor, String namePattern, String idPattern, Calendar lastModifiedBefore, Calendar lastModifiedAfter, int depth) {
        com.xebialabs.deployit.repository.SearchParameters searchParams = SearchParametersFactory.createSearchParams(typeName, page, resultPerPage);
        if (Strings.isNotBlank((String)parent)) {
            searchParams.setParent(parent);
        }
        if (Strings.isNotBlank((String)ancestor)) {
            searchParams.setAncestor(ancestor);
        }
        if (Strings.isNotBlank((String)namePattern)) {
            searchParams.setName(namePattern);
        }
        if (Strings.isNotBlank((String)idPattern)) {
            searchParams.setId(idPattern);
        }
        searchParams.setBefore(lastModifiedBefore);
        searchParams.setAfter(lastModifiedAfter);
        searchParams.setDepth(depth);
        return searchParams;
    }

    public static com.xebialabs.deployit.repository.SearchParameters createSearchParams(Type typeName, long page, long resultPerPage, String parent, String ancestor, String namePattern, Calendar lastModifiedBefore, Calendar lastModifiedAfter, int depth) {
        return SearchParametersFactory.createSearchParams(typeName, page, resultPerPage, parent, ancestor, namePattern, null, lastModifiedBefore, lastModifiedAfter, depth);
    }

    @Deprecated
    public static com.xebialabs.deployit.repository.SearchParameters createSearchParams(Type typeName, long page, long resultPerPage, String parent, String ancestor, String id, Calendar lastModifiedBefore, int depth) {
        return SearchParametersFactory.createSearchParams(typeName, page, resultPerPage, parent, ancestor, id, null, lastModifiedBefore, null, depth);
    }

    @Deprecated
    public static com.xebialabs.deployit.repository.SearchParameters createSearchParams(Type typeName, long page, long resultPerPage, String parent, String id, Calendar lastModifiedBefore, int depth) {
        return SearchParametersFactory.createSearchParams(typeName, page, resultPerPage, parent, null, id, null, lastModifiedBefore, null, depth);
    }

    public static com.xebialabs.deployit.repository.SearchParameters createSearchParamsForCandidateValues(String propertyName, String namePattern, long page, long resultPerPage, ConfigurationItem ci) {
        com.xebialabs.deployit.repository.SearchParameters params;
        PropertyDescriptor pd = ci.getType().getDescriptor().getPropertyDescriptor(propertyName);
        Checks.checkNotNull((Object)pd, (String)"Property %s does not exist on type %s", (Object[])new Object[]{propertyName, ci.getType().getName()});
        Checks.checkArgument((boolean)EnumSet.of(PropertyKind.CI, PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(pd.getKind()), (String)"Property %s of type %s is not of kind CI, LIST_OF_CI or SET_OF_CI", (Object[])new Object[]{propertyName, ci.getType().getName()});
        Set filterMethods = Scannit.getInstance().getMethodsAnnotatedWith(CandidateValuesFilter.class);
        Optional<Method> filterMethod = filterMethods.stream().filter(m -> m.getAnnotation(CandidateValuesFilter.class).name().equals(pd.getCandidateValuesFilter())).findFirst();
        if (filterMethod.isPresent()) {
            try {
                SearchParameters apiParams = (SearchParameters)filterMethod.get().invoke(null, ci, pd);
                params = new com.xebialabs.deployit.repository.SearchParameters(apiParams);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(String.format("Could not access filter method [%s]", pd.getCandidateValuesFilter()), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(String.format("Could not invoke filter method [%s]", pd.getCandidateValuesFilter()), e);
            }
        } else {
            params = new com.xebialabs.deployit.repository.SearchParameters();
            params.setType(pd.getReferencedType());
        }
        params.setName(namePattern);
        params.setPage(page);
        params.setResultsPerPage(resultPerPage);
        return params;
    }
}

