/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.artifacts;

import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactQueries;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactUsageQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Component;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001=\u0011\u0001\u0004\u00122BeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:z\u0015\t\u0019A!A\u0005beRLg-Y2ug*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0019R\u0001\u0001\t\u00175u\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u0005Y\t%\u000f^5gC\u000e$H)\u0019;b%\u0016\u0004xn]5u_JL\bCA\f\u001c\u0013\ta\"AA\tEE\u0006\u0013H/\u001b4bGR\fV/\u001a:jKN\u0004\"a\u0006\u0010\n\u0005}\u0011!A\u0006#c\u0003J$\u0018NZ1diV\u001b\u0018mZ3Rk\u0016\u0014\u0018.Z:\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\nAB\u001b3cGR+W\u000e\u001d7bi\u0016,\u0012a\t\t\u0003I5j\u0011!\n\u0006\u0003M\u001d\nAaY8sK*\u0011\u0001&K\u0001\u0005U\u0012\u00147M\u0003\u0002+W\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001-\u0003\ry'oZ\u0005\u0003]\u0015\u0012AB\u00133cGR+W\u000e\u001d7bi\u0016D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IaI\u0001\u000eU\u0012\u00147\rV3na2\fG/\u001a\u0011\t\u0011I\u0002!Q1A\u0005\u0004M\n!b]9m\t&\fG.Z2u+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u00038\u0015\t1\u0003\"\u0003\u0002:m\tQ1+\u001d7ES\u0006dWm\u0019;\t\u0011m\u0002!\u0011!Q\u0001\nQ\n1b]9m\t&\fG.Z2uA!)Q\b\u0001C\u0001}\u00051A(\u001b8jiz\"\"a\u0010+\u0015\u0005\u0001\u000b\u0005CA\f\u0001\u0011\u0015\u0011D\bq\u00015Q\u0011\t5)\u0014(\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015AC1o]>$\u0018\r^5p]*\u0011\u0001*S\u0001\bM\u0006\u001cGo\u001c:z\u0015\tQ\u0015&A\u0003cK\u0006t7/\u0003\u0002M\u000b\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002\u001f\u0006qQ.Y5o'FdG)[1mK\u000e$\bFA!R!\t!%+\u0003\u0002T\u000b\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006Cq\u0002\ra\t\u0015\u0005)\u000eke+I\u0001X\u0003Ai\u0017-\u001b8KI\n\u001cG+Z7qY\u0006$X\r\u000b\u0002U#\")!\f\u0001C!7\u0006y!/\u001a4Ge>l7\t[3dWN,X\u000e\u0006\u0002]OB\u0011Q\f\u001a\b\u0003=\n\u0004\"a\u0018\n\u000e\u0003\u0001T!!\u0019\b\u0002\rq\u0012xn\u001c;?\u0013\t\u0019'#\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2\u0013\u0011\u0015A\u0017\f1\u0001]\u0003!\u0019\u0007.Z2lgVl\u0007\"\u00026\u0001\t\u0003Z\u0017!B:u_J,G\u0003\u00027p\u0003\u001b\u0001\"!E7\n\u00059\u0014\"\u0001B+oSRDQ\u0001]5A\u0002E\f!\u0001]6\u0011\u0007I\f9AD\u0002t\u0003\u0003q!\u0001\u001e@\u000f\u0005UlhB\u0001<}\u001d\t98P\u0004\u0002yu:\u0011q,_\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA@\u0005\u0003\u0011\u0011\u0017m]3\n\t\u0005\r\u0011QA\u0001\ba\u0006\u001c7.Y4f\u0015\tyH!\u0003\u0003\u0002\n\u0005-!\u0001C\"j!.#\u0016\u0010]3\u000b\t\u0005\r\u0011Q\u0001\u0005\b\u0003\u001fI\u0007\u0019AA\t\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005\u0011\u0011n\u001c\u0006\u0003\u00037\tAA[1wC&!\u0011qDA\u000b\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u00051\u0011N\\:feR$b!a\n\u0002.\u0005E\u0002cA\t\u0002*%\u0019\u00111\u0006\n\u0003\u0007%sG\u000fC\u0004\u00020\u0005\u0005\u0002\u0019\u0001/\u0002\u0005%$\u0007\u0002CA\b\u0003C\u0001\r!!\u0005\t\u000f\u0005U\u0002\u0001\"\u0001\u00028\u00051Q\r_5tiN$B!!\u000f\u0002@A\u0019\u0011#a\u000f\n\u0007\u0005u\"CA\u0004C_>dW-\u00198\t\u000f\u0005=\u00121\u0007a\u00019\"9\u00111\u0005\u0001\u0005B\u0005\rC#\u00027\u0002F\u0005\u001d\u0003B\u00029\u0002B\u0001\u0007\u0011\u000fC\u0004\u0002J\u0005\u0005\u0003\u0019\u0001/\u0002\u0013I,g-\u001a:f]\u000e,\u0007bBA'\u0001\u0011\u0005\u0013qJ\u0001\u0005G>\u0004\u0018\u0010F\u0003m\u0003#\n)\u0006C\u0004\u0002T\u0005-\u0003\u0019\u0001/\u0002\r\u0019\u0014x.\\%e\u0011\u001d\t9&a\u0013A\u0002E\fA\u0001^8QW\"9\u00111\f\u0001\u0005B\u0005u\u0013\u0001\u0003:fiJLWM^3\u0015\t\u0005E\u0011q\f\u0005\b\u0003_\tI\u00061\u0001]\u0011\u001d\t\u0019\u0007\u0001C!\u0003K\na\u0001Z3mKR,Gc\u00017\u0002h!1\u0001/!\u0019A\u0002EDq!a\u001b\u0001\t\u0003\ti'\u0001\u0004sK6|g/\u001a\u000b\u0004Y\u0006=\u0004bBA9\u0003S\u0002\r\u0001X\u0001\u000bCJ$\u0018NZ1di&#\u0007bBA;\u0001\u0011\u0005\u0013qO\u0001\u000fG>,h\u000e^!si&4\u0017m\u0019;t+\t\t9\u0003K\u0002\u0001\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003K\u0013AC:uKJ,w\u000e^=qK&!\u0011QQA@\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class DbArtifactDataRepository
implements ArtifactDataRepository,
DbArtifactQueries,
DbArtifactUsageQueries {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private final String INSERT_USAGE;
    private final String COPY_USAGE;
    private final String SELECT_ARTIFACT_BY_USAGE;
    private final String COUNT_USAGE;
    private final String DELETE_USAGE;
    private final String COUNT_ALL_ARTIFACTS;
    private final String INSERT_ARTIFACT;
    private final String UPDATE_ARTIFACT_ID;
    private final String COUNT_ARTIFACT_BY_ID;
    private final String SELECT_ARTIFACT_BY_PATH;
    private final String DELETE_ARTIFACT;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String INSERT_USAGE() {
        return this.INSERT_USAGE;
    }

    @Override
    public String COPY_USAGE() {
        return this.COPY_USAGE;
    }

    @Override
    public String SELECT_ARTIFACT_BY_USAGE() {
        return this.SELECT_ARTIFACT_BY_USAGE;
    }

    @Override
    public String COUNT_USAGE() {
        return this.COUNT_USAGE;
    }

    @Override
    public String DELETE_USAGE() {
        return this.DELETE_USAGE;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$INSERT_USAGE_$eq(String x$1) {
        this.INSERT_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$COPY_USAGE_$eq(String x$1) {
        this.COPY_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$SELECT_ARTIFACT_BY_USAGE_$eq(String x$1) {
        this.SELECT_ARTIFACT_BY_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$COUNT_USAGE_$eq(String x$1) {
        this.COUNT_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$DELETE_USAGE_$eq(String x$1) {
        this.DELETE_USAGE = x$1;
    }

    @Override
    public String COUNT_ALL_ARTIFACTS() {
        return this.COUNT_ALL_ARTIFACTS;
    }

    @Override
    public String INSERT_ARTIFACT() {
        return this.INSERT_ARTIFACT;
    }

    @Override
    public String UPDATE_ARTIFACT_ID() {
        return this.UPDATE_ARTIFACT_ID;
    }

    @Override
    public String COUNT_ARTIFACT_BY_ID() {
        return this.COUNT_ARTIFACT_BY_ID;
    }

    @Override
    public String SELECT_ARTIFACT_BY_PATH() {
        return this.SELECT_ARTIFACT_BY_PATH;
    }

    @Override
    public String DELETE_ARTIFACT() {
        return this.DELETE_ARTIFACT;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$COUNT_ALL_ARTIFACTS_$eq(String x$1) {
        this.COUNT_ALL_ARTIFACTS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$INSERT_ARTIFACT_$eq(String x$1) {
        this.INSERT_ARTIFACT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$UPDATE_ARTIFACT_ID_$eq(String x$1) {
        this.UPDATE_ARTIFACT_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$COUNT_ARTIFACT_BY_ID_$eq(String x$1) {
        this.COUNT_ARTIFACT_BY_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$SELECT_ARTIFACT_BY_PATH_$eq(String x$1) {
        this.SELECT_ARTIFACT_BY_PATH = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$DELETE_ARTIFACT_$eq(String x$1) {
        this.DELETE_ARTIFACT = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public String refFromChecksum(String checksum) {
        return checksum;
    }

    @Override
    public void store(Integer pk, InputStream inputStream) {
        Object object;
        MessageDigest sha1 = JavaCryptoUtils.getSha1();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, sha1);
        String tempArtifactId = UUID.randomUUID().toString();
        this.insert(tempArtifactId, digestInputStream);
        String checksum = JavaCryptoUtils.digest((MessageDigest)sha1);
        if (this.exists(checksum)) {
            this.remove(tempArtifactId);
            object = BoxedUnit.UNIT;
        } else {
            object = BoxesRunTime.boxToInteger((int)this.jdbcTemplate().update(this.UPDATE_ARTIFACT_ID(), new Object[]{checksum, tempArtifactId}));
        }
        this.insert(pk, checksum);
    }

    public int insert(String id, InputStream inputStream) {
        return this.jdbcTemplate().update(this.INSERT_ARTIFACT(), ps -> {
            ps.setString(1, id);
            ps.setBinaryStream(2, inputStream);
        });
    }

    public boolean exists(String id) {
        return ((Number)this.jdbcTemplate().queryForObject(this.COUNT_ARTIFACT_BY_ID(), Number.class, new Object[]{id})).intValue() > 0;
    }

    @Override
    public void insert(Integer pk, String reference) {
        this.jdbcTemplate().update(this.INSERT_USAGE(), new Object[]{pk, reference});
    }

    @Override
    public void copy(String fromId, Integer toPk) {
        this.jdbcTemplate().update(this.COPY_USAGE(), new Object[]{toPk, fromId});
    }

    @Override
    public InputStream retrieve(String id) {
        return new InputStream(this, id){
            private final Connection con;
            private final PreparedStatement ps;
            private final ResultSet rs;
            private final InputStream delegate;
            private final /* synthetic */ DbArtifactDataRepository $outer;

            private Connection con() {
                return this.con;
            }

            private PreparedStatement ps() {
                return this.ps;
            }

            private ResultSet rs() {
                return this.rs;
            }

            private InputStream delegate() {
                return this.delegate;
            }

            public int read() {
                return this.delegate().read();
            }

            public int read(byte[] b, int off, int len) {
                return this.delegate().read(b, off, len);
            }

            public void close() {
                JdbcUtils.closeResultSet((ResultSet)this.rs());
                JdbcUtils.closeStatement((Statement)this.ps());
                DataSourceUtils.releaseConnection((Connection)this.con(), (DataSource)this.$outer.jdbcTemplate().getDataSource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.con = DataSourceUtils.getConnection((DataSource)$outer.jdbcTemplate().getDataSource());
                this.ps = this.con().prepareStatement($outer.SELECT_ARTIFACT_BY_PATH());
                this.ps().setString(1, package$.MODULE$.idToPath(id$2));
                this.rs = this.ps().executeQuery();
                if (!this.rs().next()) {
                    throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Artifact data not found for: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id$2})), new Object[0]);
                }
                this.delegate = this.rs().getBinaryStream(1);
            }
        };
    }

    @Override
    public void delete(Integer pk) {
        this.jdbcTemplate().queryForList(this.SELECT_ARTIFACT_BY_USAGE(), String.class, new Object[]{pk}).forEach(artifactId -> {
            block0: {
                int count = ((Number)this.jdbcTemplate().queryForObject(this.COUNT_USAGE(), Number.class, new Object[]{artifactId})).intValue();
                Object object = count > 0 ? BoxesRunTime.boxToInteger((int)this.jdbcTemplate().update(this.DELETE_USAGE(), new Object[]{pk})) : BoxedUnit.UNIT;
                if (count != 1) break block0;
                this.remove((String)artifactId);
            }
        });
    }

    public void remove(String artifactId) {
        this.jdbcTemplate().update(this.DELETE_ARTIFACT(), new Object[]{artifactId});
    }

    @Override
    public int countArtifacts() {
        return ((Number)this.jdbcTemplate().queryForObject(this.COUNT_ALL_ARTIFACTS(), Number.class)).intValue();
    }

    public DbArtifactDataRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        DbArtifactQueries.$init$(this);
        DbArtifactUsageQueries.$init$(this);
    }
}

