/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2.messages;

import com.hierynomus.mssmb2.SMB2MessageCommandCode;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.messages.SMB2ChangeNotifyResponse;
import com.hierynomus.mssmb2.messages.SMB2Close;
import com.hierynomus.mssmb2.messages.SMB2CreateResponse;
import com.hierynomus.mssmb2.messages.SMB2Echo;
import com.hierynomus.mssmb2.messages.SMB2Flush;
import com.hierynomus.mssmb2.messages.SMB2IoctlResponse;
import com.hierynomus.mssmb2.messages.SMB2Logoff;
import com.hierynomus.mssmb2.messages.SMB2NegotiateResponse;
import com.hierynomus.mssmb2.messages.SMB2QueryDirectoryResponse;
import com.hierynomus.mssmb2.messages.SMB2QueryInfoResponse;
import com.hierynomus.mssmb2.messages.SMB2ReadResponse;
import com.hierynomus.mssmb2.messages.SMB2SessionSetup;
import com.hierynomus.mssmb2.messages.SMB2SetInfoResponse;
import com.hierynomus.mssmb2.messages.SMB2TreeConnectResponse;
import com.hierynomus.mssmb2.messages.SMB2TreeDisconnect;
import com.hierynomus.mssmb2.messages.SMB2WriteResponse;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.transport.PacketFactory;
import com.hierynomus.smb.SMBBuffer;
import com.hierynomus.smbj.common.Check;
import com.hierynomus.smbj.common.SMBRuntimeException;

public class SMB2MessageConverter
implements PacketFactory<SMB2Packet> {
    private SMB2Packet read(SMBBuffer buffer) throws Buffer.BufferException {
        Check.ensureEquals(buffer.readRawBytes(4), new byte[]{-2, 83, 77, 66}, "Could not find SMB2 Packet header");
        buffer.skip(8);
        SMB2MessageCommandCode command = SMB2MessageCommandCode.lookup(buffer.readUInt16());
        buffer.rpos(0);
        switch (command) {
            case SMB2_NEGOTIATE: {
                return this.read(new SMB2NegotiateResponse(), buffer);
            }
            case SMB2_SESSION_SETUP: {
                return this.read(new SMB2SessionSetup(), buffer);
            }
            case SMB2_TREE_CONNECT: {
                return this.read(new SMB2TreeConnectResponse(), buffer);
            }
            case SMB2_TREE_DISCONNECT: {
                return this.read(new SMB2TreeDisconnect(), buffer);
            }
            case SMB2_LOGOFF: {
                return this.read(new SMB2Logoff(), buffer);
            }
            case SMB2_CREATE: {
                return this.read(new SMB2CreateResponse(), buffer);
            }
            case SMB2_CHANGE_NOTIFY: {
                return this.read(new SMB2ChangeNotifyResponse(), buffer);
            }
            case SMB2_QUERY_DIRECTORY: {
                return this.read(new SMB2QueryDirectoryResponse(), buffer);
            }
            case SMB2_ECHO: {
                return this.read(new SMB2Echo(), buffer);
            }
            case SMB2_READ: {
                return this.read(new SMB2ReadResponse(), buffer);
            }
            case SMB2_CLOSE: {
                return this.read(new SMB2Close(), buffer);
            }
            case SMB2_FLUSH: {
                return this.read(new SMB2Flush(), buffer);
            }
            case SMB2_WRITE: {
                return this.read(new SMB2WriteResponse(), buffer);
            }
            case SMB2_IOCTL: {
                return this.read(new SMB2IoctlResponse(), buffer);
            }
            case SMB2_QUERY_INFO: {
                return this.read(new SMB2QueryInfoResponse(), buffer);
            }
            case SMB2_SET_INFO: {
                return this.read(new SMB2SetInfoResponse(), buffer);
            }
        }
        throw new SMBRuntimeException("Unknown SMB2 Message Command type: " + (Object)((Object)command));
    }

    private SMB2Packet read(SMB2Packet packet, SMBBuffer buffer) throws Buffer.BufferException {
        packet.read(buffer);
        return packet;
    }

    @Override
    public SMB2Packet read(byte[] data) throws Buffer.BufferException {
        return this.read(new SMBBuffer(data));
    }

    @Override
    public boolean canHandle(byte[] data) {
        return data[0] == -2 && data[1] == 83 && data[2] == 77 && data[3] == 66;
    }
}

