/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.server;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpHeaderParser$;
import akka.http.impl.engine.parsing.HttpRequestParser;
import akka.http.impl.engine.parsing.ParserOutput;
import akka.http.impl.engine.rendering.HttpResponseRendererFactory;
import akka.http.impl.engine.rendering.ResponseRenderingContext;
import akka.http.impl.engine.rendering.ResponseRenderingOutput;
import akka.http.impl.engine.server.HttpServerBluePrint;
import akka.http.impl.util.LogByteStringTools$;
import akka.http.impl.util.One2OneBidiFlow$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.IllegalUriException;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.settings.ServerSettings;
import akka.stream.Graph;
import akka.stream.TLSProtocol;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;

@InternalApi
public final class HttpServerBluePrint$ {
    public static HttpServerBluePrint$ MODULE$;
    private final BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SessionBytes, NotUsed> tlsSupport;

    static {
        new HttpServerBluePrint$();
    }

    public BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, NotUsed> apply(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection) {
        return this.userHandlerGuard(settings.pipeliningLimit()).atop(this.requestTimeoutSupport(settings.timeouts().requestTimeout())).atop(this.requestPreparation(settings)).atop(this.controller(settings, log)).atop(this.parsingRendering(settings, log, isSecureConnection)).atop(this.websocketSupport(settings, log)).atop(this.tlsSupport()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("server-plain-text", settings.logUnencryptedNetworkBytes()));
    }

    public BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SessionBytes, NotUsed> tlsSupport() {
        return this.tlsSupport;
    }

    public BidiFlow<ResponseRenderingOutput, ByteString, TLSProtocol.SessionBytes, TLSProtocol.SessionBytes, NotUsed> websocketSupport(ServerSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new HttpServerBluePrint.ProtocolSwitchStage(settings, log));
    }

    public BidiFlow<ResponseRenderingContext, ResponseRenderingOutput, TLSProtocol.SessionBytes, ParserOutput.RequestOutput, NotUsed> parsingRendering(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection) {
        return BidiFlow$.MODULE$.fromFlows(this.rendering(settings, log), this.parsing(settings, log, isSecureConnection));
    }

    public BidiFlow<HttpResponse, ResponseRenderingContext, ParserOutput.RequestOutput, ParserOutput.RequestOutput, NotUsed> controller(ServerSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new HttpServerBluePrint.ControllerStage(settings, log)).reversed();
    }

    public BidiFlow<HttpResponse, HttpResponse, ParserOutput.RequestOutput, HttpRequest, NotUsed> requestPreparation(ServerSettings settings) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply(), (Graph)new HttpServerBluePrint.PrepareRequests(settings));
    }

    public BidiFlow<HttpResponse, HttpResponse, HttpRequest, HttpRequest, NotUsed> requestTimeoutSupport(Duration timeout) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new HttpServerBluePrint.RequestTimeoutSupport(timeout)).reversed();
    }

    public Flow<TLSProtocol.SessionBytes, ParserOutput.RequestOutput, NotUsed> parsing(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection) {
        HttpRequestParser rootParser = new HttpRequestParser(settings.parserSettings(), settings.rawRequestUriHeader(), HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log));
        return (Flow)Flow$.MODULE$.apply().via((Graph)rootParser).map((Function1 & Serializable & scala.Serializable)requestOutput -> HttpServerBluePrint$.establishAbsoluteUri$1(requestOutput, settings, isSecureConnection));
    }

    public Flow<ResponseRenderingContext, ResponseRenderingOutput, NotUsed> rendering(ServerSettings settings, LoggingAdapter log) {
        HttpResponseRendererFactory responseRendererFactory = new HttpResponseRendererFactory(settings.serverHeader(), settings.responseHeaderSizeHint(), log);
        return Flow$.MODULE$.apply().via((Graph)responseRendererFactory.renderer().named("renderer"));
    }

    public BidiFlow<HttpResponse, HttpResponse, HttpRequest, HttpRequest, NotUsed> userHandlerGuard(int pipeliningLimit) {
        return One2OneBidiFlow$.MODULE$.apply(pipeliningLimit, One2OneBidiFlow$.MODULE$.apply$default$2(), One2OneBidiFlow$.MODULE$.apply$default$3()).reversed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ParserOutput.RequestOutput establishAbsoluteUri$1(ParserOutput.RequestOutput requestOutput, ServerSettings settings$1, boolean isSecureConnection$1) {
        scala.Serializable serializable;
        boolean bl = false;
        ParserOutput.RequestStart requestStart = null;
        ParserOutput.RequestOutput requestOutput2 = requestOutput;
        if (requestOutput2 instanceof ParserOutput.RequestStart) {
            bl = true;
            requestStart = (ParserOutput.RequestStart)requestOutput2;
            HttpMethod httpMethod = requestStart.method();
            HttpMethod httpMethod2 = HttpMethods$.MODULE$.CONNECT();
            if (!(httpMethod != null ? !((Object)httpMethod).equals(httpMethod2) : httpMethod2 != null)) {
                return new ParserOutput.MessageStartError(StatusCodes$.MODULE$.BadRequest(), new ErrorInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONNECT requests are not supported"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rejecting CONNECT request to '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestStart.uri()}))));
            }
        }
        if (!bl) return requestOutput2;
        try {
            Uri effectiveUri;
            Uri x$11 = effectiveUri = HttpRequest$.MODULE$.effectiveUri(requestStart.uri(), (scala.collection.immutable.Seq<HttpHeader>)requestStart.headers(), isSecureConnection$1, settings$1.defaultHostHeader());
            HttpMethod x$12 = requestStart.copy$default$1();
            HttpProtocol x$13 = requestStart.copy$default$3();
            List<HttpHeader> x$14 = requestStart.copy$default$4();
            ParserOutput.EntityCreator<ParserOutput.RequestOutput, RequestEntity> x$15 = requestStart.copy$default$5();
            boolean x$16 = requestStart.copy$default$6();
            boolean x$17 = requestStart.copy$default$7();
            serializable = requestStart.copy(x$12, x$11, x$13, x$14, x$15, x$16, x$17);
            return serializable;
        }
        catch (IllegalUriException e) {
            serializable = new ParserOutput.MessageStartError(StatusCodes$.MODULE$.BadRequest(), new ErrorInfo("Request is missing required `Host` header", e.getMessage()));
        }
        return serializable;
    }

    private HttpServerBluePrint$() {
        MODULE$ = this;
        this.tlsSupport = BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1)TLSProtocol.SendBytes$.MODULE$), (Graph)Flow$.MODULE$.apply().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                TLSProtocol.SessionBytes sessionBytes;
                A1 A1 = x1;
                Object object = A1 instanceof TLSProtocol.SessionBytes ? (sessionBytes = (TLSProtocol.SessionBytes)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
                TLSProtocol.SslTlsInbound sslTlsInbound = x1;
                boolean bl = sslTlsInbound instanceof TLSProtocol.SessionBytes;
                return bl;
            }
        }));
    }
}

