/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

class GeneratedDeployablePropertyDescriptor
extends LocalPropertyDescriptor {
    public GeneratedDeployablePropertyDescriptor(LocalDescriptor descriptor, PropertyDescriptor deployedPropertyDescriptor) {
        this.setName(deployedPropertyDescriptor.getName());
        this.setDeclaringDescriptor(descriptor);
        this.initMetadataFromDescriptor(deployedPropertyDescriptor);
    }

    private void initMetadataFromDescriptor(PropertyDescriptor propertyDescriptor) {
        this.setKind(propertyDescriptor.getKind().isSimple() ? PropertyKind.STRING : propertyDescriptor.getKind());
        this.setCategory(propertyDescriptor.getCategory());
        this.setLabel(propertyDescriptor.getLabel());
        this.setRequired(false);
        this.setPassword(propertyDescriptor.isPassword());
        this.setSize(propertyDescriptor.getSize());
        this.initDescription(propertyDescriptor);
    }

    private void initDescription(PropertyDescriptor propertyDescriptor) {
        String description = String.format("%s (%s)", propertyDescriptor.getDescription(), propertyDescriptor.getKind().name().toLowerCase());
        if (propertyDescriptor.getKind() == PropertyKind.ENUM) {
            description = description + String.format(" values(%s)", String.join((CharSequence)", ", propertyDescriptor.getEnumValues()));
        }
        if (propertyDescriptor.getKind().isSimple() && propertyDescriptor.getDefaultValue() != null) {
            description = description + String.format(" default(%s)", propertyDescriptor.getDefaultValue());
        }
        this.setDescription(description);
    }

    public Object get(ConfigurationItem item) {
        return this.getDeclaringDescriptor().getSyntheticPropertyValue(item, this.getName());
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        this.getDeclaringDescriptor().setSyntheticPropertyValue(item, this.getName(), value);
    }
}

