/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.script;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.rzo.yajsw.script.Script;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.wrapper.WrappedProcess;

public abstract class AbstractScript
implements Script {
    String _name;
    int _timeout = 30000;
    WrappedProcess _process;
    String _id;
    String[] _args;
    static final Timer TIMER = new HashedWheelTimer();
    static final ExecutorService EXECUTOR = new ThreadPoolExecutor(0, 50, 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("scriptExecutorInternal"));
    volatile Future _future;
    volatile Timeout _timerTimeout;
    AtomicInteger _remainingConcInvocations;

    public AbstractScript(String script, String id, WrappedProcess process, String[] args, int timeout, int maxConcInvocations) {
        this._name = script;
        this._process = process;
        this._id = id;
        this._args = args;
        if (timeout > 0) {
            this._timeout = timeout * 1000;
        }
        this._remainingConcInvocations = new AtomicInteger(maxConcInvocations);
    }

    @Override
    public abstract Object execute(String var1);

    public abstract void interrupt();

    abstract void log(String var1);

    @Override
    public synchronized void executeWithTimeout(final String line) {
        if (!this.checkRemainConc()) {
            this.log("script: " + this._name + " : too many concurrent invocations -> abort execution");
            return;
        }
        Object result = null;
        this._timerTimeout = TIMER.newTimeout(new TimerTask(){

            public void run(Timeout arg0) throws Exception {
                AbstractScript.this.log("script takes too long -> interrupt");
                try {
                    AbstractScript.this.interrupt();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, (long)this._timeout, TimeUnit.MILLISECONDS);
        this._future = EXECUTOR.submit(new Callable<Object>(){

            @Override
            public Object call() {
                Object result = AbstractScript.this.execute(line);
                if (AbstractScript.this._timerTimeout != null) {
                    AbstractScript.this._timerTimeout.cancel();
                }
                AbstractScript.this._timerTimeout = null;
                AbstractScript.this._remainingConcInvocations.incrementAndGet();
                AbstractScript.this.log("executed script: " + AbstractScript.this._name + " " + AbstractScript.this._remainingConcInvocations);
                return result;
            }
        });
        Thread.yield();
    }

    private boolean checkRemainConc() {
        System.out.println("checkRemainConc " + this._name + " " + this._remainingConcInvocations);
        if (this._remainingConcInvocations.decrementAndGet() < 0) {
            this._remainingConcInvocations.incrementAndGet();
            return false;
        }
        return true;
    }

    @Override
    public String getScript() {
        return this._name;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    @Override
    public String getId() {
        return this._id;
    }
}

