/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os;

import java.io.Serializable;
import org.rzo.yajsw.os.ServiceInfo;
import org.rzo.yajsw.tools.JCLParser;

public class ServiceInfoImpl
implements ServiceInfo,
Serializable,
Comparable<ServiceInfo> {
    private String _account = "?";
    private String _command = "?";
    private String _description = "?";
    private String _name = "?";
    private int _pid = -1;
    private String _startType = "?";
    private int _state = -1;
    private int _wrapperAppPid = -1;
    private String _wrapperConfigurationPath = "?";
    private int _wrapperJmxPort = -1;
    private boolean _interactive = false;
    private String _wrapped = "-";
    private String[] _dependencies;
    private String _displayName;
    private String _host = "localhost";

    @Override
    public String getAccount() {
        return this._account;
    }

    @Override
    public String getCommand() {
        return this._command;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getPid() {
        return this._pid;
    }

    @Override
    public String getStartType() {
        return this._startType;
    }

    @Override
    public int getState() {
        return this._state;
    }

    @Override
    public int getWrapperAppPid() {
        return this._wrapperAppPid;
    }

    @Override
    public String getWrapperConfigurationPath() {
        return this._wrapperConfigurationPath;
    }

    @Override
    public int getWrapperJmxPort() {
        return this._wrapperJmxPort;
    }

    @Override
    public boolean isInteractive() {
        return this._interactive;
    }

    @Override
    public String getWrapped() {
        return this._wrapped;
    }

    public void setAccount(String account) {
        this._account = account;
    }

    public void setCommand(String command) {
        this._command = command.trim();
        JCLParser p = null;
        try {
            p = JCLParser.parse(this._command);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (p == null) {
            return;
        }
        if ("org.rzo.yajsw.boot.WrapperServiceBooter".equals(p.getMainClass())) {
            this._wrapped = "Service";
            for (String option : p.getVmOptions()) {
                if (!option.startsWith("-Dwrapper.config=")) continue;
                this._wrapperConfigurationPath = option.substring("-Dwrapper.config=".length());
            }
        } else if (p.getJar() != null && p.getJar().endsWith("wrapper.jar") && p.getArgs().size() > 1 && p.getArgs().get(0).equals("-c")) {
            this._wrapped = "Console";
            this._wrapperConfigurationPath = p.getArgs().get(1);
        }
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPid(int pid) {
        this._pid = pid;
    }

    public void setStartType(String startType) {
        this._startType = startType;
    }

    public void setState(int state) {
        this._state = state;
    }

    public void setWrapperAppPid(int wrapperAppPid) {
        this._wrapperAppPid = wrapperAppPid;
    }

    public void setWrapperConfigurationPath(String wrapperConfigurationPath) {
        this._wrapperConfigurationPath = wrapperConfigurationPath;
    }

    public void setWrapperJmxPort(int wrapperJmxPort) {
        this._wrapperJmxPort = wrapperJmxPort;
    }

    public void setIsInteractive(boolean istInteractive) {
        this._interactive = istInteractive;
    }

    public void setWrapped(String wrapped) {
        this._wrapped = wrapped;
    }

    @Override
    public String[] getDependencies() {
        return this._dependencies;
    }

    public void setDependencies(String[] dependencies) {
        this._dependencies = dependencies;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    @Override
    public int compareTo(ServiceInfo o) {
        if (this.getDisplayName() != null) {
            return this.getDisplayName().compareTo(o.getDisplayName());
        }
        return 0;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }
}

