/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.log;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.rzo.yajsw.log.PatternFormatter;
import org.rzo.yajsw.os.OperatingSystem;

public class MyFileHandler
extends StreamHandler {
    private static final String LCK_EXT = ".lck";
    private static final int DEFAULT_COUNT = 1;
    private static final int DEFAULT_LIMIT = 0;
    private static final boolean DEFAULT_APPEND = false;
    private static final String DEFAULT_PATTERN = "%h/java%u.log";
    private static final Hashtable<String, FileLock> allLocks = new Hashtable();
    private int count;
    private int limit;
    private boolean append;
    private String pattern;
    private LogManager manager;
    private MeasureOutputStream output;
    private File[] files;
    FileLock lock = null;
    String fileName = null;
    volatile int uniqueID = -1;
    private FileChangeListner _listener = null;
    private boolean desc = false;
    private AtomicInteger descCounter = new AtomicInteger(0);
    private LinkedList<File> oldFiles = new LinkedList();
    private int umask;

    public MyFileHandler() throws IOException {
        this.init(null, null, null, null);
    }

    private void init(String p, Boolean a, Integer l, Integer c) throws IOException {
        this.manager = LogManager.getLogManager();
        this.manager.checkAccess();
        this.initProperties(p, a, l, c);
        this.initOutputFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void initOutputFiles() throws FileNotFoundException, IOException {
        int prevUmask = -1;
        if (this.umask != -1) {
            prevUmask = OperatingSystem.instance().processManagerInstance().umask(this.umask);
        }
        while (true) {
            File f;
            ++this.uniqueID;
            this.files = new File[this.count];
            int k = 0;
            if (!this.desc) {
                for (int generation = 0; generation < this.count; ++generation) {
                    this.files[generation] = new File(MyFileHandler.parseFileName(this.pattern, generation, this.uniqueID, this.count));
                }
            } else {
                for (int i = 0; i < this.count; ++i) {
                    if (i == 0) {
                        this.files[i] = new File(MyFileHandler.parseFileName(this.pattern, i, this.uniqueID, this.count));
                        continue;
                    }
                    this.files[this.count - i] = new File(MyFileHandler.parseFileName(this.pattern, i + k, this.uniqueID, this.count));
                    while (this.files[this.count - i].exists()) {
                        this.oldFiles.addLast(this.files[this.count - i]);
                        this.files[this.count - i] = new File(MyFileHandler.parseFileName(this.pattern, i + ++k, this.uniqueID, this.count));
                    }
                }
            }
            this.descCounter.set(this.count + k);
            this.fileName = this.files[0].getAbsolutePath();
            Hashtable<String, FileLock> hashtable = allLocks;
            // MONITORENTER : hashtable
            if (allLocks.get(this.fileName) != null) {
                // MONITOREXIT : hashtable
                continue;
            }
            if (this.files[0].exists() && (!this.append || this.files[0].length() >= (long)this.limit)) {
                for (int i = this.count - 1; i > 0; --i) {
                    if (this.files[i].exists()) {
                        this.files[i].delete();
                    }
                    this.files[i - 1].renameTo(this.files[i]);
                }
            }
            if (!(f = new File(this.fileName + LCK_EXT)).getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            FileOutputStream fileStream = new FileOutputStream(this.fileName + LCK_EXT);
            FileChannel channel = fileStream.getChannel();
            this.lock = channel.tryLock();
            if (this.lock != null) break;
            MyFileHandler.closeQuietly(fileStream);
            // MONITOREXIT : hashtable
        }
        allLocks.put(this.fileName, this.lock);
        // MONITOREXIT : hashtable
        if (this.append) {
            this.open(this.files[0], true);
        } else {
            this.rotate();
        }
        if (prevUmask == -1) return;
        OperatingSystem.instance().processManagerInstance().umask(prevUmask);
    }

    private synchronized void rotate() {
        Level oldLevel = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        if (this.desc) {
            this.rotateDesc();
        } else {
            this.rotateAsc();
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException ix) {
            this.reportError(null, ix, 4);
        }
        this.setLevel(oldLevel);
    }

    private void rotateAsc() {
        for (int i = this.count - 2; i >= 0; --i) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                f2.delete();
            } else if (this._listener != null) {
                this._listener.fileChange(f2, true);
            }
            f1.renameTo(f2);
        }
    }

    private void rotateDesc() {
        File f0 = this.files[0];
        this.files[0] = new File(f0.getParentFile(), f0.getName());
        File f1 = this.files[this.count - 1];
        f0.renameTo(f1);
        this.oldFiles.addFirst(f1);
        for (int i = this.count - 1; i > 1; --i) {
            this.files[i] = this.files[i - 1];
        }
        try {
            this.files[1] = new File(MyFileHandler.parseFileName(this.pattern, this.descCounter.getAndIncrement(), this.uniqueID, this.count));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.oldFiles.size() > this.count) {
            File f = this.oldFiles.removeLast();
            f.delete();
            if (this._listener != null) {
                this._listener.fileChange(f, true);
            }
        }
    }

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        int prevUmask = -1;
        if (this.umask != -1) {
            prevUmask = OperatingSystem.instance().processManagerInstance().umask(this.umask);
        }
        if (!fname.getParentFile().exists()) {
            fname.getParentFile().mkdirs();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.output = new MeasureOutputStream(bout, len);
        this.setOutputStream(this.output);
        if (prevUmask != -1) {
            OperatingSystem.instance().processManagerInstance().umask(prevUmask);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initProperties(String p, Boolean a, Integer l, Integer c) {
        String className = this.getClass().getName();
        String string = this.pattern = p == null ? this.getStringProperty(className + ".pattern", DEFAULT_PATTERN) : p;
        if (this.pattern == null) {
            throw new NullPointerException("pattern == null");
        }
        if (this.pattern.isEmpty()) {
            throw new NullPointerException("pattern.isEmpty()");
        }
        this.append = a == null ? this.getBooleanProperty(className + ".append", false) : a.booleanValue();
        this.count = c == null ? this.getIntProperty(className + ".count", 1) : c.intValue();
        this.limit = l == null ? this.getIntProperty(className + ".limit", 0) : l.intValue();
        this.count = this.count < 1 ? 1 : this.count;
        this.limit = this.limit < 0 ? 0 : this.limit;
        this.files = new File[this.count];
    }

    void findNextGeneration() {
        super.close();
        for (int i = this.count - 1; i > 0; --i) {
            if (this.files[i].exists()) {
                this.files[i].delete();
            }
            this.files[i - 1].renameTo(this.files[i]);
        }
        try {
            this.output = new MeasureOutputStream(new BufferedOutputStream(new FileOutputStream(this.files[0])));
        }
        catch (FileNotFoundException e1) {
            this.getErrorManager().error("Error opening log file", e1, 4);
        }
        this.setOutputStream(this.output);
    }

    public static String parseFileName(String pattern, int gen, int unique, int count) {
        int cur = 0;
        int next = 0;
        boolean hasUniqueID = false;
        boolean hasGeneration = false;
        String tempPath = System.getProperty("java.io.tmpdir");
        boolean tempPathHasSepEnd = tempPath == null ? false : tempPath.endsWith(File.separator);
        String homePath = System.getProperty("user.home");
        boolean homePathHasSepEnd = homePath == null ? false : homePath.endsWith(File.separator);
        StringBuilder sb = new StringBuilder();
        pattern = pattern.replace('/', File.separatorChar);
        char[] value = pattern.toCharArray();
        while ((next = pattern.indexOf(37, cur)) >= 0) {
            if (++next >= pattern.length()) continue;
            switch (value[next]) {
                case 'g': {
                    sb.append(value, cur, next - cur - 1).append(gen);
                    hasGeneration = true;
                    break;
                }
                case 'u': {
                    sb.append(value, cur, next - cur - 1).append(unique);
                    hasUniqueID = true;
                    break;
                }
                case 't': {
                    sb.append(value, cur, next - cur - 1).append(tempPath);
                    if (tempPathHasSepEnd) break;
                    sb.append(File.separator);
                    break;
                }
                case 'h': {
                    sb.append(value, cur, next - cur - 1).append(homePath);
                    if (homePathHasSepEnd) break;
                    sb.append(File.separator);
                    break;
                }
                case '%': {
                    sb.append(value, cur, next - cur - 1).append('%');
                    break;
                }
                default: {
                    sb.append(value, cur, next - cur);
                }
            }
            cur = ++next;
        }
        sb.append(value, cur, value.length - cur);
        if (!hasGeneration && count > 1 && gen != 0) {
            sb.append(".").append(gen);
        }
        if (!hasUniqueID && unique > 0 && unique != 0) {
            sb.append(".").append(unique);
        }
        return sb.toString();
    }

    public File currentFile() {
        return this.files[0];
    }

    public LinkedList<File> getCurrentFiles() {
        LinkedList<File> result = new LinkedList<File>();
        for (File f : this.files) {
            if (!f.exists()) break;
            result.addLast(f);
        }
        return result;
    }

    public void setNewFileListner(FileChangeListner listener) {
        this._listener = listener;
    }

    private boolean getBooleanProperty(String key, boolean defaultValue) {
        String property = this.manager.getProperty(key);
        if (property == null) {
            return defaultValue;
        }
        boolean result = defaultValue;
        if ("true".equalsIgnoreCase(property)) {
            result = true;
        } else if ("false".equalsIgnoreCase(property)) {
            result = false;
        }
        return result;
    }

    private String getStringProperty(String key, String defaultValue) {
        String property = this.manager.getProperty(key);
        return property == null ? defaultValue : property;
    }

    private int getIntProperty(String key, int defaultValue) {
        String property = this.manager.getProperty(key);
        int result = defaultValue;
        if (property != null) {
            try {
                result = Integer.parseInt(property);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public MyFileHandler(String pattern) throws IOException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
        this.init(pattern, null, 0, 1);
    }

    public MyFileHandler(String pattern, boolean append) throws IOException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
        this.init(pattern, append, 0, 1);
    }

    public MyFileHandler(String pattern, int limit, int count) throws IOException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException("limit < 0 || count < 1");
        }
        this.init(pattern, null, limit, count);
    }

    public MyFileHandler(String pattern, int limit, int count, boolean append) throws IOException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException("limit < 0 || count < 1");
        }
        this.init(pattern, append, limit, count);
    }

    public MyFileHandler(String pattern, int limit, int count, boolean append, boolean desc, int umask) throws IOException {
        this(pattern, limit, count, append);
        this.desc = desc;
        this.umask = umask;
    }

    public MyFileHandler(String pattern, int limit, int count, boolean append, PatternFormatter fileFormatter, Level logLevel, String encoding, boolean desc, int umask) throws IOException {
        this(pattern, limit, count, append);
        this.desc = desc;
        this.umask = umask;
        if (encoding != null) {
            this.setEncoding(encoding);
        }
        this.setFormatter(fileFormatter);
        this.setLevel(logLevel);
    }

    @Override
    public void close() {
        super.close();
        allLocks.remove(this.fileName);
        try {
            FileChannel channel = this.lock.channel();
            this.lock.release();
            channel.close();
            File file = new File(this.fileName + LCK_EXT);
            file.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        super.publish(record);
        this.flush();
        if (this.limit > 0 && this.output.getLength() >= (long)this.limit) {
            this.findNextGeneration();
        }
    }

    static class MeasureOutputStream
    extends OutputStream {
        OutputStream wrapped;
        long length;

        public MeasureOutputStream(OutputStream stream, long currentLength) {
            this.wrapped = stream;
            this.length = currentLength;
        }

        public MeasureOutputStream(OutputStream stream) {
            this(stream, 0L);
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.wrapped.write(oneByte);
            ++this.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.wrapped.write(b, off, len);
            this.length += (long)len;
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public void flush() throws IOException {
            this.wrapped.flush();
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long newLength) {
            this.length = newLength;
        }
    }

    static interface FileChangeListner {
        public void fileChange(File var1, boolean var2);
    }
}

