/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.core.interception.jaxrs.JaxrsInterceptorRegistry;
import org.jboss.resteasy.core.interception.jaxrs.JaxrsInterceptorRegistryListener;
import org.jboss.resteasy.core.interception.jaxrs.PostMatchContainerRequestContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.spi.metadata.ResourceMethod;
import org.jboss.resteasy.spi.validation.GeneralValidator;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;
import org.jboss.resteasy.util.FeatureContextDelegate;

public class ResourceMethodInvoker
implements ResourceInvoker,
JaxrsInterceptorRegistryListener {
    protected MethodInjector methodInjector;
    protected InjectorFactory injector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory parentProviderFactory;
    protected ResteasyProviderFactory resourceMethodProviderFactory;
    protected ResourceMethod method;
    protected Annotation[] methodAnnotations;
    protected ContainerRequestFilter[] requestFilters;
    protected ContainerResponseFilter[] responseFilters;
    protected WriterInterceptor[] writerInterceptors;
    protected ConcurrentHashMap<String, AtomicLong> stats = new ConcurrentHashMap();
    protected GeneralValidator validator;
    protected boolean isValidatable;
    protected boolean methodIsValidatable;
    protected ResourceInfo resourceInfo;
    protected boolean expectsBody;

    public ResourceMethodInvoker(ResourceMethod method, InjectorFactory injector, ResourceFactory resource, ResteasyProviderFactory providerFactory) {
        this.injector = injector;
        this.resource = resource;
        this.parentProviderFactory = providerFactory;
        this.method = method;
        this.methodAnnotations = this.method.getAnnotatedMethod().getAnnotations();
        this.resourceInfo = new ResourceInfo(){

            public Method getResourceMethod() {
                return ResourceMethodInvoker.this.method.getAnnotatedMethod();
            }

            public Class<?> getResourceClass() {
                return ResourceMethodInvoker.this.method.getResourceClass().getClazz();
            }
        };
        this.resourceMethodProviderFactory = new ResteasyProviderFactory(providerFactory);
        for (DynamicFeature feature : providerFactory.getServerDynamicFeatures()) {
            feature.configure(this.resourceInfo, (FeatureContext)new FeatureContextDelegate(this.resourceMethodProviderFactory));
        }
        this.methodInjector = injector.createMethodInjector(method, this.resourceMethodProviderFactory);
        this.expectsBody = this.methodInjector.expectsBody();
        this.requestFilters = this.resourceMethodProviderFactory.getContainerRequestFilterRegistry().postMatch(method.getResourceClass().getClazz(), method.getAnnotatedMethod());
        this.responseFilters = (ContainerResponseFilter[])this.resourceMethodProviderFactory.getContainerResponseFilterRegistry().postMatch(method.getResourceClass().getClazz(), method.getAnnotatedMethod());
        this.writerInterceptors = (WriterInterceptor[])this.resourceMethodProviderFactory.getServerWriterInterceptorRegistry().postMatch(method.getResourceClass().getClazz(), method.getAnnotatedMethod());
        providerFactory.getContainerRequestFilterRegistry().getListeners().add(this);
        providerFactory.getContainerResponseFilterRegistry().getListeners().add(this);
        providerFactory.getServerWriterInterceptorRegistry().getListeners().add(this);
        ContextResolver<GeneralValidator> resolver = providerFactory.getContextResolver(GeneralValidator.class, MediaType.WILDCARD_TYPE);
        if (resolver != null) {
            this.validator = (GeneralValidator)providerFactory.getContextResolver(GeneralValidator.class, MediaType.WILDCARD_TYPE).getContext(null);
        }
        if (this.validator != null) {
            this.isValidatable = this.validator instanceof GeneralValidatorCDI ? ((GeneralValidatorCDI)GeneralValidatorCDI.class.cast(this.validator)).isValidatable(this.getMethod().getDeclaringClass(), injector) : this.validator.isValidatable(this.getMethod().getDeclaringClass());
            this.methodIsValidatable = this.validator.isMethodValidatable(this.getMethod());
        }
    }

    public void cleanup() {
        this.parentProviderFactory.getContainerRequestFilterRegistry().getListeners().remove(this);
        this.parentProviderFactory.getContainerResponseFilterRegistry().getListeners().remove(this);
        this.parentProviderFactory.getServerWriterInterceptorRegistry().getListeners().remove(this);
        for (ValueInjector param : this.methodInjector.getParams()) {
            if (!(param instanceof MessageBodyParameterInjector)) continue;
            this.parentProviderFactory.getServerReaderInterceptorRegistry().getListeners().remove(param);
        }
    }

    @Override
    public void registryUpdated(JaxrsInterceptorRegistry registry) {
        this.resourceMethodProviderFactory = new ResteasyProviderFactory(this.parentProviderFactory);
        for (DynamicFeature feature : this.parentProviderFactory.getServerDynamicFeatures()) {
            feature.configure(this.resourceInfo, (FeatureContext)new FeatureContextDelegate(this.resourceMethodProviderFactory));
        }
        if (registry.getIntf().equals(WriterInterceptor.class)) {
            this.writerInterceptors = (WriterInterceptor[])this.resourceMethodProviderFactory.getServerWriterInterceptorRegistry().postMatch(this.method.getResourceClass().getClazz(), this.method.getAnnotatedMethod());
        } else if (registry.getIntf().equals(ContainerRequestFilter.class)) {
            this.requestFilters = this.resourceMethodProviderFactory.getContainerRequestFilterRegistry().postMatch(this.method.getResourceClass().getClazz(), this.method.getAnnotatedMethod());
        } else if (registry.getIntf().equals(ContainerResponseFilter.class)) {
            this.responseFilters = (ContainerResponseFilter[])this.resourceMethodProviderFactory.getContainerResponseFilterRegistry().postMatch(this.method.getResourceClass().getClazz(), this.method.getAnnotatedMethod());
        }
    }

    protected void incrementMethodCount(String httpMethod) {
        AtomicLong old;
        AtomicLong stat = this.stats.get(httpMethod);
        if (stat == null && (old = this.stats.putIfAbsent(httpMethod, stat = new AtomicLong())) != null) {
            stat = old;
        }
        stat.incrementAndGet();
    }

    public Map<String, AtomicLong> getStats() {
        return this.stats;
    }

    public ContainerRequestFilter[] getRequestFilters() {
        return this.requestFilters;
    }

    public ContainerResponseFilter[] getResponseFilters() {
        return this.responseFilters;
    }

    public WriterInterceptor[] getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public Class<?> getResourceClass() {
        return this.method.getResourceClass().getClazz();
    }

    public Annotation[] getMethodAnnotations() {
        return this.methodAnnotations;
    }

    @Override
    public Method getMethod() {
        return this.method.getMethod();
    }

    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response) {
        Object target = this.resource.createResource(request, response, this.resourceMethodProviderFactory);
        return this.invoke(request, response, target);
    }

    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response, Object target) {
        request.setAttribute(ResourceMethodInvoker.class.getName(), this);
        this.incrementMethodCount(request.getHttpMethod());
        ResteasyUriInfo uriInfo = request.getUri();
        if (this.method.getPath() != null) {
            uriInfo.pushMatchedURI(uriInfo.getMatchingPath());
        }
        uriInfo.pushCurrentResource(target);
        BuiltResponse rtn = this.invokeOnTarget(request, response, target);
        return rtn;
    }

    protected BuiltResponse invokeOnTarget(HttpRequest request, HttpResponse response, Object target) {
        ResteasyProviderFactory.pushContext(ResourceInfo.class, this.resourceInfo);
        PostMatchContainerRequestContext requestContext = new PostMatchContainerRequestContext(request, this);
        for (ContainerRequestFilter filter : this.requestFilters) {
            try {
                filter.filter((ContainerRequestContext)requestContext);
            }
            catch (IOException e) {
                throw new ApplicationException(e);
            }
            BuiltResponse serverResponse = (BuiltResponse)requestContext.getResponseAbortedWith();
            if (serverResponse == null) continue;
            return serverResponse;
        }
        if (this.validator != null) {
            if (this.isValidatable) {
                this.validator.validate(request, target, new Class[0]);
            }
            if (this.methodIsValidatable) {
                request.setAttribute(GeneralValidator.class.getName(), this.validator);
            } else if (this.isValidatable) {
                this.validator.checkViolations(request);
            }
        }
        Object rtn = null;
        try {
            rtn = this.methodInjector.invoke(request, response, target);
        }
        catch (RuntimeException ex) {
            if (request.getAsyncContext().isSuspended()) {
                try {
                    request.getAsyncContext().getAsyncResponse().resume(ex);
                }
                catch (Exception e) {
                    LogMessages.LOGGER.errorResumingFailedAsynchOperation(e);
                }
                return null;
            }
            throw ex;
        }
        if (request.getAsyncContext().isSuspended() || request.wasForwarded()) {
            return null;
        }
        if (rtn == null || this.method.getReturnType().equals(Void.TYPE)) {
            BuiltResponse build = (BuiltResponse)Response.noContent().build();
            build.addMethodAnnotations(this.getMethodAnnotations());
            return build;
        }
        if (Response.class.isAssignableFrom(this.method.getReturnType()) || rtn instanceof Response) {
            if (!(rtn instanceof BuiltResponse)) {
                Response r = (Response)rtn;
                Headers<Object> metadata = new Headers<Object>();
                metadata.putAll(r.getMetadata());
                rtn = new BuiltResponse(r.getStatus(), metadata, r.getEntity(), null);
            }
            BuiltResponse rtn1 = (BuiltResponse)((Object)rtn);
            rtn1.addMethodAnnotations(this.getMethodAnnotations());
            if (rtn1.getGenericType() == null) {
                if (this.getMethod().getReturnType().equals(Response.class)) {
                    rtn1.setGenericType(rtn1.getEntityClass());
                } else {
                    rtn1.setGenericType(this.method.getGenericReturnType());
                }
            }
            return rtn1;
        }
        Response.ResponseBuilder builder = Response.ok((Object)rtn);
        BuiltResponse jaxrsResponse = (BuiltResponse)builder.build();
        if (jaxrsResponse.getGenericType() == null) {
            if (this.getMethod().getReturnType().equals(Response.class)) {
                jaxrsResponse.setGenericType(jaxrsResponse.getEntityClass());
            } else {
                jaxrsResponse.setGenericType(this.method.getGenericReturnType());
            }
        }
        jaxrsResponse.addMethodAnnotations(this.getMethodAnnotations());
        return jaxrsResponse;
    }

    public void initializeAsync(ResteasyAsynchronousResponse asyncResponse) {
        asyncResponse.setAnnotations(this.method.getAnnotatedMethod().getAnnotations());
        asyncResponse.setWriterInterceptors(this.writerInterceptors);
        asyncResponse.setResponseFilters(this.responseFilters);
        asyncResponse.setMethod(this);
    }

    public boolean doesProduce(List<? extends MediaType> accepts) {
        if (accepts == null || accepts.size() == 0) {
            return true;
        }
        if (this.method.getProduces().length == 0) {
            return true;
        }
        for (MediaType mediaType : accepts) {
            for (MediaType type : this.method.getProduces()) {
                if (!type.isCompatible(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doesConsume(MediaType contentType) {
        boolean matches = false;
        if (this.method.getConsumes().length == 0 || contentType == null && !this.expectsBody) {
            return true;
        }
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        for (MediaType type : this.method.getConsumes()) {
            if (!type.isCompatible(contentType)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public MediaType resolveContentType(HttpRequest in, Object entity) {
        MediaType chosen = (MediaType)in.getAttribute("RESTEASY_CHOSEN_ACCEPT");
        if (chosen != null && !chosen.equals((Object)MediaType.WILDCARD_TYPE)) {
            return chosen;
        }
        List accepts = in.getHttpHeaders().getAcceptableMediaTypes();
        if (accepts == null || accepts.size() == 0) {
            if (this.method.getProduces().length == 0) {
                return MediaType.WILDCARD_TYPE;
            }
            return this.method.getProduces()[0];
        }
        if (this.method.getProduces().length == 0) {
            return this.resolveContentTypeByAccept(accepts, entity);
        }
        for (MediaType accept : accepts) {
            for (MediaType type : this.method.getProduces()) {
                if (!type.isCompatible(accept)) continue;
                return type;
            }
        }
        return MediaType.WILDCARD_TYPE;
    }

    protected MediaType resolveContentTypeByAccept(List<MediaType> accepts, Object entity) {
        if (accepts == null || accepts.size() == 0 || entity == null) {
            return MediaType.WILDCARD_TYPE;
        }
        Class clazz = entity.getClass();
        Type type = this.method.getGenericReturnType();
        if (entity instanceof GenericEntity) {
            GenericEntity gen = (GenericEntity)entity;
            clazz = gen.getRawType();
            type = gen.getType();
        }
        for (MediaType accept : accepts) {
            if (this.resourceMethodProviderFactory.getMessageBodyWriter(clazz, type, this.method.getAnnotatedMethod().getAnnotations(), accept) == null) continue;
            return accept;
        }
        return MediaType.WILDCARD_TYPE;
    }

    public Set<String> getHttpMethods() {
        return this.method.getHttpMethods();
    }

    public MediaType[] getProduces() {
        return this.method.getProduces();
    }

    public MediaType[] getConsumes() {
        return this.method.getConsumes();
    }
}

