/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.UserManagerConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.config.WorkspaceSecurityConfig;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.DefaultAccessManager;
import org.apache.jackrabbit.core.security.JackrabbitSecurityManager;
import org.apache.jackrabbit.core.security.SecurityConstants;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authentication.AuthContextProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlProviderFactory;
import org.apache.jackrabbit.core.security.authorization.AccessControlProviderFactoryImpl;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.DefaultPrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.apache.jackrabbit.core.security.principal.ProviderRegistryImpl;
import org.apache.jackrabbit.core.security.user.MembershipCache;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.core.security.user.action.AuthorizableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityManager
implements JackrabbitSecurityManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecurityManager.class);
    private boolean initialized;
    private RepositoryImpl repository;
    private SystemSession systemSession;
    private UserManager systemUserManager;
    protected String adminId;
    protected String anonymousId;
    private final Map<String, AccessControlProvider> acProviders = new HashMap<String, AccessControlProvider>();
    private AccessControlProviderFactory acProviderFactory;
    private WorkspaceAccessManager workspaceAccessManager;
    private PrincipalProviderRegistry principalProviderRegistry;
    private AuthContextProvider authContextProvider;

    @Override
    public synchronized void init(Repository repository, Session systemSession) throws RepositoryException {
        Properties[] moduleConfig;
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        if (!(repository instanceof RepositoryImpl)) {
            throw new RepositoryException("RepositoryImpl expected");
        }
        if (!(systemSession instanceof SystemSession)) {
            throw new RepositoryException("SystemSession expected");
        }
        this.systemSession = (SystemSession)systemSession;
        this.repository = (RepositoryImpl)repository;
        SecurityConfig config = this.repository.getConfig().getSecurityConfig();
        LoginModuleConfig loginModConf = config.getLoginModuleConfig();
        this.authContextProvider = new AuthContextProvider(config.getAppName(), loginModConf);
        if (this.authContextProvider.isLocal()) {
            log.info("init: use Repository Login-Configuration for " + config.getAppName());
        } else if (this.authContextProvider.isJAAS()) {
            log.info("init: use JAAS login-configuration for " + config.getAppName());
        } else {
            String msg = "Neither JAAS nor RepositoryConfig contained a valid configuration for " + config.getAppName();
            log.error(msg);
            throw new RepositoryException(msg);
        }
        for (Properties props : moduleConfig = this.authContextProvider.getModuleConfig()) {
            if (props.containsKey("adminId")) {
                this.adminId = props.getProperty("adminId");
            }
            if (!props.containsKey("anonymousId")) continue;
            this.anonymousId = props.getProperty("anonymousId");
        }
        if (this.adminId == null) {
            log.debug("No adminID defined in LoginModule/JAAS config -> using default.");
            this.adminId = "admin";
        }
        if (this.anonymousId == null) {
            log.debug("No anonymousID defined in LoginModule/JAAS config -> using default.");
            this.anonymousId = "anonymous";
        }
        this.systemUserManager = this.createUserManager(this.systemSession);
        DefaultSecurityManager.createSystemUsers(this.systemUserManager, this.systemSession, this.adminId, this.anonymousId);
        this.acProviderFactory = new AccessControlProviderFactoryImpl();
        this.acProviderFactory.init((Session)this.systemSession);
        SecurityManagerConfig smc = config.getSecurityManagerConfig();
        if (smc != null && smc.getWorkspaceAccessConfig() != null) {
            this.workspaceAccessManager = smc.getWorkspaceAccessConfig().newInstance(WorkspaceAccessManager.class);
        } else {
            log.debug("No WorkspaceAccessManager configured; using default.");
            this.workspaceAccessManager = this.createDefaultWorkspaceAccessManager();
        }
        this.workspaceAccessManager.init((Session)this.systemSession);
        PrincipalProvider defaultPP = this.createDefaultPrincipalProvider(moduleConfig);
        this.principalProviderRegistry = new ProviderRegistryImpl(defaultPP);
        for (Properties props : moduleConfig) {
            this.principalProviderRegistry.registerProvider(props);
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(String workspaceName) {
        this.checkInitialized();
        Map<String, AccessControlProvider> map = this.acProviders;
        synchronized (map) {
            AccessControlProvider prov = this.acProviders.remove(workspaceName);
            if (prov != null) {
                prov.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.checkInitialized();
        Map<String, AccessControlProvider> map = this.acProviders;
        synchronized (map) {
            for (AccessControlProvider accessControlProvider : this.acProviders.values()) {
                accessControlProvider.close();
            }
            this.acProviders.clear();
        }
    }

    @Override
    public AccessManager getAccessManager(Session session, AMContext amContext) throws RepositoryException {
        this.checkInitialized();
        AccessManagerConfig amConfig = this.repository.getConfig().getSecurityConfig().getAccessManagerConfig();
        try {
            AccessManager accessMgr;
            String wspName = session.getWorkspace().getName();
            AccessControlProvider pp = this.getAccessControlProvider(wspName);
            if (amConfig == null) {
                log.debug("No configuration entry for AccessManager. Using org.apache.jackrabbit.core.security.DefaultAccessManager");
                accessMgr = new DefaultAccessManager();
            } else {
                accessMgr = amConfig.newInstance(AccessManager.class);
            }
            accessMgr.init(amContext, pp, this.workspaceAccessManager);
            return accessMgr;
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            String clsName = amConfig == null ? "-- missing access manager configuration --" : amConfig.getClassName();
            String msg = "Failed to instantiate AccessManager (" + clsName + ")";
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    @Override
    public PrincipalManager getPrincipalManager(Session session) throws RepositoryException {
        this.checkInitialized();
        if (session instanceof SessionImpl) {
            SessionImpl sImpl = (SessionImpl)session;
            return this.createPrincipalManager(sImpl);
        }
        throw new RepositoryException("Internal error: SessionImpl expected.");
    }

    @Override
    public UserManager getUserManager(Session session) throws RepositoryException {
        this.checkInitialized();
        if (session == this.systemSession) {
            return this.systemUserManager;
        }
        if (session instanceof SessionImpl) {
            String workspaceName = this.systemSession.getWorkspace().getName();
            try {
                UserManagerImpl uMgr;
                SessionImpl sImpl = (SessionImpl)session;
                if (workspaceName.equals(sImpl.getWorkspace().getName())) {
                    uMgr = this.createUserManager(sImpl);
                } else {
                    SessionImpl s = (SessionImpl)sImpl.createSession(workspaceName);
                    uMgr = this.createUserManager(s);
                    sImpl.addListener(uMgr);
                }
                return uMgr;
            }
            catch (NoSuchWorkspaceException e) {
                throw new AccessControlException("Cannot build UserManager for " + session.getUserID(), (Throwable)e);
            }
        }
        throw new RepositoryException("Internal error: SessionImpl expected.");
    }

    @Override
    public String getUserID(Subject subject, String workspaceName) throws RepositoryException {
        Iterator<SimpleCredentials> creds;
        this.checkInitialized();
        if (!subject.getPrincipals(AdminPrincipal.class).isEmpty()) {
            return this.adminId;
        }
        if (!subject.getPrincipals(SystemPrincipal.class).isEmpty()) {
            return null;
        }
        Class cl = this.getConfig().getUserIdClass();
        if (cl != null) {
            Set s = subject.getPrincipals(cl);
            if (!s.isEmpty()) {
                for (Principal p : s) {
                    if (p instanceof Group) continue;
                    return p.getName();
                }
                log.debug("Only Group principals found with class '" + cl.getName() + "' -> Not used for UserID.");
            } else {
                log.debug("No principal found with class '" + cl.getName() + "'.");
            }
        }
        String uid = null;
        try {
            UserManager umgr = this.getSystemUserManager(workspaceName);
            for (Principal p : subject.getPrincipals()) {
                Authorizable authorz;
                if (p instanceof org.apache.jackrabbit.api.security.user.Group || (authorz = umgr.getAuthorizable(p)) == null || authorz.isGroup()) continue;
                uid = authorz.getID();
                break;
            }
        }
        catch (RepositoryException e) {
            log.error("Unexpected error while retrieving UserID.", (Throwable)e);
        }
        if (uid == null && (creds = subject.getPublicCredentials(SimpleCredentials.class).iterator()).hasNext()) {
            SimpleCredentials sc = creds.next();
            uid = sc.getUserID();
        }
        return uid;
    }

    @Override
    public AuthContext getAuthContext(Credentials creds, Subject subject, String workspaceName) throws RepositoryException {
        this.checkInitialized();
        return this.getAuthContextProvider().getAuthContext(creds, subject, (Session)this.systemSession, this.getPrincipalProviderRegistry(), this.adminId, this.anonymousId);
    }

    protected SecurityManagerConfig getConfig() {
        return this.repository.getConfig().getSecurityConfig().getSecurityManagerConfig();
    }

    protected UserManager getSystemUserManager(String workspaceName) throws RepositoryException {
        return this.systemUserManager;
    }

    protected MembershipCache getMembershipCache(SessionImpl session) throws RepositoryException {
        if (session == this.systemSession || session instanceof SystemSession) {
            return null;
        }
        return ((UserManagerImpl)this.getSystemUserManager(session.getWorkspace().getName())).getMembershipCache();
    }

    protected UserManagerImpl createUserManager(SessionImpl session) throws RepositoryException {
        UserManagerImpl um;
        UserManagerConfig umc = this.getConfig().getUserManagerConfig();
        if (umc != null) {
            Class[] paramTypes = new Class[]{SessionImpl.class, String.class, Properties.class, MembershipCache.class};
            um = (UserManagerImpl)umc.getUserManager(UserManagerImpl.class, paramTypes, new Object[]{session, this.adminId, umc.getParameters(), this.getMembershipCache(session)});
        } else {
            um = new UserManagerImpl(session, this.adminId, null, this.getMembershipCache(session));
        }
        if (umc != null && !(session instanceof SystemSession)) {
            AuthorizableAction[] actions = umc.getAuthorizableActions();
            um.setAuthorizableActions(actions);
        }
        return um;
    }

    protected PrincipalManager createPrincipalManager(SessionImpl session) throws RepositoryException {
        return new PrincipalManagerImpl((Session)session, this.getPrincipalProviderRegistry().getProviders());
    }

    protected WorkspaceAccessManager createDefaultWorkspaceAccessManager() {
        return new WorkspaceAccessManagerImpl();
    }

    protected PrincipalProvider createDefaultPrincipalProvider(Properties[] moduleConfig) throws RepositoryException {
        boolean initialized = false;
        DefaultPrincipalProvider defaultPP = new DefaultPrincipalProvider((Session)this.systemSession, (UserManagerImpl)this.systemUserManager);
        for (Properties props : moduleConfig) {
            if (props.containsKey("principalProvider") || !props.containsKey("cacheMaxSize")) continue;
            defaultPP.init(props);
            initialized = true;
            break;
        }
        if (!initialized) {
            defaultPP.init(new Properties());
        }
        return defaultPP;
    }

    protected PrincipalProviderRegistry getPrincipalProviderRegistry() {
        return this.principalProviderRegistry;
    }

    protected AuthContextProvider getAuthContextProvider() {
        return this.authContextProvider;
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    protected Session getSystemSession() {
        return this.systemSession;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessControlProvider getAccessControlProvider(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.checkInitialized();
        AccessControlProvider provider = this.acProviders.get(workspaceName);
        if (provider == null || !provider.isLive()) {
            this.repository.markWorkspaceActive(workspaceName);
            WorkspaceSecurityConfig secConf = null;
            WorkspaceConfig conf = this.repository.getConfig().getWorkspaceConfig(workspaceName);
            if (conf != null) {
                secConf = conf.getSecurityConfig();
            }
            provider = this.acProviderFactory.createProvider((Session)this.repository.getSystemSession(workspaceName), secConf);
            Map<String, AccessControlProvider> map = this.acProviders;
            synchronized (map) {
                this.acProviders.put(workspaceName, provider);
            }
        }
        return provider;
    }

    static void createSystemUsers(UserManager userManager, SystemSession session, String adminId, String anonymousId) throws RepositoryException {
        Authorizable anonymous;
        Authorizable admin;
        if (adminId != null && (admin = userManager.getAuthorizable(adminId)) == null) {
            userManager.createUser(adminId, adminId);
            if (!userManager.isAutoSave()) {
                session.save();
            }
            log.info("... created admin-user with id '" + adminId + "' ...");
        }
        if (anonymousId != null && (anonymous = userManager.getAuthorizable(anonymousId)) == null) {
            try {
                userManager.createUser(anonymousId, "");
                if (!userManager.isAutoSave()) {
                    session.save();
                }
                log.info("... created anonymous user with id '" + anonymousId + "' ...");
            }
            catch (RepositoryException e) {
                log.error("Failed to create anonymous user.", (Throwable)e);
            }
        }
    }

    private final class WorkspaceAccessManagerImpl
    implements SecurityConstants,
    WorkspaceAccessManager {
        private WorkspaceAccessManagerImpl() {
        }

        @Override
        public void init(Session systemSession) throws RepositoryException {
        }

        @Override
        public void close() throws RepositoryException {
        }

        @Override
        public boolean grants(Set<Principal> principals, String workspaceName) throws RepositoryException {
            AccessControlProvider prov = DefaultSecurityManager.this.getAccessControlProvider(workspaceName);
            return prov.canAccessRoot(principals);
        }
    }
}

