/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import com.xebialabs.deployit.task.MigrationStatus;
import com.xebialabs.deployit.task.archive.jcr.JcrArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.archive.jcr.JcrTaskArchive;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;
import scala.reflect.ScalaSignature;

@Component
@ManagedResource(objectName="com.xebialabs.xldeploy.migration:name=ArchiveMigrationStatistics", description="MBean to track progress of archive migration")
@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011!$\u0011:dQ&4X-T5he\u0006$\u0018n\u001c8Ti\u0006$\u0018n\u001d;jGNT!a\u0001\u0003\u0002\rM\u0004(/\u001b8h\u0015\t)a!\u0001\u0005eKBdw._5u\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u000fU\u000e\u0014H+Y:l\u0003J\u001c\u0007.\u001b<f!\t)B$D\u0001\u0017\u0015\t9\u0002$A\u0002kGJT!!\u0007\u000e\u0002\u000f\u0005\u00148\r[5wK*\u00111\u0004B\u0001\u0005i\u0006\u001c8.\u0003\u0002\u001e-\tq!j\u0019:UCN\\\u0017I]2iSZ,\u0007F\u0001\n !\t\u00013&D\u0001\"\u0015\t\u00113%\u0001\u0006b]:|G/\u0019;j_:T!\u0001J\u0013\u0002\u000f\u0019\f7\r^8ss*\u0011aeJ\u0001\u0006E\u0016\fgn\u001d\u0006\u0003Q%\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002U\u0005\u0019qN]4\n\u00051\n#!C!vi><\u0018N]3e\u0011\u0015q\u0003\u0001\"\u00010\u0003\u0019a\u0014N\\5u}Q\u0011\u0001G\r\t\u0003c\u0001i\u0011A\u0001\u0005\u0006'5\u0002\r\u0001\u0006\u0015\u0003e}AQ!\u000e\u0001\u0005\u0002Y\nAbZ3u)>\u0004&o\\2fgN,\u0012a\u000e\t\u0003\u001baJ!!\u000f\b\u0003\t1{gn\u001a\u0015\u0005im\"U\t\u0005\u0002=\u00056\tQH\u0003\u0002#})\u0011q\bQ\u0001\u0007Kb\u0004xN\u001d;\u000b\u0005\u0005;\u0013a\u00016nq&\u00111)\u0010\u0002\u0011\u001b\u0006t\u0017mZ3e\u0003R$(/\u001b2vi\u0016\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\na)A\u0014UQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011be\u000eD\u0017N^3eAQ\f7o[:!i>\u0004\u0003O]8dKN\u001c\b\"\u0002%\u0001\t\u00031\u0014aC4fi6KwM]1uK\u0012DCaR\u001eE\u0015\u0006\n1*A\u0013UQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011be\u000eD\u0017N^3eAQ\f7o[:![&<'/\u0019;fI\")Q\n\u0001C\u0001m\u0005\tr-\u001a;GC&dW\r\u001a+p\u0013:\u001cXM\u001d;)\t1[DiT\u0011\u0002!\u0006iC\u000b[3!]Vl'-\u001a:!_\u001a\u0004\u0013M]2iSZ,G\r\t;bg.\u001c\bEZ1jY\u0016$\u0007\u0005^8!S:\u001cXM\u001d;\t\u000bI\u0003A\u0011\u0001\u001c\u0002#\u001d,GOR1jY\u0016$Gk\u001c#fY\u0016$X\r\u000b\u0003Rw\u0011#\u0016%A+\u0002[QCW\r\t8v[\n,'\u000fI8gA\u0005\u00148\r[5wK\u0012\u0004C/Y:lg\u00022\u0017-\u001b7fI\u0002\"x\u000e\t3fY\u0016$X\rC\u0003X\u0001\u0011\u0005a'A\u0006hKR,\u0005\u0010]8si\u0016$\u0007\u0006\u0002,<\tf\u000b\u0013AW\u0001&)\",\u0007E\\;nE\u0016\u0014\be\u001c4!CJ\u001c\u0007.\u001b<fI\u0002\"\u0018m]6tA\u0015D\bo\u001c:uK\u0012DQ\u0001\u0018\u0001\u0005\nu\u000bQbY8v]R\u0014\u0015p\u0015;biV\u001cHCA\u001c_\u0011\u0015y6\f1\u0001a\u0003\u0019\u0019H/\u0019;vgB\u0011\u0011MY\u0007\u00025%\u00111M\u0007\u0002\u0010\u001b&<'/\u0019;j_:\u001cF/\u0019;vg\")Q\r\u0001C\u0005M\u0006y1m\\;oi\nK8\u000b^1ukN,7\u000f\u0006\u00028O\")\u0001\u000e\u001aa\u0001S\u0006A1\u000f^1ukN,7\u000fE\u0002k_\u0002l\u0011a\u001b\u0006\u0003Y6\fA!\u001e;jY*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\u0011a\u0015n\u001d;)\r\u0001\u0011XO\u001e#y!\ta4/\u0003\u0002u{\tyQ*\u00198bO\u0016$'+Z:pkJ\u001cW-\u0001\u0006pE*,7\r\u001e(b[\u0016\f\u0013a^\u0001AG>lg\u0006_3cS\u0006d\u0017MY:/q2$W\r\u001d7ps:j\u0017n\u001a:bi&|gN\u000f8b[\u0016l\u0014I]2iSZ,W*[4sCRLwN\\*uCRL7\u000f^5dg\u0006\n\u00110\u0001\u0017N\u0005\u0016\fg\u000e\t;pAQ\u0014\u0018mY6!aJ|wM]3tg\u0002zg\rI1sG\"Lg/\u001a\u0011nS\u001e\u0014\u0018\r^5p]\"\u0012\u0001a\u001f\t\u0003y~l\u0011! \u0006\u0003}\u001e\n!b\u001d;fe\u0016|G/\u001f9f\u0013\r\t\t! \u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class ArchiveMigrationStatistics {
    @Autowired
    private final JcrTaskArchive jcrTaskArchive;

    @ManagedAttribute(description="The number of archived tasks to process")
    public long getToProcess() {
        return this.countByStatuses(Collections.emptyList());
    }

    @ManagedAttribute(description="The number of archived tasks migrated")
    public long getMigrated() {
        return this.countByStatus(MigrationStatus.MIGRATED);
    }

    @ManagedAttribute(description="The number of archived tasks failed to insert")
    public long getFailedToInsert() {
        return this.countByStatus(MigrationStatus.FAILED_TO_INSERT);
    }

    @ManagedAttribute(description="The number of archived tasks failed to delete")
    public long getFailedToDelete() {
        return this.countByStatus(MigrationStatus.FAILED_TO_DELETE);
    }

    @ManagedAttribute(description="The number of archived tasks exported")
    public long getExported() {
        return this.countByStatus(MigrationStatus.EXPORTED);
    }

    private long countByStatus(MigrationStatus status) {
        return this.countByStatuses(Collections.singletonList(status));
    }

    private long countByStatuses(List<MigrationStatus> statuses) {
        JcrArchivedTaskSearchParameters parameters = new JcrArchivedTaskSearchParameters();
        parameters.forMigrationStatuses(statuses);
        parameters.showPage(1, -1);
        return this.jcrTaskArchive.countTasks(parameters);
    }

    public ArchiveMigrationStatistics(@Autowired JcrTaskArchive jcrTaskArchive) {
        this.jcrTaskArchive = jcrTaskArchive;
    }
}

