/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.xml;

import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MaskPasswordCiConverter
extends ConfigurationItemConverter {
    private final PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
    private static final String PASSWORD_MASK = "********";

    public MaskPasswordCiConverter() {
        this.setWriteValidationMessages(true);
    }

    protected void writeStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        if (propertyDescriptor.isPassword()) {
            writer.valueAsString((Object)PASSWORD_MASK);
        } else {
            super.writeStringProperty(value, propertyDescriptor, writer);
        }
    }

    protected void writeCollectionOfStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        if (value instanceof AbstractStringView) {
            if (propertyDescriptor.isPassword()) {
                ((AbstractStringView)value).getWrapped().forEach(item -> new StringValue(PASSWORD_MASK));
            }
            Collection wrapped = ((AbstractStringView)value).getWrapped();
            value = wrapped.stream().map(v -> (String)StringValueConverter.valueToString((PasswordEncrypter)this.passwordEncrypter, (boolean)true).apply(v)).collect(Collectors.toList());
        }
        super.writeCollectionOfStringProperty((Object)value, propertyDescriptor, writer);
    }

    protected void writeMapStringStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        if (value instanceof MapStringStringView) {
            if (propertyDescriptor.isPassword()) {
                ((MapStringStringView)value).getWrapped().entrySet().forEach(entry -> entry.setValue(new StringValue(PASSWORD_MASK)));
            }
            Map wrapped = ((MapStringStringView)value).getWrapped();
            value = wrapped.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)StringValueConverter.valueToString((PasswordEncrypter)this.passwordEncrypter, (boolean)true).apply(e.getValue())));
        }
        super.writeMapStringStringProperty((Object)value, propertyDescriptor, writer);
    }

    protected void writeCollectionOfCiProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        Collection cis = (Collection)value;
        Collection ids = cis.stream().map(ConfigurationItem::getId).filter(Objects::nonNull).collect(Collectors.toList());
        writer.ciReferences(ids);
    }
}

