/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.ExclusiveBufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.HeaderWriter;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ExclusiveTermAppender {
    public static final int TRIPPED = -1;
    public static final int FAILED = -2;
    private final long tailAddressOffset;
    private final byte[] tailBuffer;
    private final UnsafeBuffer termBuffer;

    public ExclusiveTermAppender(UnsafeBuffer termBuffer, UnsafeBuffer metaDataBuffer, int partitionIndex) {
        int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + partitionIndex * 8;
        metaDataBuffer.boundsCheck(tailCounterOffset, 8);
        this.termBuffer = termBuffer;
        this.tailBuffer = metaDataBuffer.byteArray();
        this.tailAddressOffset = metaDataBuffer.addressOffset() + (long)tailCounterOffset;
    }

    public long rawTail() {
        return UnsafeAccess.UNSAFE.getLong(this.tailBuffer, this.tailAddressOffset);
    }

    public void tailTermId(int termId) {
        UnsafeAccess.UNSAFE.putLong(this.tailBuffer, this.tailAddressOffset, (long)termId << 32);
    }

    public int claim(int termId, int termOffset, HeaderWriter header, int length, ExclusiveBufferClaim bufferClaim) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align((int)frameLength, (int)32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        this.putRawTailOrdered(termId, termOffset + alignedLength);
        int resultingOffset = termOffset + alignedLength;
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            header.write(termBuffer, termOffset, frameLength, termId);
            bufferClaim.wrap((AtomicBuffer)termBuffer, termOffset, frameLength);
        }
        return resultingOffset;
    }

    public int appendUnfragmentedMessage(int termId, int termOffset, HeaderWriter header, DirectBuffer srcBuffer, int srcOffset, int length, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align((int)frameLength, (int)32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        this.putRawTailOrdered(termId, termOffset + alignedLength);
        int resultingOffset = termOffset + alignedLength;
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            header.write(termBuffer, termOffset, frameLength, termId);
            termBuffer.putBytes(termOffset + 32, srcBuffer, srcOffset, length);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get((DirectBuffer)termBuffer, termOffset, frameLength);
                termBuffer.putLong(termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, frameLength);
        }
        return resultingOffset;
    }

    public int appendFragmentedMessage(int termId, int termOffset, HeaderWriter header, DirectBuffer srcBuffer, int srcOffset, int length, int maxPayloadLength, ReservedValueSupplier reservedValueSupplier) {
        int numMaxPayloads = length / maxPayloadLength;
        int remainingPayload = length % maxPayloadLength;
        int lastFrameLength = remainingPayload > 0 ? BitUtil.align((int)(remainingPayload + 32), (int)32) : 0;
        int requiredLength = numMaxPayloads * (maxPayloadLength + 32) + lastFrameLength;
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        this.putRawTailOrdered(termId, termOffset + requiredLength);
        int resultingOffset = termOffset + requiredLength;
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int bytesToWrite;
            int offset = termOffset;
            byte flags = -128;
            int remaining = length;
            do {
                bytesToWrite = Math.min(remaining, maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align((int)frameLength, (int)32);
                header.write(termBuffer, offset, frameLength, termId);
                termBuffer.putBytes(offset + 32, srcBuffer, srcOffset + (length - remaining), bytesToWrite);
                if (remaining <= maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, offset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get((DirectBuffer)termBuffer, offset, frameLength);
                    termBuffer.putLong(offset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, offset, frameLength);
                flags = 0;
                offset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return resultingOffset;
    }

    private int handleEndOfLogCondition(UnsafeBuffer termBuffer, long termOffset, HeaderWriter header, int termLength, int termId) {
        if (termOffset < (long)termLength) {
            int offset = (int)termOffset;
            int paddingLength = termLength - offset;
            header.write(termBuffer, offset, paddingLength, termId);
            FrameDescriptor.frameType(termBuffer, offset, 0);
            FrameDescriptor.frameLengthOrdered(termBuffer, offset, paddingLength);
        }
        return -1;
    }

    private void putRawTailOrdered(int termId, int termOffset) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.tailBuffer, this.tailAddressOffset, LogBufferDescriptor.packTail(termId, termOffset));
    }
}

