/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongIterator
implements Iterator<Long> {
    private int remaining;
    private int positionCounter;
    private int stopCounter;
    protected boolean isPositionValid = false;
    private long[] values;
    private boolean containsMissingValue;

    protected LongIterator() {
    }

    void reset(long[] values, boolean containsMissingValue, int size) {
        int length;
        this.values = values;
        this.containsMissingValue = containsMissingValue;
        this.remaining = size;
        int i = length = values.length;
        if (values[length - 1] != -1L) {
            for (i = 0; i < length && values[i] != -1L; ++i) {
            }
        }
        this.stopCounter = i;
        this.positionCounter = i + length;
        this.isPositionValid = false;
    }

    protected int position() {
        return this.positionCounter & this.values.length - 1;
    }

    @Override
    public boolean hasNext() {
        return this.remaining > 0;
    }

    public int remaining() {
        return this.remaining;
    }

    @Override
    public Long next() {
        return this.nextValue();
    }

    public long nextValue() {
        this.findNext();
        if (this.remaining == 1 && this.containsMissingValue) {
            return -1L;
        }
        return this.values[this.position()];
    }

    protected void findNext() {
        long[] values = this.values;
        int mask = values.length - 1;
        this.isPositionValid = true;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == -1L) continue;
            this.positionCounter = i;
            --this.remaining;
            return;
        }
        if (this.containsMissingValue) {
            --this.remaining;
            return;
        }
        this.isPositionValid = false;
        throw new NoSuchElementException();
    }
}

