/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.jdbc;

import com.tqdev.metrics.core.MetricRegistry;
import java.sql.SQLException;

abstract class InstrumentedSqlWrapper {
    protected MetricRegistry registry;

    InstrumentedSqlWrapper(MetricRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <C> C timedExecute(String sql, SqlHandler<C> f) throws SQLException {
        if (!this.registry.isEnabled()) {
            return f.execute();
        }
        long start = this.registry.getNanos();
        try {
            C c = f.execute();
            return c;
        }
        finally {
            long duration = this.registry.getNanos() - start;
            this.registry.increment("jdbc.Statement.Invocations", sql);
            this.registry.add("jdbc.Statement.Durations", sql, duration);
        }
    }

    static interface SqlHandler<C> {
        public C execute() throws SQLException;
    }
}

