/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject(value="limits exposure to abuse from request flooding, whether malicious, or as a result of a misconfigured client")
public class DoSFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(DoSFilter.class);
    private static final String IPv4_GROUP = "(\\d{1,3})";
    private static final Pattern IPv4_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final String IPv6_GROUP = "(\\p{XDigit}{1,4})";
    private static final Pattern IPv6_PATTERN = Pattern.compile("(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4})");
    private static final Pattern CIDR_PATTERN = Pattern.compile("([^/]+)/(\\d+)");
    private static final String __TRACKER = "DoSFilter.Tracker";
    private static final String __THROTTLED = "DoSFilter.Throttled";
    private static final int __DEFAULT_MAX_REQUESTS_PER_SEC = 25;
    private static final int __DEFAULT_DELAY_MS = 100;
    private static final int __DEFAULT_THROTTLE = 5;
    private static final int __DEFAULT_MAX_WAIT_MS = 50;
    private static final long __DEFAULT_THROTTLE_MS = 30000L;
    private static final long __DEFAULT_MAX_REQUEST_MS_INIT_PARAM = 30000L;
    private static final long __DEFAULT_MAX_IDLE_TRACKER_MS_INIT_PARAM = 30000L;
    static final String NAME = "name";
    static final String MANAGED_ATTR_INIT_PARAM = "managedAttr";
    static final String MAX_REQUESTS_PER_S_INIT_PARAM = "maxRequestsPerSec";
    static final String DELAY_MS_INIT_PARAM = "delayMs";
    static final String THROTTLED_REQUESTS_INIT_PARAM = "throttledRequests";
    static final String MAX_WAIT_INIT_PARAM = "maxWaitMs";
    static final String THROTTLE_MS_INIT_PARAM = "throttleMs";
    static final String MAX_REQUEST_MS_INIT_PARAM = "maxRequestMs";
    static final String MAX_IDLE_TRACKER_MS_INIT_PARAM = "maxIdleTrackerMs";
    static final String INSERT_HEADERS_INIT_PARAM = "insertHeaders";
    static final String TRACK_SESSIONS_INIT_PARAM = "trackSessions";
    static final String REMOTE_PORT_INIT_PARAM = "remotePort";
    static final String IP_WHITELIST_INIT_PARAM = "ipWhitelist";
    static final String ENABLED_INIT_PARAM = "enabled";
    static final String TOO_MANY_CODE = "tooManyCode";
    private static final int USER_AUTH = 2;
    private static final int USER_SESSION = 2;
    private static final int USER_IP = 1;
    private static final int USER_UNKNOWN = 0;
    private final String _suspended = "DoSFilter@" + Integer.toHexString(this.hashCode()) + ".SUSPENDED";
    private final String _resumed = "DoSFilter@" + Integer.toHexString(this.hashCode()) + ".RESUMED";
    private final ConcurrentHashMap<String, RateTracker> _rateTrackers = new ConcurrentHashMap();
    private final List<String> _whitelist = new CopyOnWriteArrayList<String>();
    private int _tooManyCode;
    private volatile long _delayMs;
    private volatile long _throttleMs;
    private volatile long _maxWaitMs;
    private volatile long _maxRequestMs;
    private volatile long _maxIdleTrackerMs;
    private volatile boolean _insertHeaders;
    private volatile boolean _trackSessions;
    private volatile boolean _remotePort;
    private volatile boolean _enabled;
    private volatile String _name;
    private Semaphore _passes;
    private volatile int _throttledRequests;
    private volatile int _maxRequestsPerSec;
    private Queue<AsyncContext>[] _queues;
    private AsyncListener[] _listeners;
    private Scheduler _scheduler;
    private ServletContext _context;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._queues = new Queue[this.getMaxPriority() + 1];
        this._listeners = new AsyncListener[this._queues.length];
        for (int p = 0; p < this._queues.length; ++p) {
            this._queues[p] = new ConcurrentLinkedQueue<AsyncContext>();
            this._listeners[p] = new DoSAsyncListener(p);
        }
        this._rateTrackers.clear();
        int maxRequests = 25;
        String parameter = filterConfig.getInitParameter(MAX_REQUESTS_PER_S_INIT_PARAM);
        if (parameter != null) {
            maxRequests = Integer.parseInt(parameter);
        }
        this.setMaxRequestsPerSec(maxRequests);
        long delay = 100L;
        parameter = filterConfig.getInitParameter(DELAY_MS_INIT_PARAM);
        if (parameter != null) {
            delay = Long.parseLong(parameter);
        }
        this.setDelayMs(delay);
        int throttledRequests = 5;
        parameter = filterConfig.getInitParameter(THROTTLED_REQUESTS_INIT_PARAM);
        if (parameter != null) {
            throttledRequests = Integer.parseInt(parameter);
        }
        this.setThrottledRequests(throttledRequests);
        long maxWait = 50L;
        parameter = filterConfig.getInitParameter(MAX_WAIT_INIT_PARAM);
        if (parameter != null) {
            maxWait = Long.parseLong(parameter);
        }
        this.setMaxWaitMs(maxWait);
        long throttle = 30000L;
        parameter = filterConfig.getInitParameter(THROTTLE_MS_INIT_PARAM);
        if (parameter != null) {
            throttle = Long.parseLong(parameter);
        }
        this.setThrottleMs(throttle);
        long maxRequestMs = 30000L;
        parameter = filterConfig.getInitParameter(MAX_REQUEST_MS_INIT_PARAM);
        if (parameter != null) {
            maxRequestMs = Long.parseLong(parameter);
        }
        this.setMaxRequestMs(maxRequestMs);
        long maxIdleTrackerMs = 30000L;
        parameter = filterConfig.getInitParameter(MAX_IDLE_TRACKER_MS_INIT_PARAM);
        if (parameter != null) {
            maxIdleTrackerMs = Long.parseLong(parameter);
        }
        this.setMaxIdleTrackerMs(maxIdleTrackerMs);
        String whiteList = "";
        parameter = filterConfig.getInitParameter(IP_WHITELIST_INIT_PARAM);
        if (parameter != null) {
            whiteList = parameter;
        }
        this.setWhitelist(whiteList);
        parameter = filterConfig.getInitParameter(INSERT_HEADERS_INIT_PARAM);
        this.setInsertHeaders(parameter == null || Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(TRACK_SESSIONS_INIT_PARAM);
        this.setTrackSessions(parameter == null || Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(REMOTE_PORT_INIT_PARAM);
        this.setRemotePort(parameter != null && Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(ENABLED_INIT_PARAM);
        this.setEnabled(parameter == null || Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(TOO_MANY_CODE);
        this.setTooManyCode(parameter == null ? 429 : Integer.parseInt(parameter));
        this.setName(filterConfig.getFilterName());
        this._context = filterConfig.getServletContext();
        if (this._context != null) {
            this._context.setAttribute(filterConfig.getFilterName(), (Object)this);
        }
        this._scheduler = this.startScheduler();
    }

    protected Scheduler startScheduler() throws ServletException {
        try {
            ScheduledExecutorScheduler result = new ScheduledExecutorScheduler();
            result.start();
            return result;
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        block51: {
            block49: {
                block50: {
                    if (!this.isEnabled()) {
                        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    tracker = (RateTracker)request.getAttribute("DoSFilter.Tracker");
                    if (tracker == null) {
                        if (DoSFilter.LOG.isDebugEnabled()) {
                            DoSFilter.LOG.debug("Filtering {}", new Object[]{request});
                        }
                        if (!(overRateLimit = (tracker = this.getRateTracker((ServletRequest)request)).isRateExceeded(System.currentTimeMillis()))) {
                            if (DoSFilter.LOG.isDebugEnabled()) {
                                DoSFilter.LOG.debug("Allowing {}", new Object[]{request});
                            }
                            this.doFilterChain(filterChain, request, response);
                            return;
                        }
                        delayMs = this.getDelayMs();
                        insertHeaders = this.isInsertHeaders();
                        switch ((int)delayMs) {
                            case -1: {
                                DoSFilter.LOG.warn("DOS ALERT: Request rejected ip={}, session={}, user={}", new Object[]{request.getRemoteAddr(), request.getRequestedSessionId(), request.getUserPrincipal()});
                                if (insertHeaders) {
                                    response.addHeader("DoSFilter", "unavailable");
                                }
                                response.sendError(this.getTooManyCode());
                                return;
                            }
                            case 0: {
                                DoSFilter.LOG.warn("DOS ALERT: Request throttled ip={}, session={}, user={}", new Object[]{request.getRemoteAddr(), request.getRequestedSessionId(), request.getUserPrincipal()});
                                request.setAttribute("DoSFilter.Tracker", (Object)tracker);
                                break;
                            }
                            default: {
                                DoSFilter.LOG.warn("DOS ALERT: Request delayed={}ms, ip={}, session={}, user={}", new Object[]{delayMs, request.getRemoteAddr(), request.getRequestedSessionId(), request.getUserPrincipal()});
                                if (insertHeaders) {
                                    response.addHeader("DoSFilter", "delayed");
                                }
                                request.setAttribute("DoSFilter.Tracker", (Object)tracker);
                                asyncContext = request.startAsync();
                                if (delayMs > 0L) {
                                    asyncContext.setTimeout(delayMs);
                                }
                                asyncContext.addListener((AsyncListener)new DoSTimeoutAsyncListener());
                                return;
                            }
                        }
                    }
                    if (DoSFilter.LOG.isDebugEnabled()) {
                        DoSFilter.LOG.debug("Throttling {}", new Object[]{request});
                    }
                    accepted = false;
                    accepted = this._passes.tryAcquire(this.getMaxWaitMs(), TimeUnit.MILLISECONDS);
                    if (accepted) ** GOTO lbl80
                    throttled = (Boolean)request.getAttribute("DoSFilter.Throttled");
                    throttleMs = this.getThrottleMs();
                    if (throttled == Boolean.TRUE || throttleMs <= 0L) break block49;
                    priority = this.getPriority(request, tracker);
                    request.setAttribute("DoSFilter.Throttled", (Object)Boolean.TRUE);
                    if (this.isInsertHeaders()) {
                        response.addHeader("DoSFilter", "throttled");
                    }
                    asyncContext = request.startAsync();
                    request.setAttribute(this._suspended, (Object)Boolean.TRUE);
                    if (throttleMs > 0L) {
                        asyncContext.setTimeout(throttleMs);
                    }
                    asyncContext.addListener(this._listeners[priority]);
                    this._queues[priority].add(asyncContext);
                    if (DoSFilter.LOG.isDebugEnabled()) {
                        DoSFilter.LOG.debug("Throttled {}, {}ms", new Object[]{request, throttleMs});
                    }
                    if (!accepted) break block50;
                    try {
                        for (p = this._queues.length - 1; p >= 0; --p) {
                            asyncContext = this._queues[p].poll();
                            if (asyncContext == null || (suspended = (Boolean)(candidate = asyncContext.getRequest()).getAttribute(this._suspended)) != Boolean.TRUE) continue;
                            if (DoSFilter.LOG.isDebugEnabled()) {
                                DoSFilter.LOG.debug("Resuming {}", new Object[]{request});
                            }
                            candidate.setAttribute(this._resumed, (Object)Boolean.TRUE);
                            asyncContext.dispatch();
                            break;
                        }
                    }
                    finally {
                        this._passes.release();
                    }
                }
                return;
            }
            try {
                resumed = (Boolean)request.getAttribute(this._resumed);
                if (resumed == Boolean.TRUE) {
                    this._passes.acquire();
                    accepted = true;
                }
lbl80:
                // 4 sources

                if (accepted) {
                    if (DoSFilter.LOG.isDebugEnabled()) {
                        DoSFilter.LOG.debug("Allowing {}", new Object[]{request});
                    }
                    this.doFilterChain(filterChain, request, response);
                } else {
                    if (DoSFilter.LOG.isDebugEnabled()) {
                        DoSFilter.LOG.debug("Rejecting {}", new Object[]{request});
                    }
                    if (this.isInsertHeaders()) {
                        response.addHeader("DoSFilter", "unavailable");
                    }
                    response.sendError(this.getTooManyCode());
                }
                ** if (!accepted) goto lbl-1000
            }
            catch (InterruptedException e) {
                DoSFilter.LOG.ignore((Throwable)e);
                response.sendError(this.getTooManyCode());
                if (!accepted) break block51;
                try {
                    for (p = this._queues.length - 1; p >= 0; --p) {
                        asyncContext = this._queues[p].poll();
                        if (asyncContext == null || (suspended = (Boolean)(candidate = asyncContext.getRequest()).getAttribute(this._suspended)) != Boolean.TRUE) continue;
                        if (DoSFilter.LOG.isDebugEnabled()) {
                            DoSFilter.LOG.debug("Resuming {}", new Object[]{request});
                        }
                        candidate.setAttribute(this._resumed, (Object)Boolean.TRUE);
                        asyncContext.dispatch();
                        break block51;
                    }
                    break block51;
                }
                finally {
                    this._passes.release();
                }
                catch (Throwable var18_29) {
                    if (accepted) {
                        try {
                            for (p = this._queues.length - 1; p >= 0; --p) {
                                asyncContext = this._queues[p].poll();
                                if (asyncContext == null || (suspended = (Boolean)(candidate = asyncContext.getRequest()).getAttribute(this._suspended)) != Boolean.TRUE) continue;
                                if (DoSFilter.LOG.isDebugEnabled()) {
                                    DoSFilter.LOG.debug("Resuming {}", new Object[]{request});
                                }
                                candidate.setAttribute(this._resumed, (Object)Boolean.TRUE);
                                asyncContext.dispatch();
                                break;
                            }
                        }
                        finally {
                            this._passes.release();
                        }
                    }
                    throw var18_29;
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    for (p = this._queues.length - 1; p >= 0; --p) {
                        asyncContext = this._queues[p].poll();
                        if (asyncContext == null || (suspended = (Boolean)(candidate = asyncContext.getRequest()).getAttribute(this._suspended)) != Boolean.TRUE) continue;
                        if (DoSFilter.LOG.isDebugEnabled()) {
                            DoSFilter.LOG.debug("Resuming {}", new Object[]{request});
                        }
                        candidate.setAttribute(this._resumed, (Object)Boolean.TRUE);
                        asyncContext.dispatch();
                    }
                }
                finally {
                    this._passes.release();
                }
            }
lbl-1000:
            // 1 sources

            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterChain(FilterChain chain, final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        final Thread thread = Thread.currentThread();
        Runnable requestTimeout = new Runnable(){

            @Override
            public void run() {
                DoSFilter.this.closeConnection(request, response, thread);
            }
        };
        Scheduler.Task task = this._scheduler.schedule(requestTimeout, this.getMaxRequestMs(), TimeUnit.MILLISECONDS);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            task.cancel();
        }
    }

    protected void onRequestTimeout(HttpServletRequest request, HttpServletResponse response, Thread handlingThread) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timing out {}", new Object[]{request});
            }
            response.sendError(503);
        }
        catch (Throwable x) {
            LOG.info(x);
        }
        handlingThread.interrupt();
    }

    @Deprecated
    protected void closeConnection(HttpServletRequest request, HttpServletResponse response, Thread thread) {
        this.onRequestTimeout(request, response, thread);
    }

    protected int getPriority(HttpServletRequest request, RateTracker tracker) {
        if (this.extractUserId((ServletRequest)request) != null) {
            return 2;
        }
        if (tracker != null) {
            return tracker.getType();
        }
        return 0;
    }

    protected int getMaxPriority() {
        return 2;
    }

    public void schedule(RateTracker tracker) {
        this._scheduler.schedule((Runnable)tracker, this.getMaxIdleTrackerMs(), TimeUnit.MILLISECONDS);
    }

    public RateTracker getRateTracker(ServletRequest request) {
        int type;
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        String loadId = this.extractUserId(request);
        if (loadId != null) {
            type = 2;
        } else if (this.isTrackSessions() && session != null && !session.isNew()) {
            loadId = session.getId();
            type = 2;
        } else {
            loadId = this.isRemotePort() ? this.createRemotePortId(request) : request.getRemoteAddr();
            type = 1;
        }
        RateTracker tracker = this._rateTrackers.get(loadId);
        if (tracker == null) {
            boolean allowed = this.checkWhitelist(request.getRemoteAddr());
            int maxRequestsPerSec = this.getMaxRequestsPerSec();
            tracker = allowed ? new FixedRateTracker(this._context, this._name, loadId, type, maxRequestsPerSec) : new RateTracker(this._context, this._name, loadId, type, maxRequestsPerSec);
            tracker.setContext(this._context);
            RateTracker existing = this._rateTrackers.putIfAbsent(loadId, tracker);
            if (existing != null) {
                tracker = existing;
            }
            if (type == 1) {
                this._scheduler.schedule((Runnable)tracker, this.getMaxIdleTrackerMs(), TimeUnit.MILLISECONDS);
            } else if (session != null) {
                session.setAttribute(__TRACKER, (Object)tracker);
            }
        }
        return tracker;
    }

    public void addToRateTracker(RateTracker tracker) {
        this._rateTrackers.put(tracker.getId(), tracker);
    }

    public void removeFromRateTracker(String id) {
        this._rateTrackers.remove(id);
    }

    protected boolean checkWhitelist(String candidate) {
        for (String address : this._whitelist) {
            if (!(address.contains("/") ? this.subnetMatch(address, candidate) : address.equals(candidate))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected boolean checkWhitelist(List<String> whitelist, String candidate) {
        for (String address : whitelist) {
            if (!(address.contains("/") ? this.subnetMatch(address, candidate) : address.equals(candidate))) continue;
            return true;
        }
        return false;
    }

    protected boolean subnetMatch(String subnetAddress, String address) {
        int prefix;
        Matcher cidrMatcher = CIDR_PATTERN.matcher(subnetAddress);
        if (!cidrMatcher.matches()) {
            return false;
        }
        String subnet = cidrMatcher.group(1);
        try {
            prefix = Integer.parseInt(cidrMatcher.group(2));
        }
        catch (NumberFormatException x) {
            LOG.info("Ignoring malformed CIDR address {}", new Object[]{subnetAddress});
            return false;
        }
        byte[] subnetBytes = this.addressToBytes(subnet);
        if (subnetBytes == null) {
            LOG.info("Ignoring malformed CIDR address {}", new Object[]{subnetAddress});
            return false;
        }
        byte[] addressBytes = this.addressToBytes(address);
        if (addressBytes == null) {
            LOG.info("Ignoring malformed remote address {}", new Object[]{address});
            return false;
        }
        int length = subnetBytes.length;
        if (length != addressBytes.length) {
            return false;
        }
        byte[] mask = this.prefixToBytes(prefix, length);
        for (int i = 0; i < length; ++i) {
            if ((subnetBytes[i] & mask[i]) == (addressBytes[i] & mask[i])) continue;
            return false;
        }
        return true;
    }

    private byte[] addressToBytes(String address) {
        Matcher ipv4Matcher = IPv4_PATTERN.matcher(address);
        if (ipv4Matcher.matches()) {
            byte[] result = new byte[4];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Integer.valueOf(ipv4Matcher.group(i + 1)).byteValue();
            }
            return result;
        }
        Matcher ipv6Matcher = IPv6_PATTERN.matcher(address);
        if (ipv6Matcher.matches()) {
            byte[] result = new byte[16];
            for (int i = 0; i < result.length; i += 2) {
                int word = Integer.valueOf(ipv6Matcher.group(i / 2 + 1), 16);
                result[i] = (byte)((word & 0xFF00) >>> 8);
                result[i + 1] = (byte)(word & 0xFF);
            }
            return result;
        }
        return null;
    }

    private byte[] prefixToBytes(int prefix, int length) {
        byte[] result = new byte[length];
        int index = 0;
        while (prefix / 8 > 0) {
            result[index] = -1;
            prefix -= 8;
            ++index;
        }
        if (index == result.length) {
            return result;
        }
        result[index] = (byte)(~((1 << 8 - prefix) - 1));
        return result;
    }

    public void destroy() {
        LOG.debug("Destroy {}", new Object[]{this});
        this.stopScheduler();
        this._rateTrackers.clear();
        this._whitelist.clear();
    }

    protected void stopScheduler() {
        try {
            this._scheduler.stop();
        }
        catch (Exception x) {
            LOG.ignore((Throwable)x);
        }
    }

    protected String extractUserId(ServletRequest request) {
        return null;
    }

    @ManagedAttribute(value="maximum number of requests allowed from a connection per second")
    public int getMaxRequestsPerSec() {
        return this._maxRequestsPerSec;
    }

    public void setMaxRequestsPerSec(int value) {
        this._maxRequestsPerSec = value;
    }

    @ManagedAttribute(value="delay applied to all requests over the rate limit (in ms)")
    public long getDelayMs() {
        return this._delayMs;
    }

    public void setDelayMs(long value) {
        this._delayMs = value;
    }

    @ManagedAttribute(value="maximum time the filter will block waiting throttled connections, (0 for no delay, -1 to reject requests)")
    public long getMaxWaitMs() {
        return this._maxWaitMs;
    }

    public void setMaxWaitMs(long value) {
        this._maxWaitMs = value;
    }

    @ManagedAttribute(value="number of requests over rate limit")
    public int getThrottledRequests() {
        return this._throttledRequests;
    }

    public void setThrottledRequests(int value) {
        int permits = this._passes == null ? 0 : this._passes.availablePermits();
        this._passes = new Semaphore(value - this._throttledRequests + permits, true);
        this._throttledRequests = value;
    }

    @ManagedAttribute(value="amount of time to async wait for semaphore")
    public long getThrottleMs() {
        return this._throttleMs;
    }

    public void setThrottleMs(long value) {
        this._throttleMs = value;
    }

    @ManagedAttribute(value="maximum time to allow requests to process (in ms)")
    public long getMaxRequestMs() {
        return this._maxRequestMs;
    }

    public void setMaxRequestMs(long value) {
        this._maxRequestMs = value;
    }

    @ManagedAttribute(value="maximum time to track of request rates for connection before discarding")
    public long getMaxIdleTrackerMs() {
        return this._maxIdleTrackerMs;
    }

    public void setMaxIdleTrackerMs(long value) {
        this._maxIdleTrackerMs = value;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @ManagedAttribute(value="inser DoSFilter headers in response")
    public boolean isInsertHeaders() {
        return this._insertHeaders;
    }

    public void setInsertHeaders(boolean value) {
        this._insertHeaders = value;
    }

    @ManagedAttribute(value="usage rate is tracked by session if one exists")
    public boolean isTrackSessions() {
        return this._trackSessions;
    }

    public void setTrackSessions(boolean value) {
        this._trackSessions = value;
    }

    @ManagedAttribute(value="usage rate is tracked by IP+port is session tracking not used")
    public boolean isRemotePort() {
        return this._remotePort;
    }

    public void setRemotePort(boolean value) {
        this._remotePort = value;
    }

    @ManagedAttribute(value="whether this filter is enabled")
    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public int getTooManyCode() {
        return this._tooManyCode;
    }

    public void setTooManyCode(int tooManyCode) {
        this._tooManyCode = tooManyCode;
    }

    @ManagedAttribute(value="list of IPs that will not be rate limited")
    public String getWhitelist() {
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = this._whitelist.iterator();
        while (iterator.hasNext()) {
            String address = iterator.next();
            result.append(address);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    public void setWhitelist(String commaSeparatedList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String address : StringUtil.csvSplit((String)commaSeparatedList)) {
            this.addWhitelistAddress(result, address);
        }
        this.clearWhitelist();
        this._whitelist.addAll(result);
        LOG.debug("Whitelisted IP addresses: {}", new Object[]{result});
    }

    @ManagedOperation(value="clears the list of IP addresses that will not be rate limited")
    public void clearWhitelist() {
        this._whitelist.clear();
    }

    @ManagedOperation(value="adds an IP address that will not be rate limited")
    public boolean addWhitelistAddress(@Name(value="address") String address) {
        return this.addWhitelistAddress(this._whitelist, address);
    }

    private boolean addWhitelistAddress(List<String> list, String address) {
        return (address = address.trim()).length() > 0 && list.add(address);
    }

    @ManagedOperation(value="removes an IP address that will not be rate limited")
    public boolean removeWhitelistAddress(@Name(value="address") String address) {
        return this._whitelist.remove(address);
    }

    private String createRemotePortId(ServletRequest request) {
        String addr = request.getRemoteAddr();
        int port = request.getRemotePort();
        if (addr.contains(":")) {
            return "[" + addr + "]:" + port;
        }
        return addr + ":" + port;
    }

    private class DoSAsyncListener
    extends DoSTimeoutAsyncListener {
        private final int priority;

        public DoSAsyncListener(int priority) {
            this.priority = priority;
        }

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
            DoSFilter.this._queues[this.priority].remove(event.getAsyncContext());
            super.onTimeout(event);
        }
    }

    private class DoSTimeoutAsyncListener
    implements AsyncListener {
        private DoSTimeoutAsyncListener() {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().dispatch();
        }

        public void onError(AsyncEvent event) throws IOException {
        }
    }

    class FixedRateTracker
    extends RateTracker {
        public FixedRateTracker(ServletContext context, String filterName, String id, int type, int numRecentRequestsTracked) {
            super(context, filterName, id, type, numRecentRequestsTracked);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRateExceeded(long now) {
            FixedRateTracker fixedRateTracker = this;
            synchronized (fixedRateTracker) {
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            return false;
        }

        @Override
        public String toString() {
            return "Fixed" + super.toString();
        }
    }

    static class RateTracker
    implements Runnable,
    HttpSessionBindingListener,
    HttpSessionActivationListener,
    Serializable {
        private static final long serialVersionUID = 3534663738034577872L;
        protected final String _filterName;
        protected transient ServletContext _context;
        protected final String _id;
        protected final int _type;
        protected final long[] _timestamps;
        protected int _next;

        public RateTracker(ServletContext context, String filterName, String id, int type, int maxRequestsPerSecond) {
            this._context = context;
            this._filterName = filterName;
            this._id = id;
            this._type = type;
            this._timestamps = new long[maxRequestsPerSecond];
            this._next = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRateExceeded(long now) {
            long last;
            RateTracker rateTracker = this;
            synchronized (rateTracker) {
                last = this._timestamps[this._next];
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            return last != 0L && now - last < 1000L;
        }

        public String getId() {
            return this._id;
        }

        public int getType() {
            return this._type;
        }

        public void valueBound(HttpSessionBindingEvent event) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Value bound: {}", new Object[]{this.getId()});
            }
            this._context = event.getSession().getServletContext();
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            DoSFilter filter = (DoSFilter)event.getSession().getServletContext().getAttribute(this._filterName);
            this.removeFromRateTrackers(filter, this._id);
            this._context = null;
        }

        public void sessionWillPassivate(HttpSessionEvent se) {
            DoSFilter filter = (DoSFilter)se.getSession().getServletContext().getAttribute(this._filterName);
            this.removeFromRateTrackers(filter, this._id);
            this._context = null;
        }

        public void sessionDidActivate(HttpSessionEvent se) {
            RateTracker tracker = (RateTracker)se.getSession().getAttribute(DoSFilter.__TRACKER);
            ServletContext context = se.getSession().getServletContext();
            tracker.setContext(context);
            DoSFilter filter = (DoSFilter)context.getAttribute(this._filterName);
            if (filter == null) {
                LOG.info("No filter {} for rate tracker {}", new Object[]{this._filterName, tracker});
                return;
            }
            this.addToRateTrackers(filter, tracker);
        }

        public void setContext(ServletContext context) {
            this._context = context;
        }

        protected void removeFromRateTrackers(DoSFilter filter, String id) {
            if (filter == null) {
                return;
            }
            filter.removeFromRateTracker(id);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tracker removed: {}", new Object[]{this.getId()});
            }
        }

        protected void addToRateTrackers(DoSFilter filter, RateTracker tracker) {
            if (filter == null) {
                return;
            }
            filter.addToRateTracker(tracker);
        }

        @Override
        public void run() {
            if (this._context == null) {
                LOG.warn("Unknkown context for rate tracker {}", new Object[]{this});
                return;
            }
            int latestIndex = this._next == 0 ? this._timestamps.length - 1 : this._next - 1;
            long last = this._timestamps[latestIndex];
            boolean hasRecentRequest = last != 0L && System.currentTimeMillis() - last < 1000L;
            DoSFilter filter = (DoSFilter)this._context.getAttribute(this._filterName);
            if (hasRecentRequest) {
                if (filter != null) {
                    filter.schedule(this);
                } else {
                    LOG.warn("No filter {}", new Object[]{this._filterName});
                }
            } else {
                this.removeFromRateTrackers(filter, this._id);
            }
        }

        public String toString() {
            return "RateTracker/" + this._id + "/" + this._type;
        }
    }
}

