/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Subscription;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Int2ObjectHashMap;

class ActiveSubscriptions {
    private final Int2ObjectHashMap<ArrayList<Subscription>> subscriptionsByStreamIdMap = new Int2ObjectHashMap();

    ActiveSubscriptions() {
    }

    public void forEach(int streamId, Consumer<Subscription> consumer) {
        ArrayList subscriptions = (ArrayList)this.subscriptionsByStreamIdMap.get(streamId);
        if (null != subscriptions) {
            subscriptions.forEach(consumer);
        }
    }

    public void add(Subscription subscription) {
        ArrayList<Subscription> subscriptions = (ArrayList<Subscription>)this.subscriptionsByStreamIdMap.get(subscription.streamId());
        if (null == subscriptions) {
            subscriptions = new ArrayList<Subscription>();
            this.subscriptionsByStreamIdMap.put(subscription.streamId(), subscriptions);
        }
        subscriptions.add(subscription);
    }

    public void remove(Subscription subscription) {
        int streamId = subscription.streamId();
        ArrayList subscriptions = (ArrayList)this.subscriptionsByStreamIdMap.get(streamId);
        if (null != subscriptions && ActiveSubscriptions.remove(subscriptions, subscription) && subscriptions.isEmpty()) {
            this.subscriptionsByStreamIdMap.remove(streamId);
        }
    }

    public void close() {
        for (ArrayList subscriptions : this.subscriptionsByStreamIdMap.values()) {
            int size = subscriptions.size();
            for (int i = 0; i < size; ++i) {
                ((Subscription)subscriptions.get(i)).forceClose();
            }
        }
        this.subscriptionsByStreamIdMap.clear();
    }

    private static boolean remove(ArrayList<Subscription> subscriptions, Subscription subscription) {
        int size = subscriptions.size();
        for (int i = 0; i < size; ++i) {
            if (subscription != subscriptions.get(i)) continue;
            ArrayListUtil.fastUnorderedRemove(subscriptions, (int)i, (int)(size - 1));
            return true;
        }
        return false;
    }
}

