/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.package;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001=\u0011QBU3oC6,7i\\7nC:$'BA\u0002\u0005\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\t!B]3q_NLGo\u001c:z\u0015\tI!\"\u0001\u0005eKBdw._5u\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0012+B$\u0017\r^3QCRD7i\\7nC:$\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\t\f\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!AG\u000e\u0002\t\r|'/\u001a\u0006\u00039u\tAA\u001b3cG*\u0011adH\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001%A\u0002pe\u001eL!AI\r\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\t\u0013\u0011\u0002!\u0011!Q\u0001\n])\u0013!\u00046eE\u000e$V-\u001c9mCR,\u0007%\u0003\u0002\u0016%!Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\nbeRLg-Y2u%\u0016\u0004xn]5u_JL\bCA\u0015-\u001b\u0005Q#BA\u0016\u0005\u0003%\t'\u000f^5gC\u000e$8/\u0003\u0002.U\t\u0011\u0012I\u001d;jM\u0006\u001cGOU3q_NLGo\u001c:z\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014!\u0003:f]\u0006lWmQ5t!\r\t4H\u0010\b\u0003ear!a\r\u001c\u000e\u0003QR!!\u000e\b\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014!B:dC2\f\u0017BA\u001d;\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aN\u0005\u0003yu\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003si\u0002Ba\u0010\"E\t6\t\u0001I\u0003\u0002B\u0011\u0005!Q\u000f^5m\u0013\t\u0019\u0005IA\u0003UkBdW\r\u0005\u0002F\u0013:\u0011ai\u0012\t\u0003giJ!\u0001\u0013\u001e\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011jB\u0001\"\u0014\u0001\u0003\u0006\u0004%\u0019AT\u0001\u000bgFdG)[1mK\u000e$X#A(\u0011\u0005A\u001bV\"A)\u000b\u0005\u0015\u0011&B\u0001\u000e\t\u0013\t!\u0016K\u0001\u0006Tc2$\u0015.\u00197fGRD\u0001B\u0016\u0001\u0003\u0002\u0003\u0006IaT\u0001\fgFdG)[1mK\u000e$\b\u0005C\u0003Y\u0001\u0011\u0005\u0011,\u0001\u0004=S:LGO\u0010\u000b\u00055vsv\f\u0006\u0002\\9B\u0011\u0011\u0003\u0001\u0005\u0006\u001b^\u0003\u001da\u0014\u0005\u0006+]\u0003\ra\u0006\u0005\u0006O]\u0003\r\u0001\u000b\u0005\u0006_]\u0003\r\u0001\r\u0005\u0006C\u0002!\tEY\u0001\bKb,7-\u001e;f)\t\u0019w\r\u0005\u0002eK6\t!(\u0003\u0002gu\t!QK\\5u\u0011\u0015A\u0007\r1\u0001j\u0003\u001d\u0019wN\u001c;fqR\u0004\"!\u00056\n\u0005-\u0014!\u0001E\"iC:<WmU3u\u0007>tG/\u001a=u\u0011\u0015i\u0007\u0001\"\u0011o\u0003!1\u0018\r\\5eCR,GCA2p\u0011\u0015AG\u000e1\u0001j\u0011\u0015\t\b\u0001\"\u0003s\u0003\u0019\u0011XM\\1nKR\u00191m];\t\u000bQ\u0004\b\u0019\u0001#\u0002\u000b=dG-\u00133\t\u000bY\u0004\b\u0019\u0001#\u0002\u000f9,wOT1nK\")\u0001\u0010\u0001C\u0005s\u0006qa/\u00197jI\u0006$XMU3oC6,GcA2{w\")Ao\u001ea\u0001\t\")ao\u001ea\u0001\t\")Q\u0010\u0001C\u0005}\u0006\u0019\u0012/^3ss\u0006sG\r\u0015:f-\u0006d\u0017\u000eZ1uKR)q0a\b\u0002\"A1A-!\u0001E\u0003\u000bI1!a\u0001;\u0005\u0019!V\u000f\u001d7feA9\u0011qAA\b\t\u0006MQBAA\u0005\u0015\r\t\u00151\u0002\u0006\u0003\u0003\u001b\tAA[1wC&!\u0011\u0011CA\u0005\u0005\ri\u0015\r\u001d\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u0006\u0003\u0011a\u0017M\\4\n\t\u0005u\u0011q\u0003\u0002\u0007\u001f\nTWm\u0019;\t\u000bQd\b\u0019\u0001#\t\u000bYd\b\u0019\u0001#")
public class RenameCommand
extends UpdatePathCommand {
    private final Iterable<Tuple<String, String>> renameCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return super.jdbcTemplate();
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.renameCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.rename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.renameCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateRename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    private void rename(String oldId, String newName) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newName);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        this.updateNameAndPath(oldPath, (String)package$.MODULE$.parentPath(oldId).get() + "/" + newName);
        EventBusHolder.publish((Object)new CiRenamedEvent(package$.MODULE$.readBaseCiFromMap(map3), newName));
    }

    private void validateRename(String oldId, String newName) {
        this.queryAndPreValidate(oldId, newName);
        String newPath = (String)package$.MODULE$.parentPath(oldId).get() + "/" + newName;
        if (this.exists(newPath)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{package$.MODULE$.pathToId(newPath)});
        }
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newName) {
        Type ciType;
        Checks.checkArgument((!new StringOps(Predef$.MODULE$.augmentString(newName)).contains((Object)BoxesRunTime.boxToCharacter((char)'/')) ? 1 : 0) != 0, (String)"New name [%s] should not contain a /", (Object[])new Object[]{newName});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type type = ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        Type type2 = Type.valueOf(Root.class);
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            throw new DeployitException("Cannot rename a core.Root configuration item");
        }
        return new Tuple2((Object)oldPath, (Object)map);
    }

    public RenameCommand(JdbcTemplate jdbcTemplate, ArtifactRepository artifactRepository, Iterable<Tuple<String, String>> renameCis, SqlDialect sqlDialect) {
        this.renameCis = renameCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository);
    }
}

