/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.context;

import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class ReactorContextWebFilter
implements WebFilter {
    private final ServerSecurityContextRepository repository;

    public ReactorContextWebFilter(ServerSecurityContextRepository repository) {
        Assert.notNull((Object)repository, (String)"repository cannot be null");
        this.repository = repository;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return chain.filter(exchange).subscriberContext(c -> c.hasKey(SecurityContext.class) ? c : (Context)Mono.defer(() -> this.repository.load(exchange)).as(ReactiveSecurityContextHolder::withSecurityContext));
    }
}

