/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.remote.artery.FlightRecorder$;
import akka.remote.artery.FlightRecorderReader;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.collection.immutable.Seq$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FlightRecorderReader$ {
    public static FlightRecorderReader$ MODULE$;
    private final FlightRecorderReader.SectionParameters AlertSectionParameters;
    private final FlightRecorderReader.SectionParameters LoFreqSectionParameters;
    private final FlightRecorderReader.SectionParameters HiFreqSectionParameters;

    static {
        new FlightRecorderReader$();
    }

    public FlightRecorderReader.SectionParameters AlertSectionParameters() {
        return this.AlertSectionParameters;
    }

    public FlightRecorderReader.SectionParameters LoFreqSectionParameters() {
        return this.LoFreqSectionParameters;
    }

    public FlightRecorderReader.SectionParameters HiFreqSectionParameters() {
        return this.HiFreqSectionParameters;
    }

    public void dumpToStdout(Path flightRecorderFile) {
        RandomAccessFile raFile = null;
        AbstractInterruptibleChannel channel = null;
        FlightRecorderReader reader = null;
        try {
            raFile = new RandomAccessFile(flightRecorderFile.toFile(), "rw");
            channel = raFile.getChannel();
            reader = new FlightRecorderReader((FileChannel)channel);
            Seq alerts = (Seq)reader.structure().alertLog().logs().flatMap((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.richEntries(), Seq$.MODULE$.canBuildFrom());
            Seq hiFreq = (Seq)reader.structure().hiFreqLog().logs().flatMap((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.compactEntries(), Seq$.MODULE$.canBuildFrom());
            Seq loFreq = (Seq)reader.structure().loFreqLog().logs().flatMap((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.richEntries(), Seq$.MODULE$.canBuildFrom());
            Ordering ordering = package$.MODULE$.Ordering().fromLessThan((Function2 & java.io.Serializable & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)FlightRecorderReader$.$anonfun$dumpToStdout$4(a, b)));
            SortedSet sorted = (SortedSet)SortedSet$.MODULE$.apply(alerts, ordering).$plus$plus((GenTraversableOnce)hiFreq).$plus$plus((GenTraversableOnce)loFreq);
            Predef$.MODULE$.println((Object)"--- FLIGHT RECORDER LOG");
            sorted.foreach((Function1 & java.io.Serializable & Serializable)x -> {
                Predef$.MODULE$.println(x);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (channel != null) {
                channel.close();
            }
            if (raFile != null) {
                raFile.close();
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$dumpToStdout$4(FlightRecorderReader.Entry a, FlightRecorderReader.Entry b) {
        return a.timeStamp().isBefore(b.timeStamp());
    }

    private FlightRecorderReader$() {
        MODULE$ = this;
        this.AlertSectionParameters = new FlightRecorderReader.SectionParameters(FlightRecorder$.MODULE$.AlertSectionOffset(), FlightRecorder$.MODULE$.AlertSectionSize(), FlightRecorder$.MODULE$.AlertLogSize(), FlightRecorder$.MODULE$.AlertWindow(), FlightRecorder$.MODULE$.AlertRecordSize(), 1L);
        this.LoFreqSectionParameters = new FlightRecorderReader.SectionParameters(FlightRecorder$.MODULE$.LoFreqSectionOffset(), FlightRecorder$.MODULE$.LoFreqSectionSize(), FlightRecorder$.MODULE$.LoFreqLogSize(), FlightRecorder$.MODULE$.LoFreqWindow(), FlightRecorder$.MODULE$.LoFreqRecordSize(), 1L);
        this.HiFreqSectionParameters = new FlightRecorderReader.SectionParameters(FlightRecorder$.MODULE$.HiFreqSectionOffset(), FlightRecorder$.MODULE$.HiFreqSectionSize(), FlightRecorder$.MODULE$.HiFreqLogSize(), FlightRecorder$.MODULE$.HiFreqWindow(), FlightRecorder$.MODULE$.HiFreqRecordSize(), FlightRecorder$.MODULE$.HiFreqBatchSize());
    }
}

