/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.rendering;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpResponseParser$OneHundredContinueError$;
import akka.http.impl.engine.rendering.HttpRequestRendererFactory;
import akka.http.impl.engine.rendering.RenderSupport$;
import akka.http.impl.engine.rendering.RenderSupport$CheckContentLengthTransformer$;
import akka.http.impl.engine.rendering.RenderSupport$ChunkTransformer$;
import akka.http.impl.engine.rendering.RequestRenderingContext;
import akka.http.impl.util.ByteStringRendering;
import akka.http.impl.util.Renderer$;
import akka.http.impl.util.package$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.RequestEntityAcceptance;
import akka.http.scaladsl.model.RequestEntityAcceptance$Expected$;
import akka.http.scaladsl.model.UriRendering$;
import akka.http.scaladsl.model.headers.Content$minusLength;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType;
import akka.http.scaladsl.model.headers.CustomHeader;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.http.scaladsl.model.headers.Transfer$minusEncoding;
import akka.http.scaladsl.model.headers.Transfer$minusEncoding$;
import akka.http.scaladsl.model.headers.User$minusAgent;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rc!B\u0001\u0003\u0001!a!A\u0007%uiB\u0014V-];fgR\u0014VM\u001c3fe\u0016\u0014h)Y2u_JL(BA\u0002\u0005\u0003%\u0011XM\u001c3fe&twM\u0003\u0002\u0006\r\u00051QM\\4j]\u0016T!a\u0002\u0005\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u0013)\tA\u0001\u001b;ua*\t1\"\u0001\u0003bW.\f7C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\"AA\u0003\u0001B\u0001B\u0003%a#A\bvg\u0016\u0014\u0018iZ3oi\"+\u0017\rZ3s\u0007\u0001\u00012AD\f\u001a\u0013\tArB\u0001\u0004PaRLwN\u001c\t\u00035\u0005j\u0011a\u0007\u0006\u00039u\tq\u0001[3bI\u0016\u00148O\u0003\u0002\u001f?\u0005)Qn\u001c3fY*\u0011\u0001\u0005C\u0001\tg\u000e\fG.\u00193tY&\u0011!e\u0007\u0002\u0010+N,'\u000fJ7j]V\u001c\u0018iZ3oi\"AA\u0005\u0001B\u0001B\u0003%Q%A\u000bsKF,Xm\u001d;IK\u0006$WM]*ju\u0016D\u0015N\u001c;\u0011\u000591\u0013BA\u0014\u0010\u0005\rIe\u000e\u001e\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005\u0019An\\4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055R\u0011!B3wK:$\u0018BA\u0018-\u00059aunZ4j]\u001e\fE-\u00199uKJDQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD\u0003B\u001a6m]\u0002\"\u0001\u000e\u0001\u000e\u0003\tAQ\u0001\u0006\u0019A\u0002YAQ\u0001\n\u0019A\u0002\u0015BQ!\u000b\u0019A\u0002)BQ!\u000f\u0001\u0005\u0002i\naB]3oI\u0016\u0014Hk\\*pkJ\u001cW\r\u0006\u0002<\u0017B!A\b\u0011\"I\u001b\u0005i$B\u0001\u0011?\u0015\ty$\"\u0001\u0004tiJ,\u0017-\\\u0005\u0003\u0003v\u0012aaU8ve\u000e,\u0007CA\"G\u001b\u0005!%BA#\u000b\u0003\u0011)H/\u001b7\n\u0005\u001d#%A\u0003\"zi\u0016\u001cFO]5oOB\u0011a\"S\u0005\u0003\u0015>\u00111!\u00118z\u0011\u0015a\u0005\b1\u0001N\u0003\r\u0019G\u000f\u001f\t\u0003i9K!a\u0014\u0002\u0003/I+\u0017/^3tiJ+g\u000eZ3sS:<7i\u001c8uKb$\b\"B)\u0001\t\u0003\u0011\u0016A\u0002:f]\u0012,'\u000fF\u0002T\u0005_\u0001\"\u0001\u00165\u000f\u0005Q*vA\u0002,\u0003\u0011\u0003Aq+\u0001\u000eIiR\u0004(+Z9vKN$(+\u001a8eKJ,'OR1di>\u0014\u0018\u0010\u0005\u000251\u001a1\u0011A\u0001E\u0001\u0011e\u001b\"\u0001W\u0007\t\u000bEBF\u0011A.\u0015\u0003]CQ!\u0018-\u0005\u0002y\u000bAB]3oI\u0016\u00148\u000b\u001e:jGR$BAQ0aO\")A\n\u0018a\u0001\u001b\")\u0011\r\u0018a\u0001E\u0006A1/\u001a;uS:<7\u000f\u0005\u0002dK6\tAM\u0003\u0002b?%\u0011a\r\u001a\u0002\u0019\u00072LWM\u001c;D_:tWm\u0019;j_:\u001cV\r\u001e;j]\u001e\u001c\b\"B\u0015]\u0001\u0004QcaB5Y!\u0003\r\nC\u001b\u0002\u0017%\u0016\fX/Z:u%\u0016tG-\u001a:j]\u001e|U\u000f\u001e9viN\u0011\u0001.\u0004\u0005\u0006Y\"4\t!\\\u0001\u000bEf$Xm\u0015;sK\u0006lW#A\u001e*\u0007!|wOB\u0003qc\u0002\u000b)P\u0001\u0005TiJ,\u0017-\\3e\r\u0015I\u0007\f#\u0001s'\t\tX\u0002C\u00032c\u0012\u0005A\u000fF\u0001v!\t1\u0018/D\u0001Y\r\u0011A\u0018\u000fQ=\u0003\rM#(/[2u'\u00159XB_>\u007f!\t1\b\u000e\u0005\u0002\u000fy&\u0011Qp\u0004\u0002\b!J|G-^2u!\tqq0C\u0002\u0002\u0002=\u0011AbU3sS\u0006d\u0017N_1cY\u0016D!\"!\u0002x\u0005+\u0007I\u0011AA\u0004\u0003\u0015\u0011\u0017\u0010^3t+\u0005\u0011\u0005\"CA\u0006o\nE\t\u0015!\u0003C\u0003\u0019\u0011\u0017\u0010^3tA!1\u0011g\u001eC\u0001\u0003\u001f!B!!\u0005\u0002\u0016A\u0019\u00111C<\u000e\u0003EDq!!\u0002\u0002\u000e\u0001\u0007!\tC\u0003mo\u0012\u0005Q\u000eC\u0005\u0002\u001c]\f\t\u0011\"\u0001\u0002\u001e\u0005!1m\u001c9z)\u0011\t\t\"a\b\t\u0013\u0005\u0015\u0011\u0011\u0004I\u0001\u0002\u0004\u0011\u0005\"CA\u0012oF\u0005I\u0011AA\u0013\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\n+\u0007\t\u000bIc\u000b\u0002\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012!C;oG\",7m[3e\u0015\r\t)dD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001d\u0003_\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tid^A\u0001\n\u0003\ny$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003mC:<'BAA&\u0003\u0011Q\u0017M^1\n\t\u0005=\u0013Q\t\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u0005Ms/!A\u0005\u0002\u0005U\u0013\u0001\u00049s_\u0012,8\r^!sSRLX#A\u0013\t\u0013\u0005es/!A\u0005\u0002\u0005m\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004\u0011\u0006u\u0003\"CA0\u0003/\n\t\u00111\u0001&\u0003\rAH%\r\u0005\n\u0003G:\u0018\u0011!C!\u0003K\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0002R!!\u001b\u0002p!k!!a\u001b\u000b\u0007\u00055t\"\u0001\u0006d_2dWm\u0019;j_:LA!!\u001d\u0002l\tA\u0011\n^3sCR|'\u000fC\u0005\u0002v]\f\t\u0011\"\u0001\u0002x\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002z\u0005}\u0004c\u0001\b\u0002|%\u0019\u0011QP\b\u0003\u000f\t{w\u000e\\3b]\"I\u0011qLA:\u0003\u0003\u0005\r\u0001\u0013\u0005\n\u0003\u0007;\u0018\u0011!C!\u0003\u000b\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002K!I\u0011\u0011R<\u0002\u0002\u0013\u0005\u00131R\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\t\u0005\n\u0003\u001f;\u0018\u0011!C!\u0003#\u000ba!Z9vC2\u001cH\u0003BA=\u0003'C\u0011\"a\u0018\u0002\u000e\u0006\u0005\t\u0019\u0001%\b\u0013\u0005]\u0015/!A\t\u0002\u0005e\u0015AB*ue&\u001cG\u000f\u0005\u0003\u0002\u0014\u0005me\u0001\u0003=r\u0003\u0003E\t!!(\u0014\u000b\u0005m\u0015q\u0014@\u0011\u000f\u0005\u0005\u0016q\u0015\"\u0002\u00125\u0011\u00111\u0015\u0006\u0004\u0003K{\u0011a\u0002:v]RLW.Z\u0005\u0005\u0003S\u000b\u0019KA\tBEN$(/Y2u\rVt7\r^5p]FBq!MAN\t\u0003\ti\u000b\u0006\u0002\u0002\u001a\"Q\u0011\u0011RAN\u0003\u0003%)%a#\t\u0015\u0005M\u00161TA\u0001\n\u0003\u000b),A\u0003baBd\u0017\u0010\u0006\u0003\u0002\u0012\u0005]\u0006bBA\u0003\u0003c\u0003\rA\u0011\u0005\u000b\u0003w\u000bY*!A\u0005\u0002\u0006u\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u007f\u000b\t\rE\u0002\u000f/\tC!\"a1\u0002:\u0006\u0005\t\u0019AA\t\u0003\rAH\u0005\r\u0005\u000b\u0003\u000f\fY*!A\u0005\n\u0005%\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a3\u0011\t\u0005\r\u0013QZ\u0005\u0005\u0003\u001f\f)E\u0001\u0004PE*,7\r^\u0004\n\u0003'\f\u0018\u0011!E\u0001\u0003+\f\u0001b\u0015;sK\u0006lW\r\u001a\t\u0005\u0003'\t9N\u0002\u0005qc\u0006\u0005\t\u0012AAm'\u0015\t9.a7\u007f!\u001d\t\t+a*<\u0003;\u00042!a\u0005p\u0011\u001d\t\u0014q\u001bC\u0001\u0003C$\"!!6\t\u0015\u0005%\u0015q[A\u0001\n\u000b\nY\t\u0003\u0006\u00024\u0006]\u0017\u0011!CA\u0003O$B!!8\u0002j\"1A.!:A\u0002mB!\"a/\u0002X\u0006\u0005I\u0011QAw)\u0011\ty/!=\u0011\u0007992\b\u0003\u0006\u0002D\u0006-\u0018\u0011!a\u0001\u0003;D!\"a2\u0002X\u0006\u0005I\u0011BAe'\u0015yWB_>\u007f\u0011!awN!f\u0001\n\u0003i\u0007\"CA~_\nE\t\u0015!\u0003<\u0003-\u0011\u0017\u0010^3TiJ,\u0017-\u001c\u0011\t\rEzG\u0011AA\u0000)\u0011\tiN!\u0001\t\r1\fi\u00101\u0001<\u0011%\tYb\\A\u0001\n\u0003\u0011)\u0001\u0006\u0003\u0002^\n\u001d\u0001\u0002\u00037\u0003\u0004A\u0005\t\u0019A\u001e\t\u0013\u0005\rr.%A\u0005\u0002\t-QC\u0001B\u0007U\rY\u0014\u0011\u0006\u0005\n\u0003{y\u0017\u0011!C!\u0003\u007fA\u0011\"a\u0015p\u0003\u0003%\t!!\u0016\t\u0013\u0005es.!A\u0005\u0002\tUAc\u0001%\u0003\u0018!I\u0011q\fB\n\u0003\u0003\u0005\r!\n\u0005\n\u0003Gz\u0017\u0011!C!\u0003KB\u0011\"!\u001ep\u0003\u0003%\tA!\b\u0015\t\u0005e$q\u0004\u0005\n\u0003?\u0012Y\"!AA\u0002!C\u0011\"a!p\u0003\u0003%\t%!\"\t\u0013\u0005%u.!A\u0005B\u0005-\u0005\"CAH_\u0006\u0005I\u0011\tB\u0014)\u0011\tIH!\u000b\t\u0013\u0005}#QEA\u0001\u0002\u0004AuA\u0002B\u00171\"\u0005Q/\u0001\fSKF,Xm\u001d;SK:$WM]5oO>+H\u000f];u\u0011\u0015a\u0005\u000b1\u0001N\u0011\u0019i\u0006\u0001\"\u0001\u00034Q\u0019!I!\u000e\t\r1\u0013\t\u00041\u0001NQ\r\u0001!\u0011\b\t\u0005\u0005w\u0011y$\u0004\u0002\u0003>)\u0019\u0011Q\u0007\u0006\n\t\t\u0005#Q\b\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public class HttpRequestRendererFactory {
    private final Option<User$minusAgent> userAgentHeader;
    private final int requestHeaderSizeHint;
    private final LoggingAdapter log;

    public Source<ByteString, Object> renderToSource(RequestRenderingContext ctx) {
        return this.render(ctx).byteStream();
    }

    public RequestRenderingOutput render(RequestRenderingContext ctx) {
        ByteStringRendering r = new ByteStringRendering(this.requestHeaderSizeHint);
        HttpRequestRendererFactory.renderRequestLine$1(ctx, r);
        this.renderHeaders$1(ctx.request().headers().toList(), HttpRequestRendererFactory.renderHeaders$default$2$1(), HttpRequestRendererFactory.renderHeaders$default$3$1(), HttpRequestRendererFactory.renderHeaders$default$4$1(), ctx, r);
        RenderSupport$.MODULE$.renderEntityContentType(r, ctx.request().entity());
        return HttpRequestRendererFactory.completeRequestRendering$1(ctx, r);
    }

    public ByteString renderStrict(RequestRenderingContext ctx) {
        ByteString bytes;
        RequestRenderingOutput requestRenderingOutput = this.render(ctx);
        if (!(requestRenderingOutput instanceof RequestRenderingOutput.Strict)) {
            if (requestRenderingOutput instanceof RequestRenderingOutput.Streamed) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request entity was not Strict but ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.request().entity().getClass().getSimpleName()})));
            }
            throw new MatchError((Object)requestRenderingOutput);
        }
        RequestRenderingOutput.Strict strict = (RequestRenderingOutput.Strict)requestRenderingOutput;
        ByteString byteString = bytes = strict.bytes();
        return byteString;
    }

    public static final /* synthetic */ boolean $anonfun$render$1(ByteStringRendering r$1, HttpHeader x0$1) {
        boolean bl;
        HttpHeader httpHeader = x0$1;
        if (httpHeader instanceof Raw$minusRequest$minusURI) {
            Raw$minusRequest$minusURI raw$minusRequest$minusURI = (Raw$minusRequest$minusURI)httpHeader;
            String rawUri = raw$minusRequest$minusURI.uri();
            r$1.$tilde$tilde(rawUri);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void renderRequestLine$1(RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        ((ByteStringRendering)r$1.$tilde$tilde(ctx$1.request().method(), Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(' ');
        boolean rawRequestUriRendered = ctx$1.request().headers().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestRendererFactory.$anonfun$render$1(r$1, x0$1)));
        Object object = !rawRequestUriRendered ? UriRendering$.MODULE$.renderUriWithoutFragment(r$1, ctx$1.request().uri(), package$.MODULE$.UTF8()) : BoxedUnit.UNIT;
        r$1.$tilde$tilde(' ').$tilde$tilde(ctx$1.request().protocol(), Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
    }

    private static final ByteStringRendering render$1(HttpHeader h, ByteStringRendering r$1) {
        return (ByteStringRendering)r$1.$tilde$tilde(h, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
    }

    private final void renderHeaders$1(List remaining, boolean hostHeaderSeen, boolean userAgentSeen, boolean transferEncodingSeen, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        BoxedUnit boxedUnit;
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            ByteStringRendering byteStringRendering;
            RawHeader rawHeader;
            .colon.colon colon2 = (.colon.colon)list;
            HttpHeader head = (HttpHeader)colon2.head();
            List tail = colon2.tl$access$1();
            HttpHeader httpHeader = head;
            if (httpHeader instanceof Content$minusLength) {
                Content$minusLength content$minusLength = (Content$minusLength)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(this.log, content$minusLength, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.");
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Content$minusType) {
                Content$minusType content$minusType = (Content$minusType)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(this.log, content$minusType, "explicit `Content-Type` header is not allowed. Set `HttpRequest.entity.contentType` instead.");
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Transfer$minusEncoding) {
                Transfer$minusEncoding transfer$minusEncoding = (Transfer$minusEncoding)httpHeader;
                Option<Transfer$minusEncoding> option = transfer$minusEncoding.withChunkedPeeled();
                if (None$.MODULE$.equals(option)) {
                    RenderSupport$.MODULE$.suppressionWarning(this.log, head, RenderSupport$.MODULE$.suppressionWarning$default$3());
                    remaining = tail;
                    continue;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Transfer$minusEncoding te = (Transfer$minusEncoding)some.value();
                    HttpRequestRendererFactory.render$1(ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() ? te.withChunked() : te, r$1);
                    transferEncodingSeen = true;
                    remaining = tail;
                    continue;
                }
                throw new MatchError(option);
            }
            if (httpHeader instanceof Host) {
                Host host = (Host)httpHeader;
                HttpRequestRendererFactory.render$1(host, r$1);
                hostHeaderSeen = true;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof User$minusAgent) {
                User$minusAgent user$minusAgent = (User$minusAgent)httpHeader;
                HttpRequestRendererFactory.render$1(user$minusAgent, r$1);
                userAgentSeen = true;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Raw$minusRequest$minusURI) {
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof CustomHeader) {
                CustomHeader customHeader = (CustomHeader)httpHeader;
                Object object = customHeader.renderInRequests() ? HttpRequestRendererFactory.render$1(customHeader, r$1) : BoxedUnit.UNIT;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof RawHeader && ((rawHeader = (RawHeader)httpHeader).is("content-type") || rawHeader.is("content-length") || rawHeader.is("transfer-encoding") || rawHeader.is("host") || rawHeader.is("user-agent"))) {
                RenderSupport$.MODULE$.suppressionWarning(this.log, rawHeader, "illegal RawHeader");
                remaining = tail;
                continue;
            }
            if (httpHeader.renderInRequests()) {
                byteStringRendering = HttpRequestRendererFactory.render$1(httpHeader, r$1);
            } else {
                this.log.warning("HTTP header '{}' is not allowed in requests", (Object)httpHeader);
                byteStringRendering = BoxedUnit.UNIT;
            }
            remaining = tail;
        }
        if (Nil$.MODULE$.equals(list)) {
            Object object = !hostHeaderSeen ? r$1.$tilde$tilde(ctx$1.hostHeader(), Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer()) : BoxedUnit.UNIT;
            Object object2 = !userAgentSeen && this.userAgentHeader.isDefined() ? r$1.$tilde$tilde(this.userAgentHeader.get(), Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer()) : BoxedUnit.UNIT;
            if (ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() && !transferEncodingSeen) {
                ((ByteStringRendering)r$1.$tilde$tilde(Transfer$minusEncoding$.MODULE$, Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(RenderSupport$.MODULE$.ChunkedBytes()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)list);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final boolean renderHeaders$default$2$1() {
        return false;
    }

    private static final boolean renderHeaders$default$3$1() {
        return false;
    }

    private static final boolean renderHeaders$default$4$1() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final ByteStringRendering renderContentLength$1(long contentLength, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        ByteStringRendering byteStringRendering;
        block2: {
            block3: {
                if (!ctx$1.request().method().isEntityAccepted()) break block2;
                if (contentLength > 0L) break block3;
                RequestEntityAcceptance requestEntityAcceptance = ctx$1.request().method().requestEntityAcceptance();
                RequestEntityAcceptance$Expected$ requestEntityAcceptance$Expected$ = RequestEntityAcceptance$Expected$.MODULE$;
                if (requestEntityAcceptance != null ? !requestEntityAcceptance.equals(requestEntityAcceptance$Expected$) : requestEntityAcceptance$Expected$ != null) break block2;
            }
            byteStringRendering = (ByteStringRendering)r$1.$tilde$tilde(Content$minusLength$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(contentLength).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            return byteStringRendering;
        }
        byteStringRendering = r$1;
        return byteStringRendering;
    }

    private static final RequestRenderingOutput renderStreamed$1(Source body, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        Source source;
        Source headerPart = Source$.MODULE$.single((Object)r$1.get());
        Option<Future<NotUsed>> option = ctx$1.sendEntityTrigger();
        if (None$.MODULE$.equals(option)) {
            source = (Source)headerPart.$plus$plus((Graph)body);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Future future = (Future)some.value();
            Source barrier = (Source)Source$.MODULE$.fromFuture(future).drop(1L);
            source = (Source)headerPart.$plus$plus((Graph)barrier).$plus$plus((Graph)body).recoverWithRetries(-1, (PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = HttpResponseParser$OneHundredContinueError$.MODULE$.equals(A1) ? Source$.MODULE$.empty() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = HttpResponseParser$OneHundredContinueError$.MODULE$.equals(throwable);
                    return bl;
                }
            });
        } else {
            throw new MatchError(option);
        }
        Source stream = source;
        return new RequestRenderingOutput.Streamed((Source<ByteString, Object>)stream);
    }

    private static final RequestRenderingOutput completeRequestRendering$1(RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        RequestRenderingOutput requestRenderingOutput;
        RequestEntity requestEntity = ctx$1.request().entity();
        if (requestEntity.isKnownEmpty()) {
            HttpRequestRendererFactory.renderContentLength$1(0L, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            requestRenderingOutput = new RequestRenderingOutput.Strict(r$1.get());
        } else if (requestEntity instanceof HttpEntity.Strict) {
            HttpEntity.Strict strict = (HttpEntity.Strict)requestEntity;
            ByteString data = strict.data();
            HttpRequestRendererFactory.renderContentLength$1(data.length(), ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            requestRenderingOutput = ctx$1.sendEntityTrigger().isDefined() ? HttpRequestRendererFactory.renderStreamed$1(Source$.MODULE$.single((Object)data), ctx$1, r$1) : new RequestRenderingOutput.Strict(r$1.get().$plus$plus(data));
        } else if (requestEntity instanceof HttpEntity.Default) {
            HttpEntity.Default default_ = (HttpEntity.Default)requestEntity;
            long contentLength = default_.contentLength();
            Source<ByteString, Object> data = default_.data();
            HttpRequestRendererFactory.renderContentLength$1(contentLength, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            requestRenderingOutput = HttpRequestRendererFactory.renderStreamed$1(data.via(RenderSupport$CheckContentLengthTransformer$.MODULE$.flow(contentLength)), ctx$1, r$1);
        } else if (requestEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked chunked = (HttpEntity.Chunked)requestEntity;
            Source<HttpEntity.ChunkStreamPart, Object> chunks = chunked.chunks();
            r$1.$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            requestRenderingOutput = HttpRequestRendererFactory.renderStreamed$1(chunks.via(RenderSupport$ChunkTransformer$.MODULE$.flow()), ctx$1, r$1);
        } else {
            throw new MatchError((Object)requestEntity);
        }
        return requestRenderingOutput;
    }

    public HttpRequestRendererFactory(Option<User$minusAgent> userAgentHeader, int requestHeaderSizeHint, LoggingAdapter log) {
        this.userAgentHeader = userAgentHeader;
        this.requestHeaderSizeHint = requestHeaderSizeHint;
        this.log = log;
    }

    public static interface RequestRenderingOutput {
        public Source<ByteString, Object> byteStream();
    }
}

