/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.cluster.full.downing;

import akka.actor.Address;
import akka.actor.Props;
import akka.cluster.Member;
import com.xebialabs.xlplatform.cluster.NodeState$;
import com.xebialabs.xlplatform.cluster.full.downing.AutoDowning$;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor$DownReachable$;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor$DownUnreachable$;
import com.xebialabs.xlplatform.cluster.full.downing.MajorityLeaderAutoDowning$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%<Q!\u0001\u0002\t\u0002=\t\u0011$T1k_JLG/\u001f'fC\u0012,'/Q;u_\u0012{wO\\5oO*\u00111\u0001B\u0001\bI><h.\u001b8h\u0015\t)a!\u0001\u0003gk2d'BA\u0004\t\u0003\u001d\u0019G.^:uKJT!!\u0003\u0006\u0002\u0015ad\u0007\u000f\\1uM>\u0014XN\u0003\u0002\f\u0019\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001A\u0011\u0001#E\u0007\u0002\u0005\u0019)!C\u0001E\u0001'\tIR*\u00196pe&$\u0018\u0010T3bI\u0016\u0014\u0018)\u001e;p\t><h.\u001b8h'\t\tB\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\u0005\u00067E!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=AQAH\t\u0005\u0002}\tQ\u0001\u001d:paN$2\u0001\t\u00153!\t\tc%D\u0001#\u0015\t\u0019C%A\u0003bGR|'OC\u0001&\u0003\u0011\t7n[1\n\u0005\u001d\u0012#!\u0002)s_B\u001c\b\"B\u0015\u001e\u0001\u0004Q\u0013aC:uC\ndW-\u00114uKJ\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u0011\u0011,(/\u0019;j_:T!a\f\f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u00022Y\tqa)\u001b8ji\u0016$UO]1uS>t\u0007\"B\u001a\u001e\u0001\u0004Q\u0013!\u00053po:\u0014V-\\8wC2l\u0015M]4j]\u001a!!C\u0001\u00016'\t!d\u0007\u0005\u0002\u0011o%\u0011\u0001H\u0001\u0002\u0017\u0019\u0016\fG-\u001a:BkR|Gi\\<oS:<\u0017i\u0019;pe\"I\u0011\u0006\u000eB\u0001B\u0003%!FO\u0005\u0003S]B\u0011b\r\u001b\u0003\u0002\u0003\u0006IA\u000b\u001f\n\u0005M:\u0004\"B\u000e5\t\u0003qDcA A\u0003B\u0011\u0001\u0003\u000e\u0005\u0006Su\u0002\rA\u000b\u0005\u0006gu\u0002\rA\u000b\u0005\u0006\u0007R\"\t\u0001R\u0001\u0007I\u0016\u001c\u0017\u000eZ3\u0015\u0003\u0015\u0003\"A\u0012-\u000f\u0005\u001d3fB\u0001%V\u001d\tIEK\u0004\u0002K':\u00111J\u0015\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!a\u0014\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!a\u0016\u0002\u0002-1+\u0017\rZ3s\u0003V$x\u000eR8x]&tw-Q2u_JL!!\u0017.\u0003\u0015\u0011{wO\\!di&|gN\u0003\u0002X\u0005!)A\f\u000eC!;\u0006!Am\\<o)\tq\u0016\r\u0005\u0002\u0016?&\u0011\u0001M\u0006\u0002\u0005+:LG\u000fC\u0003c7\u0002\u00071-\u0001\u0003o_\u0012,\u0007CA\u0011e\u0013\t)'EA\u0004BI\u0012\u0014Xm]:\t\u000b\u001d$D\u0011\t5\u0002\u0011\u0011|wO\\*fY\u001a$\u0012A\u0018")
public class MajorityLeaderAutoDowning
extends LeaderAutoDowningActor {
    public static Props props(FiniteDuration finiteDuration, FiniteDuration finiteDuration2) {
        return MajorityLeaderAutoDowning$.MODULE$.props(finiteDuration, finiteDuration2);
    }

    @Override
    public LeaderAutoDowningActor.DownAction decide() {
        LeaderAutoDowningActor.DownAction downAction;
        int unreachableSize = this.unreachableMembers().size();
        int membersSize = this.members().size();
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deciding on current cluster state: ", " of ", " members unreachable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)unreachableSize), BoxesRunTime.boxToInteger((int)membersSize)})));
        if (unreachableSize * 2 == membersSize) {
            this.log().info("Both partitions are equal in size, break the tie by keeping the side with oldest member.");
            Address oldestMember = ((Member)this.members().head()).address();
            boolean oldestIsActive = this.isActiveMember(oldestMember);
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Oldest member [", "] detected as being ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldestMember, oldestIsActive ? "active" : "inactive"})));
            if (this.unreachable().apply((Object)oldestMember) && oldestIsActive) {
                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downing my partition [", "] - other partition has active oldest."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reachable()})));
                downAction = LeaderAutoDowningActor$DownReachable$.MODULE$;
            } else if (this.reachable().apply((Object)oldestMember) && !oldestIsActive) {
                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downing my partition [", "] - my partition has invalid oldest."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reachable()})));
                downAction = LeaderAutoDowningActor$DownReachable$.MODULE$;
            } else {
                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downing other partition [", "] - my partition has the current active oldest."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unreachable()})));
                downAction = LeaderAutoDowningActor$DownUnreachable$.MODULE$;
            }
        } else if (unreachableSize * 2 < membersSize) {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We are in majority, downing other partition [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unreachable()})));
            downAction = LeaderAutoDowningActor$DownUnreachable$.MODULE$;
        } else {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We are in minority, downing my partition [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reachable()})));
            downAction = LeaderAutoDowningActor$DownReachable$.MODULE$;
        }
        return downAction;
    }

    @Override
    public void down(Address node) {
        this.log().info("Downing member [{}].", (Object)node);
        this.cluster().down(node);
    }

    @Override
    public void downSelf() {
        this.log().info("Deactivating myself.");
        NodeState$.MODULE$.setActive(false);
        AutoDowning$.MODULE$.setDowning(true);
        this.log().info("Downing myself.");
        this.shutdownMember();
    }

    public MajorityLeaderAutoDowning(FiniteDuration stableAfter, FiniteDuration downRemovalMargin) {
        super(stableAfter, downRemovalMargin);
    }
}

