/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.license.Clock;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.AbstractLicenseService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseServiceImpl
extends AbstractLicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private final LicenseReader licenseReader = new LicenseReader();

    public LicenseServiceImpl(String licensePath, String product, RepositoryMetadataService repositoryMetadataService) throws IOException, LicenseParseException, LicenseViolationException {
        super(licensePath, product, repositoryMetadataService);
        if (!this.licenseFile.exists()) {
            this.logLicenseError(this.licenseFile);
            throw new FileNotFoundException("License cannot be found at " + this.licenseFile.getAbsolutePath());
        }
        this.license = this.readLicense(this.licenseFile);
        if (this.license.isDateExpired()) {
            this.logLicenseError(this.licenseFile);
        }
        if (!this.license.isAtLeastVersion(3)) {
            this.logLicenseVersionError(this.license, 3);
        }
        if (!this.isValidEdition(this.license)) {
            this.logLicenseEditionError(this.license);
        }
    }

    protected LicenseServiceImpl(String licensePath, String product, RepositoryMetadataService repositoryMetadataService, Clock clock) throws IOException, LicenseParseException, LicenseViolationException {
        super(licensePath, product, repositoryMetadataService, clock);
        if (!this.licenseFile.exists()) {
            this.logLicenseError(this.licenseFile);
            throw new FileNotFoundException("License cannot be found at " + this.licenseFile.getAbsolutePath());
        }
        this.license = this.readLicense(this.licenseFile);
        if (this.license.isDateExpired()) {
            this.logLicenseError(this.licenseFile);
        }
        if (!this.license.isAtLeastVersion(3)) {
            this.logLicenseVersionError(this.license, 3);
        }
        if (!this.isValidEdition(this.license)) {
            this.logLicenseEditionError(this.license);
        }
    }

    @Override
    protected License readLicense(File licenseFile) throws LicenseParseException, LicenseViolationException {
        String licenseFilePath = licenseFile.getAbsolutePath();
        log.info("Reading license from file {}", (Object)licenseFilePath);
        License license = this.licenseReader.readLicense(licenseFile);
        log.info(license.toLicenseContent());
        if (license.isDateExpired()) {
            log.warn("*** License has expired.");
        }
        return license;
    }
}

