/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth;

import com.xebialabs.deployit.core.sql.SqlDialect;
import java.util.Date;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001-\u0011QD\u00133cGJ+W.Z7cKJlU\rV8lK:\u0014V\r]8tSR|'/\u001f\u0006\u0003\u0007\u0011\tA!Y;uQ*\u0011QAB\u0001\tq2$W\r\u001d7ps*\u0011q\u0001C\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!C\u0001\u0004G>l7\u0001A\n\u0004\u00011Q\u0002CA\u0007\u0019\u001b\u0005q!BA\b\u0011\u0003\u001d\u0019X\u000f\u001d9peRT!!\u0005\n\u0002\t\r|'/\u001a\u0006\u0003'Q\tAA\u001b3cG*\u0011QCF\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq#A\u0002pe\u001eL!!\u0007\b\u0003\u001d)#'m\u0019#b_N+\b\u000f]8siB\u00111\u0004J\u0007\u00029)\u0011QDH\u0001\u000be\u0016lW-\u001c2fe6,'BA\u0010!\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!!\t\u0012\u0002\u0007],'M\u0003\u0002$)\u0005A1/Z2ve&$\u00180\u0003\u0002&9\tI\u0002+\u001a:tSN$XM\u001c;U_.,gNU3q_NLGo\u001c:z\u0011!9\u0003A!b\u0001\n\u0003A\u0013A\u00033bi\u0006\u001cv.\u001e:dKV\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00039\nQA[1wCbL!\u0001M\u0016\u0003\u0015\u0011\u000bG/Y*pkJ\u001cW\r\u0003\u00053\u0001\t\u0005\t\u0015!\u0003*\u0003-!\u0017\r^1T_V\u00148-\u001a\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\nq\u0001Z5bY\u0016\u001cG/F\u00017!\t9D(D\u00019\u0015\ta\u0013H\u0003\u0002\u0012u)\u00111HB\u0001\tI\u0016\u0004Hn\\=ji&\u0011Q\b\u000f\u0002\u000b'FdG)[1mK\u000e$\b\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u0011\u0011L\u0017\r\\3di\u0002BQ!\u0011\u0001\u0005\u0002\t\u000ba\u0001P5oSRtDcA\"F1B\u0011A\tA\u0007\u0002\u0005!)q\u0005\u0011a\u0001S!\"QiR)S!\tAu*D\u0001J\u0015\tQ5*\u0001\u0006b]:|G/\u0019;j_:T!\u0001T'\u0002\u000f\u0019\f7\r^8ss*\u0011a\nF\u0001\u0006E\u0016\fgn]\u0005\u0003!&\u0013\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003M\u000ba\"\\1j]\u0012\u000bG/Y*pkJ\u001cW\r\u000b\u0002F+B\u0011\u0001JV\u0005\u0003/&\u0013\u0011\"Q;u_^L'/\u001a3\t\u000bQ\u0002\u0005\u0019\u0001\u001c)\ta;\u0015KW\u0011\u00027\u0006qQ.Y5o'FdG)[1mK\u000e$\bF\u0001-V\u0011\u0015q\u0006\u0001\"\u0011`\u0003-)\b\u000fZ1uKR{7.\u001a8\u0015\t\u000147/\u001e\t\u0003C\u0012l\u0011A\u0019\u0006\u0002G\u0006)1oY1mC&\u0011QM\u0019\u0002\u0005+:LG\u000fC\u0003h;\u0002\u0007\u0001.\u0001\u0004tKJLWm\u001d\t\u0003SBt!A\u001b8\u0011\u0005-\u0014W\"\u00017\u000b\u00055T\u0011A\u0002\u001fs_>$h(\u0003\u0002pE\u00061\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\ty'\rC\u0003u;\u0002\u0007\u0001.\u0001\u0006u_.,gNV1mk\u0016DQA^/A\u0002]\f\u0001\u0002\\1tiV\u001bX\r\u001a\t\u0003qvl\u0011!\u001f\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u0001@z\u0005\u0011!\u0015\r^3\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004\u0005\tr-\u001a;U_.,gNR8s'\u0016\u0014\u0018.Z:\u0015\t\u0005\u0015\u00111\u0002\t\u00047\u0005\u001d\u0011bAA\u00059\tI\u0002+\u001a:tSN$XM\u001c;SK6,WNY3s\u001b\u0016$vn[3o\u0011\u0019\tia a\u0001Q\u0006A1/\u001a:jKNLE\rC\u0004\u0002\u0012\u0001!\t%a\u0005\u0002\u001d\r\u0014X-\u0019;f\u001d\u0016<Hk\\6f]R\u0019\u0001-!\u0006\t\u0011\u0005]\u0011q\u0002a\u0001\u0003\u000b\tQ\u0001^8lK:Dq!a\u0007\u0001\t\u0003\ni\"\u0001\tsK6|g/Z+tKJ$vn[3ogR\u0019\u0001-a\b\t\u000f\u0005\u0005\u0012\u0011\u0004a\u0001Q\u0006AQo]3s]\u0006lW\rC\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(\u0005\t\u0002/\u001a:tSN$XM\u001c;`Y><\u0017N\\:\u0016\u0003!Dq!a\u000b\u0001A\u0003%\u0001.\u0001\nqKJ\u001c\u0018n\u001d;f]R|Fn\\4j]N\u0004\u0003\"CA\f\u0001\t\u0007I\u0011BA\u0014\u0011\u001d\t\t\u0004\u0001Q\u0001\n!\fa\u0001^8lK:\u0004\u0003\"CA\u001b\u0001\t\u0007I\u0011BA\u0014\u0003%a\u0017m\u001d;`kN,G\rC\u0004\u0002:\u0001\u0001\u000b\u0011\u00025\u0002\u00151\f7\u000f^0vg\u0016$\u0007\u0005\u0003\u0005h\u0001\t\u0007I\u0011BA\u0014\u0011\u001d\ty\u0004\u0001Q\u0001\n!\fqa]3sS\u0016\u001c\b\u0005C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002(!9\u0011Q\t\u0001!\u0002\u0013A\u0017!C;tKJt\u0017-\\3!\u0011%\tI\u0005\u0001b\u0001\n\u0013\t9#\u0001\u0007V!\u0012\u000bE+R0U\u001f.+e\nC\u0004\u0002N\u0001\u0001\u000b\u0011\u00025\u0002\u001bU\u0003F)\u0011+F?R{5*\u0012(!\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t9#\u0001\u0007D%\u0016\u000bE+R0U\u001f.+e\nC\u0004\u0002V\u0001\u0001\u000b\u0011\u00025\u0002\u001b\r\u0013V)\u0011+F?R{5*\u0012(!\u0011%\tI\u0006\u0001b\u0001\n\u0013\t9#\u0001\u0007E\u000b2+E+R0U\u001f.+e\nC\u0004\u0002^\u0001\u0001\u000b\u0011\u00025\u0002\u001b\u0011+E*\u0012+F?R{5*\u0012(!\u0011%\t\t\u0007\u0001b\u0001\n\u0013\t9#A\bU\u001f.+ej\u0018\"Z?N+%+S#T\u0011\u001d\t)\u0007\u0001Q\u0001\n!\f\u0001\u0003V(L\u000b:{&)W0T\u000bJKUi\u0015\u0011)\r\u0001\tI'UA<!\u0011\tY'a\u001d\u000e\u0005\u00055$b\u0001&\u0002p)\u0019\u0011\u0011\u000f\u000b\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003k\niGA\u0007Ue\u0006t7/Y2uS>t\u0017\r\\\u0011\u0003\u0003s\na#\\1j]R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0015\u0004\u0001\u0005u\u0004\u0003BA@\u0003\u000bk!!!!\u000b\u0007\u0005\rE#\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\"\u0002\u0002\nI1i\\7q_:,g\u000e\u001e")
public class JdbcRememberMeTokenRepository
extends JdbcDaoSupport
implements PersistentTokenRepository {
    private final DataSource dataSource;
    private final SqlDialect dialect;
    private final String persistent_logins;
    private final String token;
    private final String last_used;
    private final String series;
    private final String username;
    private final String UPDATE_TOKEN;
    private final String CREATE_TOKEN;
    private final String DELETE_TOKEN;
    private final String TOKEN_BY_SERIES;

    public DataSource dataSource() {
        return this.dataSource;
    }

    public SqlDialect dialect() {
        return this.dialect;
    }

    public void updateToken(String series, String tokenValue, Date lastUsed) {
        this.getJdbcTemplate().update(this.UPDATE_TOKEN(), new Object[]{tokenValue, lastUsed, series});
    }

    public PersistentRememberMeToken getTokenForSeries(String seriesId) {
        try {
            return (PersistentRememberMeToken)this.getJdbcTemplate().queryForObject(this.TOKEN_BY_SERIES(), (rs, rowNum) -> new PersistentRememberMeToken(rs.getString(1), rs.getString(2), rs.getString(3), (Date)rs.getTimestamp(4)), new Object[]{seriesId});
        }
        catch (EmptyResultDataAccessException zeroResults) {
            this.logger.debug((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Querying token for series '", "' returned no results."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seriesId})), (Throwable)zeroResults);
        }
        catch (IncorrectResultSizeDataAccessException moreThanOne) {
            this.logger.error((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Querying token for series '", "' returned more than one value. Series should be unique"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seriesId})));
        }
        catch (DataAccessException e) {
            this.logger.error((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load token for series ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seriesId})), (Throwable)e);
        }
        return null;
    }

    public void createNewToken(PersistentRememberMeToken token) {
        this.getJdbcTemplate().update(this.CREATE_TOKEN(), new Object[]{token.getUsername(), token.getSeries(), token.getTokenValue(), token.getDate()});
    }

    public void removeUserTokens(String username) {
        this.getJdbcTemplate().update(this.DELETE_TOKEN(), new Object[]{username});
    }

    private String persistent_logins() {
        return this.persistent_logins;
    }

    private String token() {
        return this.token;
    }

    private String last_used() {
        return this.last_used;
    }

    private String series() {
        return this.series;
    }

    private String username() {
        return this.username;
    }

    private String UPDATE_TOKEN() {
        return this.UPDATE_TOKEN;
    }

    private String CREATE_TOKEN() {
        return this.CREATE_TOKEN;
    }

    private String DELETE_TOKEN() {
        return this.DELETE_TOKEN;
    }

    private String TOKEN_BY_SERIES() {
        return this.TOKEN_BY_SERIES;
    }

    public JdbcRememberMeTokenRepository(@Autowired @Qualifier(value="mainDataSource") DataSource dataSource, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect dialect) {
        this.dataSource = dataSource;
        this.dialect = dialect;
        super.setDataSource(dataSource);
        this.persistent_logins = dialect.quote("PERSISTENT_LOGINS");
        this.token = dialect.quote("token");
        this.last_used = dialect.quote("last_used");
        this.series = dialect.quote("series");
        this.username = dialect.quote("username");
        this.UPDATE_TOKEN = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set ", " = ?, ", " = ? where ", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.persistent_logins(), this.token(), this.last_used(), this.series()}));
        this.CREATE_TOKEN = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " (", ", ", ", ", ", ", ") values(?,?,?,?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.persistent_logins(), this.username(), this.series(), this.token(), this.last_used()}));
        this.DELETE_TOKEN = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete from ", " where ", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.persistent_logins(), this.username()}));
        this.TOKEN_BY_SERIES = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select ", ", ", ", ", ", ", " from ", " where ", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.username(), this.series(), this.token(), this.last_used(), this.persistent_logins(), this.series()}));
    }
}

