/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Session;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.cluster.ClusterSession;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;

public class ChangeLogRecord
extends ClusterRecord {
    static final char NODE_IDENTIFIER = 'N';
    static final char PROPERTY_IDENTIFIER = 'P';
    static final char EVENT_IDENTIFIER = 'E';
    private static final int ADDED = 1;
    private static final int MODIFIED = 2;
    private static final int DELETED = 3;
    private ChangeLog changes;
    private List events;
    private int identifier;
    private Session lastSession;

    public ChangeLogRecord(ChangeLog changes, List events, Record record, String workspace) {
        super(record, workspace);
        this.changes = changes;
        this.events = events;
    }

    ChangeLogRecord(int identifier, Record record, String workspace) {
        super(record, workspace);
        this.identifier = identifier;
        this.changes = new ChangeLog();
        this.events = new ArrayList();
    }

    protected void doRead() throws JournalException {
        int identifier = this.identifier;
        while (identifier != 0) {
            switch (identifier) {
                case 78: {
                    this.readNodeRecord();
                    break;
                }
                case 80: {
                    this.readPropertyRecord();
                    break;
                }
                case 69: {
                    this.readEventRecord();
                    break;
                }
                default: {
                    String msg = "Unknown identifier: " + identifier;
                    throw new JournalException(msg);
                }
            }
            identifier = this.record.readChar();
        }
    }

    protected void readEndMarker() throws JournalException {
    }

    private void readNodeRecord() throws JournalException {
        byte operation = this.record.readByte();
        NodeState state = new NodeState(this.record.readNodeId(), null, null, 4, false);
        this.apply(operation, state);
    }

    private void readPropertyRecord() throws JournalException {
        byte operation = this.record.readByte();
        PropertyState state = new PropertyState(this.record.readPropertyId(), 4, false);
        this.apply(operation, state);
    }

    private void apply(int operation, ItemState state) throws JournalException {
        switch (operation) {
            case 1: {
                state.setStatus(1);
                this.changes.added(state);
                break;
            }
            case 3: {
                state.setStatus(3);
                this.changes.deleted(state);
                break;
            }
            case 2: {
                state.setStatus(2);
                this.changes.modified(state);
                break;
            }
            default: {
                String msg = "Unknown item operation: " + operation;
                throw new JournalException(msg);
            }
        }
    }

    private void readEventRecord() throws JournalException {
        byte type = this.record.readByte();
        NodeId parentId = this.record.readNodeId();
        Path parentPath = this.record.readPath();
        NodeId childId = this.record.readNodeId();
        Path.Element childRelPath = this.record.readPathElement();
        Name ntName = this.record.readQName();
        HashSet<Name> mixins = new HashSet<Name>();
        int mixinCount = this.record.readInt();
        for (int i = 0; i < mixinCount; ++i) {
            mixins.add(this.record.readQName());
        }
        String userId = this.record.readString();
        this.events.add(this.createEventState(type, parentId, parentPath, childId, childRelPath, ntName, mixins, userId));
    }

    private EventState createEventState(int type, NodeId parentId, Path parentPath, NodeId childId, Path.Element childRelPath, Name ntName, Set mixins, String userId) {
        switch (type) {
            case 1: {
                return EventState.childNodeAdded(parentId, parentPath, childId, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 2: {
                return EventState.childNodeRemoved(parentId, parentPath, childId, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 4: {
                return EventState.propertyAdded(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 16: {
                return EventState.propertyChanged(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 8: {
                return EventState.propertyRemoved(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
        }
        String msg = "Unexpected event type: " + type;
        throw new IllegalArgumentException(msg);
    }

    private Session getOrCreateSession(String userId) {
        if (this.lastSession == null || !this.lastSession.getUserID().equals(userId)) {
            this.lastSession = new ClusterSession(userId);
        }
        return this.lastSession;
    }

    protected void doWrite() throws JournalException {
        Iterator deletedStates = this.changes.deletedStates();
        while (deletedStates.hasNext()) {
            ItemState state = (ItemState)deletedStates.next();
            if (state.isNode()) {
                this.writeNodeRecord(3, (NodeState)state);
                continue;
            }
            this.writePropertyRecord(3, (PropertyState)state);
        }
        Iterator modifiedStates = this.changes.modifiedStates();
        while (modifiedStates.hasNext()) {
            ItemState state = (ItemState)modifiedStates.next();
            if (state.isNode()) {
                this.writeNodeRecord(2, (NodeState)state);
                continue;
            }
            this.writePropertyRecord(2, (PropertyState)state);
        }
        Iterator addedStates = this.changes.addedStates();
        while (addedStates.hasNext()) {
            ItemState state = (ItemState)addedStates.next();
            if (state.isNode()) {
                this.writeNodeRecord(1, (NodeState)state);
                continue;
            }
            this.writePropertyRecord(1, (PropertyState)state);
        }
        Iterator iter = this.events.iterator();
        while (iter.hasNext()) {
            EventState event = (EventState)iter.next();
            this.writeEventRecord(event);
        }
    }

    private void writeNodeRecord(int operation, NodeState state) throws JournalException {
        this.record.writeChar('N');
        this.record.writeByte(operation);
        this.record.writeNodeId(state.getNodeId());
    }

    private void writePropertyRecord(int operation, PropertyState state) throws JournalException {
        this.record.writeChar('P');
        this.record.writeByte(operation);
        this.record.writePropertyId(state.getPropertyId());
    }

    private void writeEventRecord(EventState event) throws JournalException {
        this.record.writeChar('E');
        this.record.writeByte(event.getType());
        this.record.writeNodeId(event.getParentId());
        this.record.writePath(event.getParentPath());
        this.record.writeNodeId(event.getChildId());
        this.record.writePathElement(event.getChildRelPath());
        this.record.writeQName(event.getNodeType());
        Set mixins = event.getMixinNames();
        this.record.writeInt(mixins.size());
        Iterator iter = mixins.iterator();
        while (iter.hasNext()) {
            this.record.writeQName((Name)iter.next());
        }
        this.record.writeString(event.getUserId());
    }

    public void process(ClusterRecordProcessor processor) {
        processor.process(this);
    }

    public ChangeLog getChanges() {
        return this.changes;
    }

    public List getEvents() {
        return Collections.unmodifiableList(this.events);
    }
}

