/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.collections.ArrayListUtil;

public class PreferredMulticastFlowControl
implements FlowControl {
    private static final String RECEIVER_TIMEOUT_PROP_NAME = "aeron.PreferredMulticastFlowControl.receiverTimeout";
    private static final long RECEIVER_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toNanos(2L);
    private static final long RECEIVER_TIMEOUT = Long.getLong("aeron.PreferredMulticastFlowControl.receiverTimeout", RECEIVER_TIMEOUT_DEFAULT);
    private static final String PREFERRED_ASF_PROP_NAME = "aeron.PreferredMulticastFlowControl.asf";
    private static final String PREFERRED_ASF_DEFAULT = "FFFFFFFF";
    public static final String PREFERRED_ASF = System.getProperty("aeron.PreferredMulticastFlowControl.asf", "FFFFFFFF");
    public static final byte[] PREFERRED_ASF_BYTES = BitUtil.fromHex((String)PREFERRED_ASF);
    private final ArrayList<Receiver> receiverList = new ArrayList();
    private final byte[] smAsf = new byte[64];

    @Override
    public long onStatusMessage(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long senderLimit, int initialTermId, int positionBitsToShift, long now) {
        long position = LogBufferDescriptor.computePosition((int)flyweight.consumptionTermId(), (int)flyweight.consumptionTermOffset(), (int)positionBitsToShift, (int)initialTermId);
        long windowLength = flyweight.receiverWindowLength();
        long receiverId = flyweight.receiverId();
        boolean isFromPreferred = this.isFromPreferred(flyweight);
        boolean isExisting = false;
        long minPosition = Long.MAX_VALUE;
        ArrayList<Receiver> receiverList = this.receiverList;
        int size = receiverList.size();
        for (int i = 0; i < size; ++i) {
            Receiver receiver = receiverList.get(i);
            if (isFromPreferred && receiverId == receiver.receiverId) {
                receiver.lastPositionPlusWindow = position + windowLength;
                receiver.timeOfLastStatusMessage = now;
                isExisting = true;
            }
            minPosition = Math.min(minPosition, receiver.lastPositionPlusWindow);
        }
        if (isFromPreferred && !isExisting) {
            receiverList.add(new Receiver(position + windowLength, now, receiverId, receiverAddress));
            minPosition = Math.min(minPosition, position + windowLength);
        }
        return receiverList.size() > 0 ? Math.max(senderLimit, minPosition) : Math.max(senderLimit, position + windowLength);
    }

    @Override
    public void initialize(int initialTermId, int termBufferCapacity) {
    }

    @Override
    public long onIdle(long now, long senderLimit) {
        int lastIndex;
        long minPosition = Long.MAX_VALUE;
        ArrayList<Receiver> receiverList = this.receiverList;
        for (int i = lastIndex = receiverList.size() - 1; i >= 0; --i) {
            Receiver receiver = receiverList.get(i);
            if (now > receiver.timeOfLastStatusMessage + RECEIVER_TIMEOUT) {
                ArrayListUtil.fastUnorderedRemove(receiverList, (int)i, (int)lastIndex);
                --lastIndex;
                continue;
            }
            minPosition = Math.min(minPosition, receiver.lastPositionPlusWindow);
        }
        return receiverList.size() > 0 ? minPosition : senderLimit;
    }

    public boolean isFromPreferred(StatusMessageFlyweight sm) {
        int asfLength = sm.applicationSpecificFeedback(this.smAsf);
        boolean result = false;
        if (asfLength > 0 && asfLength >= 4 && this.smAsf[0] == PREFERRED_ASF_BYTES[0] && this.smAsf[1] == PREFERRED_ASF_BYTES[1] && this.smAsf[2] == PREFERRED_ASF_BYTES[2] && this.smAsf[3] == PREFERRED_ASF_BYTES[3]) {
            result = true;
        }
        return result;
    }

    static class Receiver {
        long lastPositionPlusWindow;
        long timeOfLastStatusMessage;
        long receiverId;
        InetSocketAddress address;

        Receiver(long lastPositionPlusWindow, long now, long receiverId, InetSocketAddress receiverAddress) {
            this.lastPositionPlusWindow = lastPositionPlusWindow;
            this.timeOfLastStatusMessage = now;
            this.receiverId = receiverId;
            this.address = receiverAddress;
        }
    }
}

