/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class ImageControlledFragmentAssembler
implements ControlledFragmentHandler {
    private final ControlledFragmentHandler delegate;
    private final BufferBuilder builder;

    public ImageControlledFragmentAssembler(ControlledFragmentHandler delegate) {
        this(delegate, 4096);
    }

    public ImageControlledFragmentAssembler(ControlledFragmentHandler delegate, int initialBufferLength) {
        this.delegate = delegate;
        this.builder = new BufferBuilder(initialBufferLength);
    }

    public ControlledFragmentHandler delegate() {
        return this.delegate;
    }

    BufferBuilder bufferBuilder() {
        return this.builder;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        byte flags = header.flags();
        ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
        if ((flags & 0xFFFFFFC0) == -64) {
            action = this.delegate.onFragment(buffer, offset, length, header);
        } else if ((flags & 0xFFFFFF80) == -128) {
            this.builder.reset().append(buffer, offset, length);
        } else {
            int limit = this.builder.limit();
            this.builder.append(buffer, offset, length);
            if ((flags & 0x40) == 64) {
                int msgLength = this.builder.limit();
                action = this.delegate.onFragment((DirectBuffer)this.builder.buffer(), 0, msgLength, header);
                if (ControlledFragmentHandler.Action.ABORT == action) {
                    this.builder.limit(limit);
                } else {
                    this.builder.reset();
                }
            }
        }
        return action;
    }
}

