/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ActivePublications;
import io.aeron.ActiveSubscriptions;
import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.DriverListener;
import io.aeron.DriverListenerAdapter;
import io.aeron.DriverProxy;
import io.aeron.ErrorCode;
import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.LogBuffersFactory;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import io.aeron.exceptions.RegistrationException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.agrona.ErrorHandler;
import org.agrona.ManagedResource;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;

class ClientConductor
implements Agent,
DriverListener {
    private static final long NO_CORRELATION_ID = -1L;
    private static final long RESOURCE_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(1L);
    private static final long RESOURCE_LINGER_NS = TimeUnit.SECONDS.toNanos(3L);
    private final long keepAliveIntervalNs;
    private final long driverTimeoutMs;
    private final long driverTimeoutNs;
    private final long interServiceTimeoutNs;
    private final long publicationConnectionTimeoutMs;
    private long timeOfLastKeepaliveNs;
    private long timeOfLastCheckResourcesNs;
    private long timeOfLastWorkNs;
    private boolean isDriverActive = true;
    private volatile Status status = Status.ACTIVE;
    private final Lock lock = new ReentrantLock();
    private final Aeron.Context ctx;
    private final EpochClock epochClock;
    private final FileChannel.MapMode imageMapMode;
    private final NanoClock nanoClock;
    private final DriverListenerAdapter driverListener;
    private final LogBuffersFactory logBuffersFactory;
    private final ActivePublications activePublications = new ActivePublications();
    private final Long2ObjectHashMap<ExclusivePublication> activeExclusivePublications = new Long2ObjectHashMap();
    private final ActiveSubscriptions activeSubscriptions = new ActiveSubscriptions();
    private final ArrayList<ManagedResource> lingeringResources = new ArrayList();
    private final UnsafeBuffer counterValuesBuffer;
    private final DriverProxy driverProxy;
    private final ErrorHandler errorHandler;
    private RegistrationException driverException;

    ClientConductor(Aeron.Context ctx) {
        long nowNs;
        this.ctx = ctx;
        this.epochClock = ctx.epochClock();
        this.nanoClock = ctx.nanoClock();
        this.errorHandler = ctx.errorHandler();
        this.counterValuesBuffer = ctx.countersValuesBuffer();
        this.driverProxy = ctx.driverProxy();
        this.logBuffersFactory = ctx.logBuffersFactory();
        this.imageMapMode = ctx.imageMapMode();
        this.keepAliveIntervalNs = ctx.keepAliveInterval();
        this.driverTimeoutMs = ctx.driverTimeoutMs();
        this.driverTimeoutNs = TimeUnit.MILLISECONDS.toNanos(this.driverTimeoutMs);
        this.interServiceTimeoutNs = ctx.interServiceTimeout();
        this.publicationConnectionTimeoutMs = ctx.publicationConnectionTimeout();
        this.driverListener = new DriverListenerAdapter(ctx.toClientBuffer(), this);
        this.timeOfLastKeepaliveNs = nowNs = this.nanoClock.nanoTime();
        this.timeOfLastCheckResourcesNs = nowNs;
        this.timeOfLastWorkNs = nowNs;
    }

    public void onClose() {
        if (Status.ACTIVE == this.status) {
            this.status = Status.CLOSING;
            for (ExclusivePublication publication : this.activeExclusivePublications.values()) {
                publication.forceClose();
            }
            this.activeExclusivePublications.clear();
            this.activePublications.close();
            this.activeSubscriptions.close();
            Aeron.sleep(1L);
            int size = this.lingeringResources.size();
            for (int i = 0; i < size; ++i) {
                this.lingeringResources.get(i).delete();
            }
            this.lingeringResources.clear();
            this.ctx.close();
            this.status = Status.CLOSED;
        }
    }

    public int doWork() {
        int workCount = 0;
        if (this.lock.tryLock()) {
            try {
                if (Status.ACTIVE == this.status) {
                    workCount = this.doWork(-1L, null);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return workCount;
    }

    public String roleName() {
        return "aeron-client-conductor";
    }

    Status status() {
        return this.status;
    }

    Lock clientLock() {
        return this.lock;
    }

    void handleError(Throwable ex) {
        this.errorHandler.onError(ex);
    }

    Publication addPublication(String channel, int streamId) {
        this.verifyActive();
        Publication publication = this.activePublications.get(channel, streamId);
        if (null == publication) {
            this.awaitResponse(this.driverProxy.addPublication(channel, streamId), channel);
            publication = this.activePublications.get(channel, streamId);
        }
        publication.incRef();
        return publication;
    }

    ExclusivePublication addExclusivePublication(String channel, int streamId) {
        this.verifyActive();
        long registrationId = this.driverProxy.addExclusivePublication(channel, streamId);
        this.awaitResponse(registrationId, channel);
        return (ExclusivePublication)this.activeExclusivePublications.get(registrationId);
    }

    void releasePublication(Publication publication) {
        this.verifyActive();
        if (publication == this.activePublications.remove(publication.channel(), publication.streamId())) {
            this.lingerResource(publication.managedResource());
            this.awaitResponse(this.driverProxy.removePublication(publication.registrationId()), null);
        }
    }

    void releasePublication(ExclusivePublication publication) {
        this.verifyActive();
        if (publication == this.activeExclusivePublications.remove(publication.registrationId())) {
            this.lingerResource(publication.managedResource());
            this.awaitResponse(this.driverProxy.removePublication(publication.registrationId()), null);
        }
    }

    void asyncReleasePublication(long registrationId) {
        this.driverProxy.removePublication(registrationId);
    }

    Subscription addSubscription(String channel, int streamId) {
        this.verifyActive();
        long correlationId = this.driverProxy.addSubscription(channel, streamId);
        Subscription subscription = new Subscription(this, channel, streamId, correlationId, this.ctx.availableImageHandler(), this.ctx.unavailableImageHandler());
        this.activeSubscriptions.add(subscription);
        this.awaitResponse(correlationId, channel);
        return subscription;
    }

    Subscription addSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        this.verifyActive();
        long correlationId = this.driverProxy.addSubscription(channel, streamId);
        Subscription subscription = new Subscription(this, channel, streamId, correlationId, availableImageHandler, unavailableImageHandler);
        this.activeSubscriptions.add(subscription);
        this.awaitResponse(correlationId, channel);
        return subscription;
    }

    void releaseSubscription(Subscription subscription) {
        this.verifyActive();
        this.awaitResponse(this.driverProxy.removeSubscription(subscription.registrationId()), null);
        this.activeSubscriptions.remove(subscription);
    }

    void asyncReleaseSubscription(Subscription subscription) {
        this.driverProxy.removeSubscription(subscription.registrationId());
    }

    void addDestination(long registrationId, String endpointChannel) {
        this.verifyActive();
        this.awaitResponse(this.driverProxy.addDestination(registrationId, endpointChannel), null);
    }

    void removeDestination(long registrationId, String endpointChannel) {
        this.verifyActive();
        this.awaitResponse(this.driverProxy.removeDestination(registrationId, endpointChannel), null);
    }

    @Override
    public void onError(ErrorCode errorCode, String message, long correlationId) {
        this.driverException = new RegistrationException(errorCode, message);
    }

    @Override
    public void onNewPublication(String channel, int streamId, int sessionId, int publicationLimitId, String logFileName, long correlationId) {
        Publication publication = new Publication(this, channel, streamId, sessionId, (ReadablePosition)new UnsafeBufferPosition(this.counterValuesBuffer, publicationLimitId), this.logBuffersFactory.map(logFileName, FileChannel.MapMode.READ_WRITE), correlationId);
        this.activePublications.put(channel, streamId, publication);
    }

    @Override
    public void onNewExclusivePublication(String channel, int streamId, int sessionId, int publicationLimitId, String logFileName, long correlationId) {
        ExclusivePublication publication = new ExclusivePublication(this, channel, streamId, sessionId, (ReadablePosition)new UnsafeBufferPosition(this.counterValuesBuffer, publicationLimitId), this.logBuffersFactory.map(logFileName, FileChannel.MapMode.READ_WRITE), correlationId);
        this.activeExclusivePublications.put(correlationId, (Object)publication);
    }

    @Override
    public void onAvailableImage(int streamId, int sessionId, Long2LongHashMap subscriberPositionMap, String logFileName, String sourceIdentity, long correlationId) {
        this.activeSubscriptions.forEach(streamId, subscription -> {
            long positionId;
            if (!subscription.hasImage(correlationId) && -1L != (positionId = subscriberPositionMap.get(subscription.registrationId()))) {
                Image image = new Image((Subscription)subscription, sessionId, (Position)new UnsafeBufferPosition(this.counterValuesBuffer, (int)positionId), this.logBuffersFactory.map(logFileName, this.imageMapMode), this.errorHandler, sourceIdentity, correlationId);
                subscription.addImage(image);
                try {
                    AvailableImageHandler handler = subscription.availableImageHandler();
                    if (null != handler) {
                        handler.onAvailableImage(image);
                    }
                }
                catch (Throwable ex) {
                    this.errorHandler.onError(ex);
                }
            }
        });
    }

    @Override
    public void onUnavailableImage(int streamId, long correlationId) {
        this.activeSubscriptions.forEach(streamId, subscription -> {
            Image image = subscription.removeImage(correlationId);
            if (null != image) {
                try {
                    UnavailableImageHandler handler = subscription.unavailableImageHandler();
                    if (null != handler) {
                        handler.onUnavailableImage(image);
                    }
                }
                catch (Throwable ex) {
                    this.errorHandler.onError(ex);
                }
            }
        });
    }

    DriverListenerAdapter driverListenerAdapter() {
        return this.driverListener;
    }

    void lingerResource(ManagedResource managedResource) {
        managedResource.timeOfLastStateChange(this.nanoClock.nanoTime());
        this.lingeringResources.add(managedResource);
    }

    boolean isPublicationConnected(long timeOfLastStatusMessageMs) {
        return this.epochClock.time() <= timeOfLastStatusMessageMs + this.publicationConnectionTimeoutMs;
    }

    private int doWork(long correlationId, String expectedChannel) {
        int workCount;
        block2: {
            workCount = 0;
            try {
                workCount += this.onCheckTimeouts();
                workCount += this.driverListener.pollMessage(correlationId, expectedChannel);
            }
            catch (Throwable throwable) {
                this.errorHandler.onError(throwable);
                if (correlationId == -1L) break block2;
                throw throwable;
            }
        }
        return workCount;
    }

    private void awaitResponse(long correlationId, String expectedChannel) {
        this.driverException = null;
        long timeoutDeadlineNs = this.nanoClock.nanoTime() + this.driverTimeoutNs;
        do {
            LockSupport.parkNanos(1L);
            this.doWork(correlationId, expectedChannel);
            if (this.driverListener.lastReceivedCorrelationId() != correlationId) continue;
            if (null != this.driverException) {
                throw this.driverException;
            }
            return;
        } while (this.nanoClock.nanoTime() < timeoutDeadlineNs);
        throw new DriverTimeoutException("No response within driver timeout");
    }

    private void verifyActive() {
        if (!this.isDriverActive) {
            throw new DriverTimeoutException("MediaDriver is inactive");
        }
        if (Status.CLOSED == this.status) {
            throw new IllegalStateException("Aeron client is closed");
        }
    }

    private int onCheckTimeouts() {
        long nowNs = this.nanoClock.nanoTime();
        int result = 0;
        if (nowNs > this.timeOfLastWorkNs + this.interServiceTimeoutNs) {
            this.onClose();
            throw new ConductorServiceTimeoutException("Timeout between service calls over " + this.interServiceTimeoutNs + "ns");
        }
        this.timeOfLastWorkNs = nowNs;
        if (nowNs > this.timeOfLastKeepaliveNs + this.keepAliveIntervalNs) {
            this.driverProxy.sendClientKeepalive();
            this.checkDriverHeartbeat();
            this.timeOfLastKeepaliveNs = nowNs;
            ++result;
        }
        if (nowNs > this.timeOfLastCheckResourcesNs + RESOURCE_TIMEOUT_NS) {
            int lastIndex;
            ArrayList<ManagedResource> lingeringResources = this.lingeringResources;
            for (int i = lastIndex = lingeringResources.size() - 1; i >= 0; --i) {
                ManagedResource resource = lingeringResources.get(i);
                if (nowNs <= resource.timeOfLastStateChange() + RESOURCE_LINGER_NS) continue;
                ArrayListUtil.fastUnorderedRemove(lingeringResources, (int)i, (int)lastIndex);
                --lastIndex;
                resource.delete();
            }
            this.timeOfLastCheckResourcesNs = nowNs;
            ++result;
        }
        return result;
    }

    private void checkDriverHeartbeat() {
        long lastDriverKeepalive = this.driverProxy.timeOfLastDriverKeepalive();
        long timeoutDeadlineMs = lastDriverKeepalive + this.driverTimeoutMs;
        if (this.isDriverActive && this.epochClock.time() > timeoutDeadlineMs) {
            this.isDriverActive = false;
            String msg = "MediaDriver has been inactive for over " + this.driverTimeoutMs + "ms";
            this.errorHandler.onError((Throwable)new DriverTimeoutException(msg));
        }
    }

    static enum Status {
        ACTIVE,
        CLOSING,
        CLOSED;

    }
}

