/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import java.nio.ByteOrder;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;

public class HeaderWriter {
    private final long versionFlagsType;
    private final long sessionId;
    private final long streamId;

    public HeaderWriter(UnsafeBuffer defaultHeader) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.versionFlagsType = (long)defaultHeader.getInt(4) << 32;
            this.sessionId = (long)defaultHeader.getInt(12) << 32;
            this.streamId = (long)defaultHeader.getInt(16) & 0xFFFFFFFFL;
        } else {
            this.versionFlagsType = (long)defaultHeader.getInt(4) & 0xFFFFFFFFL;
            this.sessionId = (long)defaultHeader.getInt(12) & 0xFFFFFFFFL;
            this.streamId = (long)defaultHeader.getInt(16) << 32;
        }
    }

    public void write(UnsafeBuffer termBuffer, int offset, int length, int termId) {
        long streamAndTermIds;
        long termOffsetSessionId;
        long lengthVersionFlagsType;
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            lengthVersionFlagsType = this.versionFlagsType | (long)(-length) & 0xFFFFFFFFL;
            termOffsetSessionId = this.sessionId | (long)offset;
            streamAndTermIds = this.streamId | (long)termId << 32;
        } else {
            lengthVersionFlagsType = this.versionFlagsType | (long)Integer.reverseBytes(-length) << 32;
            termOffsetSessionId = this.sessionId | (long)Integer.reverseBytes(offset) << 32;
            streamAndTermIds = this.streamId | (long)Integer.reverseBytes(termId) & 0xFFFFFFFFL;
        }
        termBuffer.putLong(offset + 0, lengthVersionFlagsType);
        UnsafeAccess.UNSAFE.storeFence();
        termBuffer.putLong(offset + 8, termOffsetSessionId);
        termBuffer.putLong(offset + 16, streamAndTermIds);
    }
}

