/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.Body;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.annotations.Query;
import org.jboss.resteasy.annotations.Suspend;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ConstructorParameter;
import org.jboss.resteasy.spi.metadata.FieldParameter;
import org.jboss.resteasy.spi.metadata.MethodParameter;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceConstructor;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.metadata.ResourceMethod;
import org.jboss.resteasy.spi.metadata.SetterParameter;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.IsHttpMethod;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.MethodHashing;
import org.jboss.resteasy.util.PickConstructor;
import org.jboss.resteasy.util.Types;

public class ResourceBuilder {
    private static final String WELD_PROXY_INTERFACE_NAME = "org.jboss.weld.bean.proxy.ProxyObject";

    public static ResourceClassBuilder rootResource(Class<?> root) {
        return new ResourceClassBuilder(root, "/");
    }

    public static ResourceClassBuilder rootResource(Class<?> root, String path) {
        return new ResourceClassBuilder(root, path);
    }

    public static ResourceClassBuilder locator(Class<?> root) {
        return new ResourceClassBuilder(root, null);
    }

    public static ResourceConstructor constructor(Class<?> annotatedResourceClass) {
        Constructor constructor = PickConstructor.pickPerRequestConstructor(annotatedResourceClass);
        if (constructor == null) {
            throw new RuntimeException(Messages.MESSAGES.couldNotFindConstructor(annotatedResourceClass.getName()));
        }
        ResourceConstructorBuilder builder = ResourceBuilder.rootResource(annotatedResourceClass).constructor(constructor);
        if (constructor.getParameterTypes() != null) {
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                builder.param(i).fromAnnotations();
            }
        }
        return builder.buildConstructor().buildClass().getConstructor();
    }

    public static ResourceClass rootResourceFromAnnotations(Class<?> clazz) {
        return ResourceBuilder.fromAnnotations(false, clazz);
    }

    public static ResourceClass locatorFromAnnotations(Class<?> clazz) {
        return ResourceBuilder.fromAnnotations(true, clazz);
    }

    private static boolean isWeldProxy(Class<?> clazz) {
        for (Class<?> implementedInterface : clazz.getInterfaces()) {
            if (!implementedInterface.getName().equals(WELD_PROXY_INTERFACE_NAME)) continue;
            return true;
        }
        return false;
    }

    private static ResourceClass fromAnnotations(boolean isLocator, Class<?> clazz) {
        Path path;
        if (!clazz.isInterface() && clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class) && ResourceBuilder.isWeldProxy(clazz)) {
            clazz = clazz.getSuperclass();
        }
        ResourceClassBuilder builder = null;
        builder = isLocator ? ResourceBuilder.locator(clazz) : ((path = clazz.getAnnotation(Path.class)) == null ? ResourceBuilder.rootResource(clazz, null) : ResourceBuilder.rootResource(clazz, path.value()));
        for (Method method : clazz.getMethods()) {
            if (method.isSynthetic() || method.getDeclaringClass().equals(Object.class)) continue;
            ResourceBuilder.processMethod(isLocator, builder, clazz, method);
        }
        if (!clazz.isInterface()) {
            ResourceBuilder.processFields(builder, clazz);
        }
        ResourceBuilder.processSetters(builder, clazz);
        return builder.buildClass();
    }

    private static Method findAnnotatedInterfaceMethod(Class<?> root, Class<?> iface, Method implementation) {
        for (Method method : iface.getMethods()) {
            Method actual;
            if (method.isSynthetic() || !method.getName().equals(implementation.getName()) || method.getParameterTypes().length != implementation.getParameterTypes().length || !(actual = Types.getImplementingMethod(root, method)).equals(implementation) || !method.isAnnotationPresent(Path.class) && IsHttpMethod.getHttpMethods(method) == null) continue;
            return method;
        }
        for (GenericDeclaration genericDeclaration : iface.getInterfaces()) {
            Method m = ResourceBuilder.findAnnotatedInterfaceMethod(root, genericDeclaration, implementation);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private static Method findAnnotatedMethod(Class<?> root, Method implementation) {
        Method method;
        Class<?> clazz;
        if (implementation.isAnnotationPresent(Path.class) || IsHttpMethod.getHttpMethods(implementation) != null) {
            return implementation;
        }
        if (implementation.isAnnotationPresent(Produces.class) || implementation.isAnnotationPresent(Consumes.class)) {
            return null;
        }
        for (clazz = implementation.getDeclaringClass().getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(implementation.getName(), implementation.getParameterTypes());
                if (method.isAnnotationPresent(Path.class) || IsHttpMethod.getHttpMethods(method) != null) {
                    return method;
                }
                if (!method.isAnnotationPresent(Produces.class) && !method.isAnnotationPresent(Consumes.class)) continue;
                return null;
            }
            catch (NoSuchMethodException method2) {
                // empty catch block
            }
        }
        for (clazz = root; clazz != null; clazz = clazz.getSuperclass()) {
            method = null;
            for (Class<?> iface : clazz.getInterfaces()) {
                Method m = ResourceBuilder.findAnnotatedInterfaceMethod(root, iface, implementation);
                if (m == null) continue;
                if (method != null && !m.equals(method)) {
                    throw new RuntimeException(Messages.MESSAGES.ambiguousInheritedAnnotations(implementation));
                }
                method = m;
            }
            if (method == null) continue;
            return method;
        }
        return null;
    }

    protected static void processFields(ResourceClassBuilder resourceClassBuilder, Class<?> root) {
        do {
            ResourceBuilder.processDeclaredFields(resourceClassBuilder, root);
        } while ((root = root.getSuperclass()) != null && !root.equals(Object.class));
    }

    protected static void processSetters(ResourceClassBuilder resourceClassBuilder, Class<?> root) {
        HashSet<Long> hashes = new HashSet<Long>();
        do {
            ResourceBuilder.processDeclaredSetters(resourceClassBuilder, root, hashes);
        } while ((root = root.getSuperclass()) != null && !root.equals(Object.class));
    }

    protected static void processDeclaredFields(ResourceClassBuilder resourceClassBuilder, Class<?> root) {
        for (Field field : root.getDeclaredFields()) {
            FieldParameterBuilder builder = (FieldParameterBuilder)resourceClassBuilder.field(field).fromAnnotations();
            if (builder.field.paramType == Parameter.ParamType.MESSAGE_BODY && !field.isAnnotationPresent(Body.class) || builder.field.paramType == Parameter.ParamType.UNKNOWN) continue;
            builder.buildField();
        }
    }

    protected static void processDeclaredSetters(ResourceClassBuilder resourceClassBuilder, Class<?> root, Set<Long> visitedHashes) {
        for (Method method : root.getDeclaredMethods()) {
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            long hash = 0L;
            try {
                hash = MethodHashing.methodHash(method);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!Modifier.isPrivate(method.getModifiers()) && visitedHashes.contains(hash)) continue;
            visitedHashes.add(hash);
            SetterParameterBuilder builder = (SetterParameterBuilder)resourceClassBuilder.setter(method).fromAnnotations();
            if (builder.setter.paramType == Parameter.ParamType.MESSAGE_BODY && !method.isAnnotationPresent(Body.class) || builder.setter.paramType == Parameter.ParamType.UNKNOWN) continue;
            builder.buildSetter();
        }
    }

    protected static void processMethod(boolean isLocator, ResourceClassBuilder resourceClassBuilder, Class<?> root, Method implementation) {
        Method method = ResourceBuilder.findAnnotatedMethod(root, implementation);
        if (method != null) {
            ResourceLocatorBuilder resourceLocatorBuilder;
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if (httpMethods == null) {
                resourceLocatorBuilder = resourceClassBuilder.locator(implementation, method);
            } else {
                Consumes consumes;
                ResourceMethodBuilder resourceMethodBuilder = resourceClassBuilder.method(implementation, method);
                resourceLocatorBuilder = resourceMethodBuilder;
                for (String httpMethod : httpMethods) {
                    if (httpMethod.equalsIgnoreCase("GET")) {
                        resourceMethodBuilder.get();
                        continue;
                    }
                    if (httpMethod.equalsIgnoreCase("PUT")) {
                        resourceMethodBuilder.put();
                        continue;
                    }
                    if (httpMethod.equalsIgnoreCase("POST")) {
                        resourceMethodBuilder.post();
                        continue;
                    }
                    if (httpMethod.equalsIgnoreCase("DELETE")) {
                        resourceMethodBuilder.delete();
                        continue;
                    }
                    if (httpMethod.equalsIgnoreCase("OPTIONS")) {
                        resourceMethodBuilder.options();
                        continue;
                    }
                    if (httpMethod.equalsIgnoreCase("HEAD")) {
                        resourceMethodBuilder.head();
                        continue;
                    }
                    resourceMethodBuilder.httpMethod(httpMethod);
                }
                Produces produces = method.getAnnotation(Produces.class);
                if (produces == null) {
                    produces = resourceClassBuilder.resourceClass.getClazz().getAnnotation(Produces.class);
                }
                if (produces == null) {
                    produces = method.getDeclaringClass().getAnnotation(Produces.class);
                }
                if (produces != null) {
                    resourceMethodBuilder.produces(produces.value());
                }
                if ((consumes = method.getAnnotation(Consumes.class)) == null) {
                    consumes = resourceClassBuilder.resourceClass.getClazz().getAnnotation(Consumes.class);
                }
                if (consumes == null) {
                    consumes = method.getDeclaringClass().getAnnotation(Consumes.class);
                }
                if (consumes != null) {
                    resourceMethodBuilder.consumes(consumes.value());
                }
            }
            Path methodPath = method.getAnnotation(Path.class);
            if (methodPath != null) {
                resourceLocatorBuilder.path(methodPath.value());
            }
            for (int i = 0; i < resourceLocatorBuilder.locator.params.length; ++i) {
                resourceLocatorBuilder.param(i).fromAnnotations();
            }
            resourceLocatorBuilder.buildMethod();
        }
    }

    public static class SetterParameterBuilder
    extends ParameterBuilder<SetterParameterBuilder> {
        SetterParameter setter;
        ResourceClassBuilder resourceClassBuilder;

        SetterParameterBuilder(ResourceClassBuilder resourceClassBuilder, SetterParameter parameter) {
            super(parameter);
            this.setter = parameter;
            this.resourceClassBuilder = resourceClassBuilder;
        }

        public ResourceClassBuilder buildSetter() {
            this.setter.setter.setAccessible(true);
            this.resourceClassBuilder.setters.add(this.setter);
            return this.resourceClassBuilder;
        }
    }

    public static class FieldParameterBuilder
    extends ParameterBuilder<FieldParameterBuilder> {
        FieldParameter field;
        ResourceClassBuilder resourceClassBuilder;

        FieldParameterBuilder(ResourceClassBuilder resourceClassBuilder, FieldParameter parameter) {
            super(parameter);
            this.field = parameter;
            this.resourceClassBuilder = resourceClassBuilder;
        }

        public ResourceClassBuilder buildField() {
            this.field.field.setAccessible(true);
            this.resourceClassBuilder.fields.add(this.field);
            return this.resourceClassBuilder;
        }
    }

    public static class ResourceMethodBuilder
    extends ResourceLocatorBuilder<ResourceMethodBuilder> {
        ResourceMethod method;

        ResourceMethodBuilder(ResourceClassBuilder resourceClassBuilder, Method method, Method annotatedMethod) {
            this.method = new ResourceMethod(resourceClassBuilder.resourceClass, method, annotatedMethod);
            this.locator = this.method;
            this.resourceClassBuilder = resourceClassBuilder;
        }

        public ResourceMethodBuilder httpMethod(String httpMethod) {
            this.method.httpMethods.add(httpMethod.toUpperCase());
            return this;
        }

        public ResourceMethodBuilder get() {
            this.method.httpMethods.add("GET");
            return this;
        }

        public ResourceMethodBuilder put() {
            this.method.httpMethods.add("PUT");
            return this;
        }

        public ResourceMethodBuilder post() {
            this.method.httpMethods.add("POST");
            return this;
        }

        public ResourceMethodBuilder delete() {
            this.method.httpMethods.add("DELETE");
            return this;
        }

        public ResourceMethodBuilder options() {
            this.method.httpMethods.add("OPTIONS");
            return this;
        }

        public ResourceMethodBuilder head() {
            this.method.httpMethods.add("HEAD");
            return this;
        }

        public ResourceMethodBuilder produces(MediaType ... produces) {
            this.method.produces = produces;
            return this;
        }

        public ResourceMethodBuilder produces(String ... produces) {
            MediaType[] types = this.parseMediaTypes(produces);
            this.method.produces = types;
            for (MediaType mt : types) {
                ResteasyDeployment deployment;
                if (mt.getParameters().containsKey("charset") || !MediaTypeHelper.isTextLike(mt) || (deployment = ResteasyProviderFactory.getContextData(ResteasyDeployment.class)) == null || deployment.isAddCharset()) continue;
                LogMessages.LOGGER.mediaTypeLacksCharset(mt, this.method.getMethod().getName());
            }
            return this;
        }

        protected MediaType[] parseMediaTypes(String[] produces) {
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            for (String produce : produces) {
                String[] split;
                for (String s : split = produce.split(",")) {
                    mediaTypes.add(MediaType.valueOf((String)s));
                }
            }
            MediaType[] types = new MediaType[mediaTypes.size()];
            types = mediaTypes.toArray(types);
            return types;
        }

        public ResourceMethodBuilder consumes(MediaType ... consumes) {
            this.method.consumes = consumes;
            return this;
        }

        public ResourceMethodBuilder consumes(String ... consumes) {
            MediaType[] types = this.parseMediaTypes(consumes);
            this.method.consumes = types;
            return this;
        }

        @Override
        public ResourceMethodParameterBuilder param(int i) {
            return new ResourceMethodParameterBuilder(this, this.locator.getParams()[i]);
        }

        @Override
        public ResourceClassBuilder buildMethod() {
            String pathExpression;
            ResteasyUriBuilder builder = new ResteasyUriBuilder();
            if (this.method.resourceClass.path != null) {
                builder.path(this.method.resourceClass.path);
            }
            if (this.method.path != null) {
                builder.path(this.method.path);
            }
            if ((pathExpression = builder.getPath()) == null) {
                pathExpression = "";
            }
            this.method.fullpath = pathExpression;
            if (this.method.resourceClass.getClazz().isAnonymousClass()) {
                this.method.getMethod().setAccessible(true);
            }
            this.resourceClassBuilder.resourceMethods.add(this.method);
            return this.resourceClassBuilder;
        }
    }

    public static class ResourceLocatorBuilder<T extends ResourceLocatorBuilder<T>> {
        ResourceLocator locator;
        ResourceClassBuilder resourceClassBuilder;

        ResourceLocatorBuilder() {
        }

        public ResourceLocatorBuilder(ResourceClassBuilder resourceClassBuilder, Method method, Method annotatedMethod) {
            this.resourceClassBuilder = resourceClassBuilder;
            this.locator = new ResourceLocator(resourceClassBuilder.resourceClass, method, annotatedMethod);
        }

        public T returnType(Class<?> type) {
            this.locator.returnType = type;
            return (T)this;
        }

        public T genericReturnType(Type type) {
            this.locator.genericReturnType = type;
            return (T)this;
        }

        public T returnType(GenericType type) {
            this.locator.returnType = type.getRawType();
            this.locator.genericReturnType = type.getType();
            return (T)this;
        }

        public LocatorMethodParameterBuilder param(int i) {
            return new LocatorMethodParameterBuilder(this, this.locator.getParams()[i]);
        }

        public ResourceClassBuilder buildMethod() {
            String pathExpression;
            ResteasyUriBuilder builder = new ResteasyUriBuilder();
            if (this.locator.resourceClass.path != null) {
                builder.path(this.locator.resourceClass.path);
            }
            if (this.locator.path != null) {
                builder.path(this.locator.path);
            }
            if ((pathExpression = builder.getPath()) == null) {
                pathExpression = "";
            }
            this.locator.fullpath = pathExpression;
            if (this.locator.resourceClass.getClazz().isAnonymousClass()) {
                this.locator.getMethod().setAccessible(true);
            }
            this.resourceClassBuilder.resourceLocators.add(this.locator);
            return this.resourceClassBuilder;
        }

        public T path(String path) {
            this.locator.path = path;
            return (T)this;
        }
    }

    public static class ResourceConstructorBuilder {
        ResourceConstructor constructor;
        ResourceClassBuilder resourceClassBuilder;

        public ResourceConstructorBuilder(ResourceClassBuilder resourceClassBuilder, Constructor constructor) {
            this.resourceClassBuilder = resourceClassBuilder;
            this.constructor = new ResourceConstructor(resourceClassBuilder.resourceClass, constructor);
        }

        public ConstructorParameterBuilder param(int i) {
            return new ConstructorParameterBuilder(this, this.constructor.getParams()[i]);
        }

        public ResourceClassBuilder buildConstructor() {
            this.resourceClassBuilder.resourceClass.constructor = this.constructor;
            return this.resourceClassBuilder;
        }
    }

    public static class ResourceMethodParameterBuilder
    extends LocatorMethodParameterBuilder<ResourceMethodParameterBuilder> {
        final ResourceMethodBuilder method;

        public ResourceMethodParameterBuilder(ResourceMethodBuilder method, MethodParameter param) {
            super(method, param);
            this.method = method;
        }

        public ResourceMethodParameterBuilder suspended() {
            this.method.method.asynchronous = true;
            this.parameter.paramType = Parameter.ParamType.SUSPENDED;
            return this;
        }

        public ResourceMethodParameterBuilder suspend(long timeout) {
            this.method.method.asynchronous = true;
            this.parameter.paramType = Parameter.ParamType.SUSPEND;
            this.parameter.suspendTimeout = timeout;
            return this;
        }

        @Override
        public ResourceMethodParameterBuilder fromAnnotations() {
            super.fromAnnotations();
            if (this.param.paramType == Parameter.ParamType.SUSPEND || this.param.paramType == Parameter.ParamType.SUSPENDED) {
                this.method.method.asynchronous = true;
            } else if (this.param.paramType == Parameter.ParamType.UNKNOWN) {
                this.param.paramType = Parameter.ParamType.MESSAGE_BODY;
            }
            return this;
        }
    }

    public static class LocatorMethodParameterBuilder<T extends LocatorMethodParameterBuilder<T>>
    extends ParameterBuilder<T> {
        final ResourceLocatorBuilder locator;
        final MethodParameter param;

        public LocatorMethodParameterBuilder(ResourceLocatorBuilder method, MethodParameter param) {
            super(param);
            this.locator = method;
            this.param = param;
        }

        public T param(int i) {
            return (T)this.locator.param(i);
        }

        public ResourceClassBuilder buildMethod() {
            return this.locator.buildMethod();
        }
    }

    public static class ConstructorParameterBuilder
    extends ParameterBuilder<ConstructorParameterBuilder> {
        final ResourceConstructorBuilder constructor;
        final ConstructorParameter param;

        public ConstructorParameterBuilder(ResourceConstructorBuilder builder, ConstructorParameter param) {
            super(param);
            this.constructor = builder;
            this.param = param;
        }

        public ConstructorParameterBuilder param(int i) {
            return this.constructor.param(i);
        }

        public ResourceClassBuilder buildConstructor() {
            return this.constructor.buildConstructor();
        }
    }

    public static class ParameterBuilder<T extends ParameterBuilder<T>> {
        final Parameter parameter;

        public ParameterBuilder(Parameter parameter) {
            this.parameter = parameter;
        }

        public T type(Class<?> type) {
            this.parameter.type = type;
            return (T)this;
        }

        public T genericType(Type type) {
            this.parameter.genericType = type;
            return (T)this;
        }

        public T type(GenericType type) {
            this.parameter.type = type.getRawType();
            this.parameter.genericType = type.getType();
            return (T)this;
        }

        public T beanParam() {
            this.parameter.paramType = Parameter.ParamType.BEAN_PARAM;
            return (T)this;
        }

        public T context() {
            this.parameter.paramType = Parameter.ParamType.CONTEXT;
            return (T)this;
        }

        public T messageBody() {
            this.parameter.paramType = Parameter.ParamType.MESSAGE_BODY;
            return (T)this;
        }

        public T encoded() {
            this.parameter.encoded = true;
            return (T)this;
        }

        public T defaultValue(String defaultValue) {
            this.parameter.defaultValue = defaultValue;
            return (T)this;
        }

        public T cookieParam(String name) {
            this.parameter.paramType = Parameter.ParamType.COOKIE_PARAM;
            this.parameter.paramName = name;
            return (T)this;
        }

        public T formParam(String name) {
            this.parameter.paramType = Parameter.ParamType.FORM_PARAM;
            this.parameter.paramName = name;
            return (T)this;
        }

        public T form(String prefix) {
            this.parameter.paramType = Parameter.ParamType.FORM;
            this.parameter.paramName = prefix;
            return (T)this;
        }

        public T form() {
            this.parameter.paramType = Parameter.ParamType.FORM;
            this.parameter.paramName = "";
            return (T)this;
        }

        public T headerParam(String name) {
            this.parameter.paramType = Parameter.ParamType.HEADER_PARAM;
            this.parameter.paramName = name;
            return (T)this;
        }

        public T matrixParam(String name) {
            this.parameter.paramType = Parameter.ParamType.MATRIX_PARAM;
            this.parameter.paramName = name;
            return (T)this;
        }

        public T pathParam(String name) {
            this.parameter.paramType = Parameter.ParamType.PATH_PARAM;
            this.parameter.paramName = name;
            return (T)this;
        }

        public T queryParam(String name) {
            this.parameter.paramType = Parameter.ParamType.QUERY_PARAM;
            this.parameter.paramName = name;
            return (T)this;
        }

        public T fromAnnotations() {
            QueryParam queryParam;
            Annotation[] annotations = this.parameter.getAnnotations();
            AccessibleObject injectTarget = this.parameter.getAccessibleObject();
            Class<?> type = this.parameter.getResourceClass().getClazz();
            this.parameter.encoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null || injectTarget.isAnnotationPresent(Encoded.class) || type.isAnnotationPresent(Encoded.class);
            DefaultValue defaultValue = FindAnnotation.findAnnotation(annotations, DefaultValue.class);
            if (defaultValue != null) {
                this.parameter.defaultValue = defaultValue.value();
            }
            if ((queryParam = FindAnnotation.findAnnotation(annotations, QueryParam.class)) != null) {
                this.parameter.paramType = Parameter.ParamType.QUERY_PARAM;
                this.parameter.paramName = queryParam.value();
            } else {
                Query query = FindAnnotation.findAnnotation(annotations, Query.class);
                if (query != null) {
                    this.parameter.paramType = Parameter.ParamType.QUERY;
                    this.parameter.paramName = "";
                } else {
                    HeaderParam header = FindAnnotation.findAnnotation(annotations, HeaderParam.class);
                    if (header != null) {
                        this.parameter.paramType = Parameter.ParamType.HEADER_PARAM;
                        this.parameter.paramName = header.value();
                    } else {
                        FormParam formParam = FindAnnotation.findAnnotation(annotations, FormParam.class);
                        if (formParam != null) {
                            this.parameter.paramType = Parameter.ParamType.FORM_PARAM;
                            this.parameter.paramName = formParam.value();
                        } else {
                            CookieParam cookie = FindAnnotation.findAnnotation(annotations, CookieParam.class);
                            if (cookie != null) {
                                this.parameter.paramType = Parameter.ParamType.COOKIE_PARAM;
                                this.parameter.paramName = cookie.value();
                            } else {
                                PathParam uriParam = FindAnnotation.findAnnotation(annotations, PathParam.class);
                                if (uriParam != null) {
                                    this.parameter.paramType = Parameter.ParamType.PATH_PARAM;
                                    this.parameter.paramName = uriParam.value();
                                } else {
                                    Form form = FindAnnotation.findAnnotation(annotations, Form.class);
                                    if (form != null) {
                                        this.parameter.paramType = Parameter.ParamType.FORM;
                                        this.parameter.paramName = form.prefix();
                                    } else if (FindAnnotation.findAnnotation(annotations, BeanParam.class) != null) {
                                        this.parameter.paramType = Parameter.ParamType.BEAN_PARAM;
                                    } else {
                                        MatrixParam matrix = FindAnnotation.findAnnotation(annotations, MatrixParam.class);
                                        if (matrix != null) {
                                            this.parameter.paramType = Parameter.ParamType.MATRIX_PARAM;
                                            this.parameter.paramName = matrix.value();
                                        } else {
                                            Suspend suspend = FindAnnotation.findAnnotation(annotations, Suspend.class);
                                            if (suspend != null) {
                                                this.parameter.paramType = Parameter.ParamType.SUSPEND;
                                                this.parameter.suspendTimeout = suspend.value();
                                            } else {
                                                Suspended suspended;
                                                this.parameter.paramType = FindAnnotation.findAnnotation(annotations, Context.class) != null ? Parameter.ParamType.CONTEXT : ((suspended = FindAnnotation.findAnnotation(annotations, Suspended.class)) != null ? Parameter.ParamType.SUSPENDED : (AsyncResponse.class.isAssignableFrom(type) ? Parameter.ParamType.SUSPENDED : (FindAnnotation.findAnnotation(annotations, Body.class) != null ? Parameter.ParamType.MESSAGE_BODY : Parameter.ParamType.UNKNOWN)));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return (T)this;
        }
    }

    public static class ResourceClassBuilder {
        final ResourceClass resourceClass;
        List<FieldParameter> fields = new ArrayList<FieldParameter>();
        List<SetterParameter> setters = new ArrayList<SetterParameter>();
        List<ResourceMethod> resourceMethods = new ArrayList<ResourceMethod>();
        List<ResourceLocator> resourceLocators = new ArrayList<ResourceLocator>();

        public ResourceClassBuilder(Class<?> root, String path) {
            this.resourceClass = new ResourceClass(root, path);
        }

        public ResourceMethodBuilder method(Method method) {
            return new ResourceMethodBuilder(this, method, method);
        }

        public ResourceMethodBuilder method(Method method, Method annotatedMethod) {
            return new ResourceMethodBuilder(this, method, annotatedMethod);
        }

        public ResourceLocatorBuilder locator(Method method) {
            return new ResourceLocatorBuilder(this, method, method);
        }

        public ResourceLocatorBuilder locator(Method method, Method annotatedMethod) {
            return new ResourceLocatorBuilder(this, method, annotatedMethod);
        }

        public FieldParameterBuilder field(Field field) {
            FieldParameter param = new FieldParameter(this.resourceClass, field);
            return new FieldParameterBuilder(this, param);
        }

        public SetterParameterBuilder setter(Method method) {
            SetterParameter param = new SetterParameter(this.resourceClass, method, method);
            return new SetterParameterBuilder(this, param);
        }

        public ResourceConstructorBuilder constructor(Constructor constructor) {
            return new ResourceConstructorBuilder(this, constructor);
        }

        public ResourceClass buildClass() {
            this.resourceClass.fields = this.fields.toArray(new FieldParameter[this.fields.size()]);
            this.resourceClass.setters = this.setters.toArray(new SetterParameter[this.setters.size()]);
            this.resourceClass.resourceMethods = this.resourceMethods.toArray(new ResourceMethod[this.resourceMethods.size()]);
            this.resourceClass.resourceLocators = this.resourceLocators.toArray(new ResourceLocator[this.resourceLocators.size()]);
            return this.resourceClass;
        }
    }
}

