/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.driver.AeronClient;
import io.aeron.driver.ClientListenerAdapter;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControl;
import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.FlowControl;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.IpcSubscriptionLink;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.NetworkPublicationThreadLocals;
import io.aeron.driver.NetworkSubscriptionLink;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.PublicationLink;
import io.aeron.driver.ReceiverProxy;
import io.aeron.driver.RetransmitHandler;
import io.aeron.driver.SenderProxy;
import io.aeron.driver.SpySubscriptionLink;
import io.aeron.driver.SubscriberPosition;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.buffer.RawLogFactory;
import io.aeron.driver.cmd.DriverConductorCmd;
import io.aeron.driver.exceptions.ControlProtocolException;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.PublisherLimit;
import io.aeron.driver.status.ReceiveChannelStatus;
import io.aeron.driver.status.ReceiverHwm;
import io.aeron.driver.status.ReceiverPos;
import io.aeron.driver.status.SendChannelStatus;
import io.aeron.driver.status.SenderLimit;
import io.aeron.driver.status.SenderPos;
import io.aeron.driver.status.SubscriberPos;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.uri.AeronUri;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;

public class DriverConductor
implements Agent {
    private final long imageLivenessTimeoutNs;
    private final long clientLivenessTimeoutNs;
    private final long publicationUnblockTimeoutNs;
    private final long statusMessageTimeoutNs;
    private long timeOfLastToDriverPositionChange;
    private long lastConsumerCommandPosition;
    private long timeOfLastTimeoutCheck;
    private volatile long timeInMs;
    private int nextSessionId = BitUtil.generateRandomisedId();
    private final NetworkPublicationThreadLocals networkPublicationThreadLocals = new NetworkPublicationThreadLocals();
    private final MediaDriver.Context context;
    private final RawLogFactory rawLogFactory;
    private final ReceiverProxy receiverProxy;
    private final SenderProxy senderProxy;
    private final ClientProxy clientProxy;
    private final DriverConductorProxy fromReceiverConductorProxy;
    private final RingBuffer toDriverCommands;
    private final ClientListenerAdapter clientListenerAdapter;
    private final OneToOneConcurrentArrayQueue<DriverConductorCmd> fromReceiverDriverConductorCmdQueue;
    private final OneToOneConcurrentArrayQueue<DriverConductorCmd> fromSenderDriverConductorCmdQueue;
    private final HashMap<String, SendChannelEndpoint> sendChannelEndpointByChannelMap = new HashMap();
    private final HashMap<String, ReceiveChannelEndpoint> receiveChannelEndpointByChannelMap = new HashMap();
    private final ArrayList<PublicationLink> publicationLinks = new ArrayList();
    private final ArrayList<NetworkPublication> networkPublications = new ArrayList();
    private final ArrayList<SubscriptionLink> subscriptionLinks = new ArrayList();
    private final ArrayList<PublicationImage> publicationImages = new ArrayList();
    private final ArrayList<AeronClient> clients = new ArrayList();
    private final ArrayList<IpcPublication> ipcPublications = new ArrayList();
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final EpochClock cachedEpochClock = () -> this.timeInMs;
    private final Consumer<DriverConductorCmd> onDriverConductorCmdFunc = this::onDriverConductorCmd;
    private final CountersManager countersManager;
    private final AtomicCounter clientKeepAlives;

    public DriverConductor(MediaDriver.Context ctx) {
        long now;
        this.context = ctx;
        this.imageLivenessTimeoutNs = ctx.imageLivenessTimeoutNs();
        this.clientLivenessTimeoutNs = ctx.clientLivenessTimeoutNs();
        this.publicationUnblockTimeoutNs = ctx.publicationUnblockTimeoutNs();
        this.statusMessageTimeoutNs = ctx.statusMessageTimeout();
        this.fromReceiverDriverConductorCmdQueue = ctx.toConductorFromReceiverCommandQueue();
        this.fromSenderDriverConductorCmdQueue = ctx.toConductorFromSenderCommandQueue();
        this.receiverProxy = ctx.receiverProxy();
        this.senderProxy = ctx.senderProxy();
        this.rawLogFactory = ctx.rawLogBuffersFactory();
        this.epochClock = ctx.epochClock();
        this.nanoClock = ctx.nanoClock();
        this.toDriverCommands = ctx.toDriverCommands();
        this.clientProxy = ctx.clientProxy();
        this.fromReceiverConductorProxy = ctx.fromReceiverDriverConductorProxy();
        this.countersManager = this.context.countersManager();
        this.clientKeepAlives = this.context.systemCounters().get(SystemCounterDescriptor.CLIENT_KEEP_ALIVES);
        this.clientListenerAdapter = new ClientListenerAdapter(this.context.systemCounters().get(SystemCounterDescriptor.ERRORS), ctx.errorLog(), this.toDriverCommands, this.clientProxy, this);
        this.timeInMs = this.epochClock.time();
        this.toDriverCommands.consumerHeartbeatTime(this.timeInMs);
        this.timeOfLastTimeoutCheck = now = this.nanoClock.nanoTime();
        this.timeOfLastToDriverPositionChange = now;
        this.lastConsumerCommandPosition = this.toDriverCommands.consumerPosition();
    }

    public void onClose() {
        this.networkPublications.forEach(NetworkPublication::close);
        this.publicationImages.forEach(PublicationImage::close);
        this.ipcPublications.forEach(IpcPublication::close);
    }

    public String roleName() {
        return "driver-conductor";
    }

    public int doWork() throws Exception {
        int workCount = 0;
        workCount += this.clientListenerAdapter.receive();
        workCount += this.fromReceiverDriverConductorCmdQueue.drain(this.onDriverConductorCmdFunc);
        workCount += this.fromSenderDriverConductorCmdQueue.drain(this.onDriverConductorCmdFunc);
        long nowNs = this.nanoClock.nanoTime();
        workCount += this.processTimers(nowNs);
        ArrayList<PublicationImage> publicationImages = this.publicationImages;
        int size = publicationImages.size();
        for (int i = 0; i < size; ++i) {
            publicationImages.get(i).trackRebuild(nowNs, this.statusMessageTimeoutNs);
        }
        ArrayList<NetworkPublication> networkPublications = this.networkPublications;
        int size2 = networkPublications.size();
        for (int i = 0; i < size2; ++i) {
            workCount += networkPublications.get(i).updatePublishersLimit();
        }
        ArrayList<IpcPublication> ipcPublications = this.ipcPublications;
        int size3 = ipcPublications.size();
        for (int i = 0; i < size3; ++i) {
            workCount += ipcPublications.get(i).updatePublishersLimit();
        }
        return workCount;
    }

    public void onClosePublication(NetworkPublication publication) {
        publication.close();
    }

    public void onCreatePublicationImage(int sessionId, int streamId, int initialTermId, int activeTermId, int initialTermOffset, int termBufferLength, int senderMtuLength, InetSocketAddress controlAddress, InetSocketAddress sourceAddress, ReceiveChannelEndpoint channelEndpoint) {
        channelEndpoint.validateSenderMtuLength(senderMtuLength);
        channelEndpoint.validateWindowMaxLength(this.context.initialWindowLength());
        UdpChannel udpChannel = channelEndpoint.udpChannel();
        String channel = udpChannel.originalUriString();
        long registrationId = this.nextImageCorrelationId();
        long joiningPosition = LogBufferDescriptor.computePosition((int)activeTermId, (int)initialTermOffset, (int)Integer.numberOfTrailingZeros(termBufferLength), (int)initialTermId);
        List<SubscriberPosition> subscriberPositions = this.createSubscriberPositions(sessionId, streamId, channelEndpoint, joiningPosition);
        if (subscriberPositions.size() > 0) {
            RawLog rawLog = this.newPublicationImageLog(sessionId, streamId, initialTermId, termBufferLength, senderMtuLength, udpChannel, registrationId);
            CongestionControl congestionControl = this.context.congestionControlSupplier().newInstance(registrationId, udpChannel, streamId, sessionId, termBufferLength, senderMtuLength, this.nanoClock, this.context, this.countersManager);
            PublicationImage image = new PublicationImage(registrationId, this.imageLivenessTimeoutNs, channelEndpoint, controlAddress, sessionId, streamId, initialTermId, activeTermId, initialTermOffset, rawLog, udpChannel.isMulticast() ? Configuration.NAK_MULTICAST_DELAY_GENERATOR : Configuration.NAK_UNICAST_DELAY_GENERATOR, DriverConductor.positionArray(subscriberPositions), (Position)ReceiverHwm.allocate(this.countersManager, registrationId, sessionId, streamId, channel), (Position)ReceiverPos.allocate(this.countersManager, registrationId, sessionId, streamId, channel), this.nanoClock, this.context.epochClock(), this.context.systemCounters(), sourceAddress, congestionControl, this.context.lossReport(), subscriberPositions.get(0).subscription().isReliable());
            int size = subscriberPositions.size();
            for (int i = 0; i < size; ++i) {
                subscriberPositions.get(i).addLink(image);
            }
            this.publicationImages.add(image);
            this.receiverProxy.newPublicationImage(channelEndpoint, image);
            this.clientProxy.onAvailableImage(registrationId, streamId, sessionId, rawLog.fileName(), subscriberPositions, DriverConductor.generateSourceIdentity(sourceAddress));
        }
    }

    SendChannelEndpoint senderChannelEndpoint(UdpChannel channel) {
        return this.sendChannelEndpointByChannelMap.get(channel.canonicalForm());
    }

    ReceiveChannelEndpoint receiverChannelEndpoint(UdpChannel channel) {
        return this.receiveChannelEndpointByChannelMap.get(channel.canonicalForm());
    }

    IpcPublication getIpcSharedPublication(long streamId) {
        return DriverConductor.findIpcSharedPublication(this.ipcPublications, streamId);
    }

    IpcPublication getIpcPublication(long registrationId) {
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            if (publication.registrationId() != registrationId) continue;
            return publication;
        }
        return null;
    }

    void onAddNetworkPublication(String channel, int streamId, long registrationId, long clientId, boolean isExclusive) {
        UdpChannel udpChannel = UdpChannel.parse(channel);
        PublicationParams params = this.getPublicationParams(udpChannel.aeronUri(), isExclusive, false);
        SendChannelEndpoint channelEndpoint = this.getOrCreateSendChannelEndpoint(udpChannel);
        NetworkPublication publication = null;
        if (!isExclusive) {
            publication = DriverConductor.findPublication(this.networkPublications, streamId, channelEndpoint);
        }
        if (null == publication) {
            publication = this.newNetworkPublication(registrationId, streamId, channel, udpChannel, channelEndpoint, params, isExclusive);
        } else if (publication.mtuLength() != params.mtuLength) {
            throw new IllegalStateException("Existing publication has different MTU length: existing=" + publication.mtuLength() + " requested=" + params.mtuLength);
        }
        this.publicationLinks.add(new PublicationLink(registrationId, publication, this.getOrAddClient(clientId)));
        this.clientProxy.onPublicationReady(registrationId, streamId, publication.sessionId(), publication.rawLog().fileName(), publication.publisherLimitId(), isExclusive);
    }

    private NetworkPublication newNetworkPublication(long registrationId, int streamId, String channel, UdpChannel udpChannel, SendChannelEndpoint channelEndpoint, PublicationParams params, boolean isExclusive) {
        int sessionId = this.nextSessionId++;
        UnsafeBufferPosition senderPosition = SenderPos.allocate(this.countersManager, registrationId, sessionId, streamId, channel);
        UnsafeBufferPosition senderLimit = SenderLimit.allocate(this.countersManager, registrationId, sessionId, streamId, channel);
        int initialTermId = BitUtil.generateRandomisedId();
        if (params.isReplay) {
            initialTermId = params.initialTermId;
            int bits = Integer.numberOfTrailingZeros(params.termLength);
            long position = LogBufferDescriptor.computePosition((int)params.termId, (int)params.termOffset, (int)bits, (int)initialTermId);
            senderLimit.setOrdered(position);
            senderPosition.setOrdered(position);
        }
        RetransmitHandler retransmitHandler = new RetransmitHandler(this.nanoClock, this.context.systemCounters(), Configuration.RETRANSMIT_UNICAST_DELAY_GENERATOR, Configuration.RETRANSMIT_UNICAST_LINGER_GENERATOR);
        FlowControl flowControl = udpChannel.isMulticast() || udpChannel.hasExplicitControl() ? this.context.multicastFlowControlSupplier().newInstance(udpChannel, streamId, registrationId) : this.context.unicastFlowControlSupplier().newInstance(udpChannel, streamId, registrationId);
        NetworkPublication publication = new NetworkPublication(registrationId, channelEndpoint, this.nanoClock, this.cachedEpochClock, this.newNetworkPublicationLog(sessionId, streamId, initialTermId, udpChannel, registrationId, params.termLength), (Position)PublisherLimit.allocate(this.countersManager, registrationId, sessionId, streamId, channel), (Position)senderPosition, (Position)senderLimit, sessionId, streamId, initialTermId, params.mtuLength, this.context.systemCounters(), flowControl, retransmitHandler, this.networkPublicationThreadLocals, this.publicationUnblockTimeoutNs, isExclusive);
        if (params.isReplay) {
            int activeIndex = LogBufferDescriptor.indexByTerm((int)params.initialTermId, (int)params.termId);
            UnsafeBuffer logMetaDataBuffer = publication.rawLog().metaData();
            LogBufferDescriptor.rawTail((UnsafeBuffer)logMetaDataBuffer, (int)activeIndex, (long)LogBufferDescriptor.packTail((int)params.termId, (int)params.termOffset));
            LogBufferDescriptor.activePartitionIndex((UnsafeBuffer)logMetaDataBuffer, (int)activeIndex);
        }
        channelEndpoint.incRef();
        this.networkPublications.add(publication);
        this.senderProxy.newNetworkPublication(publication);
        this.linkSpies(this.subscriptionLinks, publication);
        return publication;
    }

    void cleanupPublication(NetworkPublication publication) {
        if (publication.hasSpies()) {
            this.clientProxy.onUnavailableImage(LogBufferDescriptor.correlationId((UnsafeBuffer)publication.rawLog().metaData()), publication.streamId(), publication.channelEndpoint().originalUriString());
            int size = this.subscriptionLinks.size();
            for (int i = 0; i < size; ++i) {
                this.subscriptionLinks.get(i).unlink(publication);
            }
        }
        this.senderProxy.removeNetworkPublication(publication);
        SendChannelEndpoint channelEndpoint = publication.channelEndpoint();
        if (channelEndpoint.shouldBeClosed()) {
            channelEndpoint.closeStatusIndicator();
            this.sendChannelEndpointByChannelMap.remove(channelEndpoint.udpChannel().canonicalForm());
            this.senderProxy.closeSendChannelEndpoint(channelEndpoint);
        }
    }

    void cleanupSubscriptionLink(SubscriptionLink subscription) {
        ReceiveChannelEndpoint channelEndpoint = subscription.channelEndpoint();
        if (null != channelEndpoint) {
            int streamId = subscription.streamId();
            if (0 == channelEndpoint.decRefToStream(subscription.streamId())) {
                this.receiverProxy.removeSubscription(channelEndpoint, streamId);
            }
            if (channelEndpoint.shouldBeClosed()) {
                channelEndpoint.closeStatusIndicator();
                this.receiveChannelEndpointByChannelMap.remove(channelEndpoint.udpChannel().canonicalForm());
                this.receiverProxy.closeReceiveChannelEndpoint(channelEndpoint);
            }
        }
    }

    void transitionToLinger(PublicationImage image) {
        this.clientProxy.onUnavailableImage(image.correlationId(), image.streamId(), image.channelUriString());
        this.receiverProxy.removeCoolDown(image.channelEndpoint(), image.sessionId(), image.streamId());
    }

    void transitionToLinger(IpcPublication publication) {
        this.clientProxy.onUnavailableImage(publication.registrationId(), publication.streamId(), "aeron:ipc");
    }

    void cleanupImage(PublicationImage image) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            this.subscriptionLinks.get(i).unlink(image);
        }
    }

    void cleanupIpcPublication(IpcPublication publication) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            this.subscriptionLinks.get(i).unlink(publication);
        }
    }

    private List<SubscriberPosition> createSubscriberPositions(int sessionId, int streamId, ReceiveChannelEndpoint channelEndpoint, long joiningPosition) {
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = this.subscriptionLinks.get(i);
            if (!subscription.matches(channelEndpoint, streamId)) continue;
            UnsafeBufferPosition position = SubscriberPos.allocate(this.countersManager, subscription.registrationId(), sessionId, streamId, subscription.uri(), joiningPosition);
            position.setOrdered(joiningPosition);
            subscriberPositions.add(new SubscriberPosition(subscription, (Position)position));
        }
        return subscriberPositions;
    }

    void onAddIpcPublication(String channel, int streamId, long registrationId, long clientId, boolean isExclusive) {
        IpcPublication ipcPublication = this.getOrAddIpcPublication(registrationId, streamId, channel, isExclusive);
        this.publicationLinks.add(new PublicationLink(registrationId, ipcPublication, this.getOrAddClient(clientId)));
        this.clientProxy.onPublicationReady(registrationId, streamId, ipcPublication.sessionId(), ipcPublication.rawLog().fileName(), ipcPublication.publisherLimitId(), isExclusive);
        this.linkIpcSubscriptions(ipcPublication);
    }

    void onRemovePublication(long registrationId, long correlationId) {
        PublicationLink publicationLink = null;
        ArrayList<PublicationLink> publicationLinks = this.publicationLinks;
        int size = publicationLinks.size();
        int lastIndex = size - 1;
        for (int i = 0; i < size; ++i) {
            PublicationLink publication = publicationLinks.get(i);
            if (registrationId != publication.registrationId()) continue;
            publicationLink = publication;
            ArrayListUtil.fastUnorderedRemove(publicationLinks, (int)i, (int)lastIndex);
            break;
        }
        if (null == publicationLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "Unknown publication: " + registrationId);
        }
        publicationLink.close();
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onAddDestination(long registrationId, String destinationChannel, long correlationId) {
        SendChannelEndpoint sendChannelEndpoint = null;
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (registrationId != publication.registrationId()) continue;
            sendChannelEndpoint = publication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "Unknown publication: " + registrationId);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        AeronUri aeronUri = AeronUri.parse(destinationChannel);
        InetSocketAddress dstAddress = UdpChannel.destinationAddress(aeronUri);
        this.senderProxy.addDestination(sendChannelEndpoint, dstAddress);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onRemoveDestination(long registrationId, String destinationChannel, long correlationId) {
        SendChannelEndpoint sendChannelEndpoint = null;
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (registrationId != publication.registrationId()) continue;
            sendChannelEndpoint = publication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "Unknown publication: " + registrationId);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        AeronUri aeronUri = AeronUri.parse(destinationChannel);
        InetSocketAddress dstAddress = UdpChannel.destinationAddress(aeronUri);
        this.senderProxy.removeDestination(sendChannelEndpoint, dstAddress);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onAddNetworkSubscription(String channel, int streamId, long registrationId, long clientId) {
        UdpChannel udpChannel = UdpChannel.parse(channel);
        String reliableParam = udpChannel.aeronUri().get("reliable", "true");
        boolean isReliable = !"false".equals(reliableParam);
        this.checkForClashingSubscription(isReliable, udpChannel, streamId);
        ReceiveChannelEndpoint channelEndpoint = this.getOrCreateReceiveChannelEndpoint(udpChannel);
        int refCount = channelEndpoint.incRefToStream(streamId);
        if (1 == refCount) {
            this.receiverProxy.addSubscription(channelEndpoint, streamId);
        }
        AeronClient client = this.getOrAddClient(clientId);
        NetworkSubscriptionLink subscription = new NetworkSubscriptionLink(registrationId, channelEndpoint, streamId, channel, client, this.context.clientLivenessTimeoutNs(), isReliable);
        this.subscriptionLinks.add(subscription);
        this.clientProxy.operationSucceeded(registrationId);
        this.linkMatchingImages(channelEndpoint, subscription);
    }

    void onAddIpcSubscription(String channel, int streamId, long registrationId, long clientId) {
        IpcSubscriptionLink subscription = new IpcSubscriptionLink(registrationId, streamId, channel, this.getOrAddClient(clientId), this.context.clientLivenessTimeoutNs());
        this.subscriptionLinks.add(subscription);
        this.clientProxy.operationSucceeded(registrationId);
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            if (publication.streamId() != streamId || IpcPublication.Status.ACTIVE != publication.status()) continue;
            this.linkIpcSubscription(subscription, publication);
        }
    }

    void onAddSpySubscription(String channel, int streamId, long registrationId, long clientId) {
        UdpChannel udpChannel = UdpChannel.parse(channel);
        AeronClient client = this.getOrAddClient(clientId);
        SpySubscriptionLink subscriptionLink = new SpySubscriptionLink(registrationId, udpChannel, streamId, client, this.context.clientLivenessTimeoutNs());
        this.subscriptionLinks.add(subscriptionLink);
        this.clientProxy.operationSucceeded(registrationId);
        SendChannelEndpoint channelEndpoint = this.sendChannelEndpointByChannelMap.get(udpChannel.canonicalForm());
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (streamId != publication.streamId() || channelEndpoint != publication.channelEndpoint() || NetworkPublication.Status.ACTIVE != publication.status()) continue;
            this.linkSpy(publication, subscriptionLink);
        }
    }

    void onRemoveSubscription(long registrationId, long correlationId) {
        SubscriptionLink subscription = DriverConductor.removeSubscriptionLink(this.subscriptionLinks, registrationId);
        if (null == subscription) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "Unknown Subscription: " + registrationId);
        }
        subscription.close();
        ReceiveChannelEndpoint channelEndpoint = subscription.channelEndpoint();
        if (null != channelEndpoint) {
            int refCount = channelEndpoint.decRefToStream(subscription.streamId());
            if (0 == refCount) {
                this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId());
            }
            if (channelEndpoint.shouldBeClosed()) {
                channelEndpoint.closeStatusIndicator();
                this.receiveChannelEndpointByChannelMap.remove(channelEndpoint.udpChannel().canonicalForm());
                this.receiverProxy.closeReceiveChannelEndpoint(channelEndpoint);
            }
        }
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onClientKeepalive(long clientId) {
        this.clientKeepAlives.addOrdered(1L);
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null != client) {
            client.timeOfLastKeepalive(this.nanoClock.nanoTime());
        }
    }

    private void onHeartbeatCheckTimeouts(long nowNs) {
        long nowMs;
        this.timeInMs = nowMs = this.epochClock.time();
        this.toDriverCommands.consumerHeartbeatTime(nowMs);
        this.onCheckManagedResources(this.clients, nowNs, nowMs);
        this.onCheckManagedResources(this.publicationLinks, nowNs, nowMs);
        this.onCheckManagedResources(this.networkPublications, nowNs, nowMs);
        this.onCheckManagedResources(this.subscriptionLinks, nowNs, nowMs);
        this.onCheckManagedResources(this.publicationImages, nowNs, nowMs);
        this.onCheckManagedResources(this.ipcPublications, nowNs, nowMs);
    }

    private void onCheckForBlockedToDriverCommands(long nanoTimeNow) {
        long consumerPosition = this.toDriverCommands.consumerPosition();
        if (consumerPosition == this.lastConsumerCommandPosition) {
            if (this.toDriverCommands.producerPosition() > consumerPosition && nanoTimeNow > this.timeOfLastToDriverPositionChange + this.clientLivenessTimeoutNs && this.toDriverCommands.unblock()) {
                this.context.systemCounters().get(SystemCounterDescriptor.UNBLOCKED_COMMANDS).orderedIncrement();
            }
        } else {
            this.timeOfLastToDriverPositionChange = nanoTimeNow;
            this.lastConsumerCommandPosition = consumerPosition;
        }
    }

    private static NetworkPublication findPublication(ArrayList<NetworkPublication> publications, int streamId, SendChannelEndpoint channelEndpoint) {
        int size = publications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = publications.get(i);
            if (streamId != publication.streamId() || channelEndpoint != publication.channelEndpoint() || NetworkPublication.Status.ACTIVE != publication.status() || publication.isExclusive()) continue;
            return publication;
        }
        return null;
    }

    private RawLog newNetworkPublicationLog(int sessionId, int streamId, int initialTermId, UdpChannel udpChannel, long registrationId, int termBufferLength) {
        RawLog rawLog = this.rawLogFactory.newNetworkPublication(udpChannel.canonicalForm(), sessionId, streamId, registrationId, termBufferLength);
        UnsafeBuffer logMetaData = rawLog.metaData();
        LogBufferDescriptor.storeDefaultFrameHeader((UnsafeBuffer)logMetaData, (DirectBuffer)DataHeaderFlyweight.createDefaultHeader((int)sessionId, (int)streamId, (int)initialTermId));
        LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)0, (int)initialTermId);
        LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaData, (int)initialTermId);
        LogBufferDescriptor.mtuLength((UnsafeBuffer)logMetaData, (int)this.context.mtuLength());
        LogBufferDescriptor.correlationId((UnsafeBuffer)logMetaData, (long)registrationId);
        LogBufferDescriptor.timeOfLastStatusMessage((UnsafeBuffer)logMetaData, (long)0L);
        return rawLog;
    }

    private RawLog newIpcPublicationLog(int termBufferLength, int sessionId, int streamId, int initialTermId, long registrationId) {
        RawLog rawLog = this.rawLogFactory.newIpcPublication(sessionId, streamId, registrationId, termBufferLength);
        UnsafeBuffer logMetaData = rawLog.metaData();
        LogBufferDescriptor.storeDefaultFrameHeader((UnsafeBuffer)logMetaData, (DirectBuffer)DataHeaderFlyweight.createDefaultHeader((int)sessionId, (int)streamId, (int)initialTermId));
        LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)0, (int)initialTermId);
        LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaData, (int)initialTermId);
        LogBufferDescriptor.mtuLength((UnsafeBuffer)logMetaData, (int)FrameDescriptor.computeExclusiveMaxMessageLength((int)termBufferLength));
        LogBufferDescriptor.correlationId((UnsafeBuffer)logMetaData, (long)registrationId);
        LogBufferDescriptor.timeOfLastStatusMessage((UnsafeBuffer)logMetaData, (long)0L);
        return rawLog;
    }

    private RawLog newPublicationImageLog(int sessionId, int streamId, int initialTermId, int termBufferLength, int senderMtuLength, UdpChannel udpChannel, long correlationId) {
        RawLog rawLog = this.rawLogFactory.newNetworkedImage(udpChannel.canonicalForm(), sessionId, streamId, correlationId, termBufferLength);
        UnsafeBuffer logMetaData = rawLog.metaData();
        LogBufferDescriptor.storeDefaultFrameHeader((UnsafeBuffer)logMetaData, (DirectBuffer)DataHeaderFlyweight.createDefaultHeader((int)sessionId, (int)streamId, (int)initialTermId));
        LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaData, (int)initialTermId);
        LogBufferDescriptor.mtuLength((UnsafeBuffer)logMetaData, (int)senderMtuLength);
        LogBufferDescriptor.correlationId((UnsafeBuffer)logMetaData, (long)correlationId);
        LogBufferDescriptor.timeOfLastStatusMessage((UnsafeBuffer)logMetaData, (long)0L);
        return rawLog;
    }

    private SendChannelEndpoint getOrCreateSendChannelEndpoint(UdpChannel udpChannel) {
        SendChannelEndpoint channelEndpoint = this.sendChannelEndpointByChannelMap.get(udpChannel.canonicalForm());
        if (null == channelEndpoint) {
            channelEndpoint = this.context.sendChannelEndpointSupplier().newInstance(udpChannel, SendChannelStatus.allocate(this.countersManager, udpChannel.originalUriString()), this.context);
            this.sendChannelEndpointByChannelMap.put(udpChannel.canonicalForm(), channelEndpoint);
            this.senderProxy.registerSendChannelEndpoint(channelEndpoint);
        }
        return channelEndpoint;
    }

    private void checkForClashingSubscription(boolean isReliable, UdpChannel udpChannel, int streamId) {
        ReceiveChannelEndpoint channelEndpoint = this.receiveChannelEndpointByChannelMap.get(udpChannel.canonicalForm());
        if (null != channelEndpoint) {
            ArrayList<SubscriptionLink> existingLinks = this.subscriptionLinks;
            int size = existingLinks.size();
            for (int i = 0; i < size; ++i) {
                SubscriptionLink subscription = existingLinks.get(i);
                if (!subscription.matches(channelEndpoint, streamId) || isReliable == subscription.isReliable()) continue;
                throw new IllegalStateException("Option conflicts with existing subscriptions: reliable=" + isReliable);
            }
        }
    }

    private void linkMatchingImages(ReceiveChannelEndpoint channelEndpoint, SubscriptionLink subscription) {
        long registrationId = subscription.registrationId();
        int streamId = subscription.streamId();
        String channel = subscription.uri();
        int size = this.publicationImages.size();
        for (int i = 0; i < size; ++i) {
            PublicationImage image = this.publicationImages.get(i);
            if (!image.matches(channelEndpoint, streamId) || !image.isAcceptingSubscriptions()) continue;
            long rebuildPosition = image.rebuildPosition();
            int sessionId = image.sessionId();
            UnsafeBufferPosition position = SubscriberPos.allocate(this.countersManager, registrationId, sessionId, streamId, channel, rebuildPosition);
            position.setOrdered(rebuildPosition);
            image.addSubscriber((ReadablePosition)position);
            subscription.link(image, (ReadablePosition)position);
            this.clientProxy.onAvailableImage(image.correlationId(), streamId, sessionId, image.rawLog().fileName(), Collections.singletonList(new SubscriberPosition(subscription, (Position)position)), DriverConductor.generateSourceIdentity(image.sourceAddress()));
        }
    }

    private void linkIpcSubscriptions(IpcPublication publication) {
        int streamId = publication.streamId();
        ArrayList<SubscriptionLink> subscriptionLinks = this.subscriptionLinks;
        int size = subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = subscriptionLinks.get(i);
            if (!subscription.matches(streamId) || subscription.isLinked(publication)) continue;
            this.linkIpcSubscription((IpcSubscriptionLink)subscription, publication);
        }
    }

    private static ReadablePosition[] positionArray(List<SubscriberPosition> subscriberPositions) {
        int size = subscriberPositions.size();
        ReadablePosition[] positions = new ReadablePosition[subscriberPositions.size()];
        for (int i = 0; i < size; ++i) {
            positions[i] = subscriberPositions.get(i).position();
        }
        return positions;
    }

    private void linkIpcSubscription(IpcSubscriptionLink subscription, IpcPublication publication) {
        long joiningPosition = publication.joiningPosition();
        long registrationId = subscription.registrationId();
        int sessionId = publication.sessionId();
        int streamId = subscription.streamId();
        String channel = subscription.uri();
        UnsafeBufferPosition position = SubscriberPos.allocate(this.countersManager, registrationId, sessionId, streamId, channel, joiningPosition);
        position.setOrdered(joiningPosition);
        subscription.link(publication, (ReadablePosition)position);
        publication.addSubscriber((ReadablePosition)position);
        this.clientProxy.onAvailableImage(publication.registrationId(), streamId, sessionId, publication.rawLog().fileName(), Collections.singletonList(new SubscriberPosition(subscription, (Position)position)), channel);
    }

    private void linkSpy(NetworkPublication publication, SubscriptionLink subscription) {
        long joiningPosition = publication.spyJoiningPosition();
        long registrationId = subscription.registrationId();
        int streamId = publication.streamId();
        int sessionId = publication.sessionId();
        String channel = subscription.uri();
        UnsafeBufferPosition position = SubscriberPos.allocate(this.countersManager, registrationId, sessionId, streamId, channel, joiningPosition);
        position.setOrdered(joiningPosition);
        publication.addSubscriber((ReadablePosition)position);
        subscription.link(publication, (ReadablePosition)position);
        this.clientProxy.onAvailableImage(LogBufferDescriptor.correlationId((UnsafeBuffer)publication.rawLog().metaData()), streamId, sessionId, publication.rawLog().fileName(), Collections.singletonList(new SubscriberPosition(subscription, (Position)position)), channel);
    }

    private ReceiveChannelEndpoint getOrCreateReceiveChannelEndpoint(UdpChannel udpChannel) {
        ReceiveChannelEndpoint channelEndpoint = this.receiveChannelEndpointByChannelMap.get(udpChannel.canonicalForm());
        if (null == channelEndpoint) {
            channelEndpoint = this.context.receiveChannelEndpointSupplier().newInstance(udpChannel, new DataPacketDispatcher(this.fromReceiverConductorProxy, this.receiverProxy.receiver()), ReceiveChannelStatus.allocate(this.countersManager, udpChannel.originalUriString()), this.context);
            this.receiveChannelEndpointByChannelMap.put(udpChannel.canonicalForm(), channelEndpoint);
            this.receiverProxy.registerReceiveChannelEndpoint(channelEndpoint);
        }
        return channelEndpoint;
    }

    private void onDriverConductorCmd(DriverConductorCmd cmd) {
        cmd.execute(this);
    }

    private AeronClient getOrAddClient(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null == client) {
            client = new AeronClient(clientId, this.clientLivenessTimeoutNs, this.nanoClock.nanoTime());
            this.clients.add(client);
        }
        return client;
    }

    private IpcPublication getOrAddIpcPublication(long registrationId, int streamId, String channel, boolean isExclusive) {
        IpcPublication publication = null;
        if (!isExclusive) {
            publication = DriverConductor.findIpcSharedPublication(this.ipcPublications, streamId);
        }
        if (null == publication) {
            publication = this.addIpcPublication(registrationId, streamId, channel, isExclusive);
        }
        return publication;
    }

    private IpcPublication addIpcPublication(long registrationId, int streamId, String channel, boolean isExclusive) {
        PublicationParams params = this.getPublicationParams(AeronUri.parse(channel), isExclusive, true);
        int sessionId = this.nextSessionId++;
        int initialTermId = params.isReplay ? params.initialTermId : BitUtil.generateRandomisedId();
        RawLog rawLog = this.newIpcPublicationLog(params.termLength, sessionId, streamId, initialTermId, registrationId);
        if (params.isReplay) {
            int activeIndex = LogBufferDescriptor.indexByTerm((int)initialTermId, (int)params.termId);
            LogBufferDescriptor.rawTail((UnsafeBuffer)rawLog.metaData(), (int)activeIndex, (long)LogBufferDescriptor.packTail((int)params.termId, (int)params.termOffset));
            LogBufferDescriptor.activePartitionIndex((UnsafeBuffer)rawLog.metaData(), (int)activeIndex);
        }
        IpcPublication publication = new IpcPublication(registrationId, sessionId, streamId, (Position)PublisherLimit.allocate(this.countersManager, registrationId, sessionId, streamId, channel), rawLog, this.publicationUnblockTimeoutNs, this.context.systemCounters(), isExclusive);
        this.ipcPublications.add(publication);
        return publication;
    }

    private long nextImageCorrelationId() {
        return this.toDriverCommands.nextCorrelationId();
    }

    private static AeronClient findClient(ArrayList<AeronClient> clients, long clientId) {
        AeronClient aeronClient = null;
        int size = clients.size();
        for (int i = 0; i < size; ++i) {
            AeronClient client = clients.get(i);
            if (client.clientId() != clientId) continue;
            aeronClient = client;
            break;
        }
        return aeronClient;
    }

    private static SubscriptionLink removeSubscriptionLink(ArrayList<SubscriptionLink> subscriptionLinks, long registrationId) {
        SubscriptionLink subscriptionLink = null;
        int size = subscriptionLinks.size();
        int lastIndex = size - 1;
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = subscriptionLinks.get(i);
            if (subscription.registrationId() != registrationId) continue;
            subscriptionLink = subscription;
            ArrayListUtil.fastUnorderedRemove(subscriptionLinks, (int)i, (int)lastIndex);
            break;
        }
        return subscriptionLink;
    }

    private static IpcPublication findIpcSharedPublication(ArrayList<IpcPublication> ipcPublications, long streamId) {
        IpcPublication ipcPublication = null;
        int size = ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = ipcPublications.get(i);
            if ((long)publication.streamId() != streamId || publication.isExclusive() || IpcPublication.Status.ACTIVE != publication.status()) continue;
            ipcPublication = publication;
            break;
        }
        return ipcPublication;
    }

    private <T extends DriverManagedResource> void onCheckManagedResources(ArrayList<T> list, long nowNs, long nowMs) {
        int lastIndex;
        for (int i = lastIndex = list.size() - 1; i >= 0; --i) {
            DriverManagedResource resource = (DriverManagedResource)list.get(i);
            resource.onTimeEvent(nowNs, nowMs, this);
            if (!resource.hasReachedEndOfLife()) continue;
            ArrayListUtil.fastUnorderedRemove(list, (int)i, (int)lastIndex);
            --lastIndex;
            resource.delete();
        }
    }

    private void linkSpies(ArrayList<SubscriptionLink> links, NetworkPublication publication) {
        int size = links.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = links.get(i);
            if (!subscription.matches(publication) || subscription.isLinked(publication)) continue;
            this.linkSpy(publication, subscription);
        }
    }

    private int processTimers(long nowNs) {
        int workCount = 0;
        if (nowNs > this.timeOfLastTimeoutCheck + Configuration.HEARTBEAT_TIMEOUT_NS) {
            this.onHeartbeatCheckTimeouts(nowNs);
            this.onCheckForBlockedToDriverCommands(nowNs);
            this.timeOfLastTimeoutCheck = nowNs;
            workCount = 1;
        }
        return workCount;
    }

    private static String generateSourceIdentity(InetSocketAddress address) {
        return address.getHostString() + ':' + address.getPort();
    }

    private static int getTermBufferLength(AeronUri aeronUri, int defaultTermLength) {
        String termLengthParam = aeronUri.get("term-length");
        int termLength = defaultTermLength;
        if (null != termLengthParam) {
            termLength = Integer.parseInt(termLengthParam);
            Configuration.validateTermBufferLength(termLength);
        }
        return termLength;
    }

    private static int getMtuLength(AeronUri aeronUri, int defaultMtuLength) {
        int mtuLength = defaultMtuLength;
        String mtu = aeronUri.get("mtu");
        if (null != mtu) {
            mtuLength = Integer.parseInt(mtu);
            Configuration.validateMtuLength(mtuLength);
        }
        return mtuLength;
    }

    private PublicationParams getPublicationParams(AeronUri aeronUri, boolean isExclusive, boolean isIpc) {
        PublicationParams params = new PublicationParams();
        params.mtuLength = DriverConductor.getMtuLength(aeronUri, this.context.mtuLength());
        params.termLength = DriverConductor.getTermBufferLength(aeronUri, isIpc ? this.context.ipcTermBufferLength() : this.context.publicationTermBufferLength());
        if (isExclusive) {
            int count = 0;
            String initTermIdStr = aeronUri.get("init-term-id");
            count = initTermIdStr != null ? count + 1 : count;
            String termIdStr = aeronUri.get("term-id");
            count = termIdStr != null ? count + 1 : count;
            String termOffsetStr = aeronUri.get("term-offset");
            int n = count = termOffsetStr != null ? count + 1 : count;
            if (count > 0) {
                if (count < 3) {
                    throw new IllegalStateException("Params must be used as a complete set: init-term-id term-id term-offset");
                }
                params.initialTermId = Integer.parseInt(initTermIdStr);
                params.termId = Integer.parseInt(termIdStr);
                params.termOffset = Integer.parseInt(termOffsetStr);
                if (params.termOffset > params.termLength) {
                    throw new IllegalStateException("term-offset=" + params.termOffset + " > " + "term-length" + "=" + params.termLength);
                }
                params.isReplay = true;
            }
        }
        return params;
    }

    static class PublicationParams {
        int mtuLength = 0;
        int termLength = 0;
        int initialTermId = 0;
        int termId = 0;
        int termOffset = 0;
        boolean isReplay = false;

        PublicationParams() {
        }
    }
}

