/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.importer.package$;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.SourceArtifactEnricher;
import com.xebialabs.xldeploy.packager.StreamFile;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import de.schlichtherle.truezip.file.TFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ThrowingRuntimeExceptionHandlerStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u0001\u0003\u00015\u00111#S7q_J$XM]*feZL7-Z%na2T!a\u0001\u0003\u0002\u0011%l\u0007o\u001c:uKJT!!\u0002\u0004\u0002\u000fM,'O^5dK*\u0011q\u0001C\u0001\tI\u0016\u0004Hn\\=ji*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0004\u000191\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!aD%na>\u0014H/\u001a:TKJ4\u0018nY3\t\u0011m\u0001!\u00111A\u0005\u0002q\t\u0011C]3q_NLGo\u001c:z'\u0016\u0014h/[2f+\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0007\u0003)\u0011X\r]8tSR|'/_\u0005\u0003E}\u0011\u0011CU3q_NLGo\u001c:z'\u0016\u0014h/[2f\u0011!!\u0003A!a\u0001\n\u0003)\u0013!\u0006:fa>\u001c\u0018\u000e^8ssN+'O^5dK~#S-\u001d\u000b\u0003M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012A!\u00168ji\"9QfIA\u0001\u0002\u0004i\u0012a\u0001=%c!Aq\u0006\u0001B\u0001B\u0003&Q$\u0001\nsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\u0003\u0002C\u0019\u0001\u0005\u0003\u0007I\u0011\u0001\u001a\u0002\u0017I|G.Z*feZL7-Z\u000b\u0002gA\u0011AgN\u0007\u0002k)\u0011aGB\u0001\tg\u0016\u001cWO]5us&\u0011\u0001(\u000e\u0002\f%>dWmU3sm&\u001cW\r\u0003\u0005;\u0001\t\u0005\r\u0011\"\u0001<\u0003=\u0011x\u000e\\3TKJ4\u0018nY3`I\u0015\fHC\u0001\u0014=\u0011\u001di\u0013(!AA\u0002MB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006KaM\u0001\re>dWmU3sm&\u001cW\r\t\u0005\t\u0001\u0002\u0011\t\u0019!C\u0001\u0003\u0006Ia/\u00197jI\u0006$xN]\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tB\u0001\u000bm\u0006d\u0017\u000eZ1uS>t\u0017BA$E\u0005%1\u0016\r\\5eCR|'\u000f\u0003\u0005J\u0001\t\u0005\r\u0011\"\u0001K\u000351\u0018\r\\5eCR|'o\u0018\u0013fcR\u0011ae\u0013\u0005\b[!\u000b\t\u00111\u0001C\u0011!i\u0005A!A!B\u0013\u0011\u0015A\u0003<bY&$\u0017\r^8sA!Aq\n\u0001BA\u0002\u0013\u0005\u0001+\u0001\u0005f]JL7\r[3s+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003!\u0001\u0018mY6bO\u0016\u0014(B\u0001,\t\u0003!AH\u000eZ3qY>L\u0018B\u0001-T\u0005Y\u0019v.\u001e:dK\u0006\u0013H/\u001b4bGR,eN]5dQ\u0016\u0014\b\u0002\u0003.\u0001\u0005\u0003\u0007I\u0011A.\u0002\u0019\u0015t'/[2iKJ|F%Z9\u0015\u0005\u0019b\u0006bB\u0017Z\u0003\u0003\u0005\r!\u0015\u0005\t=\u0002\u0011\t\u0011)Q\u0005#\u0006IQM\u001c:jG\",'\u000f\t\u0005\u0006A\u0002!\t!Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\t\u001cG-\u001a4\u0011\u0005]\u0001\u0001\"B\u000e`\u0001\u0004i\u0002\"B\u0019`\u0001\u0004\u0019\u0004\"\u0002!`\u0001\u0004\u0011\u0005\"B(`\u0001\u0004\t\u0006FA0i!\tIG/D\u0001k\u0015\tYG.\u0001\u0006b]:|G/\u0019;j_:T!!\u001c8\u0002\u000f\u0019\f7\r^8ss*\u0011q\u000e]\u0001\u0006E\u0016\fgn\u001d\u0006\u0003cJ\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002g\u0006\u0019qN]4\n\u0005UT'!C!vi><\u0018N]3e\u0011\u001d9\bA1A\u0005\na\f\u0011\"[7q_J$XM]:\u0016\u0003e\u00042A_?\u0000\u001b\u0005Y(B\u0001?\u0013\u0003\u0011)H/\u001b7\n\u0005y\\(\u0001\u0002'jgR\u0004B!!\u0001\u0002\u000e5\u0011\u00111\u0001\u0006\u0004\u0007\u0005\u0015!\u0002BA\u0004\u0003\u0013\t1!\u00199j\u0015\r\tYAB\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005=\u00111\u0001\u0002\t\u00136\u0004xN\u001d;fe\"9\u00111\u0003\u0001!\u0002\u0013I\u0018AC5na>\u0014H/\u001a:tA!I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011D\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005\"/A\u0003tY\u001a$$.\u0003\u0003\u0002&\u0005}!A\u0002'pO\u001e,'\u000f\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u000e\u0003\u001dawnZ4fe\u0002B\u0011\"!\f\u0001\u0005\u0004%I!a\f\u0002!%\u001c8i\u001c7mK\u000e$\u0018n\u001c8LS:$WCAA\u0019!\u001d9\u00131GA\u001c\u0003\u0013J1!!\u000e)\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002:\u0005\u0015SBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u000fI,g\r\\3di*!\u0011qAA!\u0015\r\t\u0019EB\u0001\u0007a2,x-\u001b8\n\t\u0005\u001d\u00131\b\u0002\r!J|\u0007/\u001a:us.Kg\u000e\u001a\t\u0004O\u0005-\u0013bAA'Q\t9!i\\8mK\u0006t\u0007\u0002CA)\u0001\u0001\u0006I!!\r\u0002#%\u001c8i\u001c7mK\u000e$\u0018n\u001c8LS:$\u0007\u0005C\u0006\u0002V\u0001\u0001\r\u00111A\u0005\n\u0005]\u0013AG5na>\u0014H/\u00192mKB\u000b7m[1hK\u0012K'/Z2u_JLXCAA-!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0%\u0005\u0011\u0011n\\\u0005\u0005\u0003G\niF\u0001\u0003GS2,\u0007bCA4\u0001\u0001\u0007\t\u0019!C\u0005\u0003S\na$[7q_J$\u0018M\u00197f!\u0006\u001c7.Y4f\t&\u0014Xm\u0019;pef|F%Z9\u0015\u0007\u0019\nY\u0007C\u0005.\u0003K\n\t\u00111\u0001\u0002Z!A\u0011q\u000e\u0001!B\u0013\tI&A\u000ej[B|'\u000f^1cY\u0016\u0004\u0016mY6bO\u0016$\u0015N]3di>\u0014\u0018\u0010\t\u0005\b\u0003g\u0002A\u0011AA;\u00035Ig.\u001b;J[B|'\u000f^3sgR\ta\u0005\u000b\u0003\u0002r\u0005e\u0004\u0003BA>\u0003\u0007k!!! \u000b\u0007-\fyH\u0003\u0002\u0002\u0002\u0006)!.\u0019<bq&!\u0011QQA?\u00055\u0001vn\u001d;D_:\u001cHO];di\"9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0015!H4fi&k\u0007o\u001c:uC\ndW\rU1dW\u0006<W\rR5sK\u000e$xN]=\u0015\u0005\u0005e\u0003bBAH\u0001\u0011\u0005\u0011\u0011S\u0001\u001eg\u0016$\u0018*\u001c9peR\f'\r\\3QC\u000e\\\u0017mZ3ESJ,7\r^8ssR\u0019a%a%\t\u0011\u0005U\u0013Q\u0012a\u0001\u00033Bq!a&\u0001\t\u0003\nI*\u0001\u0007mSN$\b+Y2lC\u001e,7\u000f\u0006\u0002\u0002\u001cB!!0`AO!\u0011\ty*!,\u000f\t\u0005\u0005\u0016\u0011\u0016\t\u0004\u0003GCSBAAS\u0015\r\t9\u000bD\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-\u0006&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\u000b\tL\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003WC\u0003bBA[\u0001\u0011\u0005\u0013qW\u0001\u000eS6\u0004xN\u001d;QC\u000e\\\u0017mZ3\u0015\t\u0005u\u0015\u0011\u0018\u0005\t\u0003w\u000b\u0019\f1\u0001\u0002>\u000611o\\;sG\u0016\u0004B!!\u0001\u0002@&!\u0011\u0011YA\u0002\u00051IU\u000e]8siN{WO]2f\u0011\u001d\t)\r\u0001C\t\u0003\u000f\fqb\u00195fG.\u0004VM]7jgNLwN\u001c\u000b\u0006M\u0005%\u0017q\u001b\u0005\t\u0003\u0017\f\u0019\r1\u0001\u0002N\u0006Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\u0011\t\u0005=\u00171[\u0007\u0003\u0003#T1!a36\u0013\u0011\t).!5\u0003\u0015A+'/\\5tg&|g\u000e\u0003\u0005\u0002Z\u0006\r\u0007\u0019AAO\u0003QygnQ8oM&<WO]1uS>t\u0017\n^3ng\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0017\u0001\u00033p\u00136\u0004xN\u001d;\u0015\r\u0005u\u0015\u0011]Ar\u0011!\tY,a7A\u0002\u0005u\u0006BB\u0002\u0002\\\u0002\u0007q\u0010C\u0004\u0002h\u0002!I!!;\u0002\u001dA,(\r\\5tQ\u000e{W.\\1oIR\u0019a%a;\t\u0011\u00055\u0018Q\u001da\u0001\u0003_\fQ!\u001a<f]R\u0004B!!=\u0002\u00006\u0011\u00111\u001f\u0006\u0005\u0003k\f90A\u0004d_6l\u0017M\u001c3\u000b\t\u0005e\u00181`\u0001\u0004gBL'bAA\u007f\r\u00051QM\\4j]\u0016LAA!\u0001\u0002t\n)\"+\u001a9pg&$xN]=CCN,7i\\7nC:$\u0007b\u0002B\u0003\u0001\u0011%!qA\u0001\u0011g\u000e\fg\u000e\u00157bG\u0016Dw\u000e\u001c3feN$RA\nB\u0005\u0005'A\u0001Ba\u0003\u0003\u0004\u0001\u0007!QB\u0001\u0010S6\u0004xN\u001d;fIB\u000b7m[1hKB!\u0011\u0011\u0001B\b\u0013\u0011\u0011\t\"a\u0001\u0003\u001f%k\u0007o\u001c:uK\u0012\u0004\u0016mY6bO\u0016D\u0001B!\u0006\u0003\u0004\u0001\u0007!qC\u0001\u0004GRD\b\u0003BA\u0001\u00053IAAa\u0007\u0002\u0004\t\u0001\u0012*\u001c9peRLgnZ\"p]R,\u0007\u0010\u001e\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0003a\u0011Xm]8mm\u0016\fe\u000eZ#oe&\u001c\u0007.\u0011:uS\u001a\f7\r\u001e\u000b\u0004M\t\r\u0002\u0002\u0003B\u0013\u0005;\u0001\rAa\n\u0002\u001dM|WO]2f\u0003J$\u0018NZ1diB!!\u0011\u0006B\u001a\u001b\t\u0011YC\u0003\u0003\u0003.\t=\u0012\u0001C1si&4\u0017m\u0019;\u000b\t\tE\u0012qH\u0001\u0004k\u0012l\u0017\u0002\u0002B\u001b\u0005W\u0011abU8ve\u000e,\u0017I\u001d;jM\u0006\u001cG\u000fC\u0004\u0003:\u0001!IAa\u000f\u0002+%\u001c\u0018I\u001d;jM\u0006\u001cG\u000f\u0015:f\u000b:\u0014\u0018n\u00195fIR!\u0011\u0011\nB\u001f\u0011!\u0011yDa\u000eA\u0002\t\u001d\u0012A\u00033fa2|\u00170\u00192mK\"9!1\t\u0001\u0005\n\t\u0015\u0013!D2iK\u000e\\\u0017*\u001c9peR,G\rF\u0002'\u0005\u000fB\u0001B!\u0013\u0003B\u0001\u0007!1J\u0001\fa\u0006\u001c7.Y4f\u0013:4w\u000e\u0005\u0003\u0002\u0002\t5\u0013\u0002\u0002B(\u0003\u0007\u00111\u0002U1dW\u0006<W-\u00138g_\"9!1\u000b\u0001\u0005\n\tU\u0013AD2sK\u0006$X-\u00128uSRLWm\u001d\u000b\bM\t]#\u0011\fB/\u0011!\u0011YA!\u0015A\u0002\t5\u0001\u0002\u0003B.\u0005#\u0002\r!!\u0013\u0002\u0013%\u001cX\u000b]4sC\u0012,\u0007\u0002\u0003B0\u0005#\u0002\rA!\u0019\u0002#Q|7I]3bi\u0016\u001cu\u000e\u001c7fGR|'\u000fE\u0003{\u0005G\u00129'C\u0002\u0003fm\u00141aU3u!\u0011\u0011IGa\u001b\u000e\u0005\t=\u0012\u0002\u0002B7\u0005_\u0011\u0011cQ8oM&<WO]1uS>t\u0017\n^3n\u0011\u001d\u0011\t\b\u0001C\u0005\u0005g\naCZ5mi\u0016\u0014X\t_5ti&tw\rU1dW\u0006<Wm\u001d\u000b\u0005\u0005k\u0012y\b\u0005\u0004\u0002 \n]$\u0011P\u0005\u0005\u0005K\n\t\f\u0005\u0003\u0002:\tm\u0014\u0002\u0002B?\u0003w\u0011!\u0003\u0015:pa\u0016\u0014H/\u001f#fg\u000e\u0014\u0018\u000e\u001d;pe\"A!\u0011\u0011B8\u0001\u0004\u0011\u0019)A\u0004wKJ\u001c\u0018n\u001c8\u0011\t\t%$QQ\u0005\u0005\u0005\u000f\u0013yCA\u0004WKJ\u001c\u0018n\u001c8\t\u000f\t-\u0005\u0001\"\u0003\u0003\u000e\u0006q2M]3bi\u0016tUm\u001d;fI\u000e{gNZ5hkJ\fG/[8o\u0013R,Wn\u001d\u000b\u0006M\t=%1\u0013\u0005\t\u0005#\u0013I\t1\u0001\u0003h\u0005\u00111-\u001b\u0005\t\u0005?\u0012I\t1\u0001\u0003b!9!q\u0013\u0001\u0005\n\te\u0015\u0001\u0003<bY&$\u0017\r^3\u0015\u0007\u0019\u0012Y\n\u0003\u0005\u0003\u001e\nU\u0005\u0019\u0001B1\u0003!!xn\u0011:fCR,\u0007b\u0002B.\u0001\u0011%!\u0011\u0015\u000b\u0005\u0003\u0013\u0012\u0019\u000b\u0003\u0005\u0003J\t}\u0005\u0019\u0001B&\u0011\u001d\u00119\u000b\u0001C\u0005\u0005S\u000bq!\u00199q\u001d\u0006lW\r\u0006\u0003\u0002\u001e\n-\u0006\u0002\u0003B%\u0005K\u0003\rAa\u0013\t\u000f\t=\u0006\u0001\"\u0003\u00032\u0006\u00112/\u001e2TiJLgnZ!gi\u0016\u0014H*Y:u)\u0019\tiJa-\u00038\"A!Q\u0017BW\u0001\u0004\ti*A\u0001t\u0011!\u0011IL!,A\u0002\u0005u\u0015aA:fa\"9!Q\u0018\u0001\u0005\n\t}\u0016aE:vEN#(/\u001b8h\u0005\u00164wN]3MCN$HCBAO\u0005\u0003\u0014\u0019\r\u0003\u0005\u00036\nm\u0006\u0019AAO\u0011!\u0011ILa/A\u0002\u0005u\u0005bBAc\u0001\u0011%!q\u0019\u000b\u0006M\t%'1\u001a\u0005\t\u00057\u0012)\r1\u0001\u0002J!A!\u0011\nBc\u0001\u0004\u0011Y\u0005")
public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private RoleService roleService;
    private Validator validator;
    private SourceArtifactEnricher enricher;
    private final java.util.List<Importer> importers;
    private final Logger logger;
    private final Function1<PropertyKind, Object> isCollectionKind;
    private File importablePackageDirectory;

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public void repositoryService_$eq(RepositoryService x$1) {
        this.repositoryService = x$1;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public Validator validator() {
        return this.validator;
    }

    public void validator_$eq(Validator x$1) {
        this.validator = x$1;
    }

    public SourceArtifactEnricher enricher() {
        return this.enricher;
    }

    public void enricher_$eq(SourceArtifactEnricher x$1) {
        this.enricher = x$1;
    }

    private java.util.List<Importer> importers() {
        return this.importers;
    }

    private Logger logger() {
        return this.logger;
    }

    private Function1<PropertyKind, Object> isCollectionKind() {
        return this.isCollectionKind;
    }

    private File importablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    private void importablePackageDirectory_$eq(File x$1) {
        this.importablePackageDirectory = x$1;
    }

    @PostConstruct
    public void initImporters() {
        Set importerClasses = Scannit.getInstance().getSubTypesOf(Importer.class);
        this.logger().debug("Found importers: {}", new Object[]{importerClasses});
        ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(importerClasses).filter((Function1 & Serializable & scala.Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$1(cls)))).foreach((Function1 & Serializable & scala.Serializable)importerClass -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$2(this, importerClass)));
        this.importers().sort((o1, o2) -> o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName()));
        this.importers().add((Importer)new XmlManifestDarImporter(this.repositoryService()));
        this.logger().debug("Importer {} registered.", new Object[]{XmlManifestDarImporter.class});
        this.logger().info("Importers configured in XL Deploy: {}", new Object[]{this.importers()});
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory();
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory_$eq(importablePackageDirectory);
    }

    @Override
    public java.util.List<String> listPackages() {
        return Lists.newArrayList((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqLike)List$.MODULE$.apply((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.importers())).withFilter((Function1 & Serializable & scala.Serializable)importer -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$listPackages$1(importer))).flatMap((Function1 & Serializable & scala.Serializable)importer -> (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(((ListableImporter)importer).list(this.importablePackageDirectory())).map((Function1 & Serializable & scala.Serializable)pkgFound -> pkgFound, Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).asJava()));
    }

    @Override
    public String importPackage(ImportSource source) {
        String string;
        try {
            Option option = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.importers()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(source)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ImporterException("The selected file does not have the expected format for an importable package", new Object[0]);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Importer importer = (Importer)some.value();
            String string2 = this.doImport(source, importer);
            string = string2;
        }
        finally {
            source.cleanUp();
        }
        return string;
    }

    public void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }

    private String doImport(ImportSource source, Importer importer) {
        String string;
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        try {
            boolean upgrade = this.isUpgrade(packageInfo);
            this.checkPermission(upgrade, packageInfo);
            this.checkImported(packageInfo);
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage, ctx);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, upgrade, toCreate);
            this.validate(toCreate);
            if (upgrade) {
                importedPackage.getVersion().setApplication((Application)this.repositoryService().read(packageInfo.getApplicationId()));
            }
            CreateCisCommand event = new CreateCisCommand((java.util.List)Lists.newArrayList((Iterable)toCreate));
            this.publishCommand((RepositoryBaseCommand)event);
            string = importedPackage.getVersion().getId();
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
        return string;
    }

    private void publishCommand(RepositoryBaseCommand event) {
        List roles = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.roleService().getRolesFor(Permissions.getAuthentication())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Buffer$.MODULE$.canBuildFrom())).toList();
        event.setSecurityContext(Permissions.getAuthenticatedUserName(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)roles));
        EventBusHolder.publish((Object)event, (EventHandlerStrategy)new ThrowingRuntimeExceptionHandlerStrategy());
    }

    private void scanPlaceholders(ImportedPackage importedPackage, ImportingContext ctx) {
        block0: {
            if (!(importedPackage.getVersion() instanceof DeploymentPackage)) break block0;
            ((java.util.List)ctx.getAttribute("temporaryFiles")).add(new TFile(Files.createTempDir()));
            JavaConversions$.MODULE$.deprecated$u0020asScalaSet(package$.MODULE$.getAllArtifacts(importedPackage.getDeployables())).foreach((Function1 & Serializable & scala.Serializable)sourceArtifact -> {
                ImporterServiceImpl.$anonfun$scanPlaceholders$1(this, sourceArtifact);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void resolveAndEnrichArtifact(SourceArtifact sourceArtifact) {
        try {
            ResourceManagement$.MODULE$.using((Closeable)ArtifactResolverRegistry$.MODULE$.resolve(sourceArtifact), (Function1 & Serializable & scala.Serializable)resolve -> {
                ResourceManagement$.MODULE$.using((Closeable)resolve.openStream(), (Function1 & Serializable & scala.Serializable)is -> {
                    ImporterServiceImpl.$anonfun$resolveAndEnrichArtifact$2($this, sourceArtifact$1, resolve, is);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (IOException iOException) {
            throw new ImporterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not open stream of uri ", " of unresolved artifact ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceArtifact.getFileUri(), sourceArtifact})), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isArtifactPreEnriched(SourceArtifact deployable) {
        void var2_2;
        boolean isPreEnrichedArtifact = deployable.hasProperty("preEnrichedArtifact") && BoxesRunTime.unboxToBoolean((Object)deployable.getProperty("preEnrichedArtifact"));
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Artifact ", " is ", " pre-enriched"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deployable, isPreEnrichedArtifact ? "" : "not"})));
        return (boolean)var2_2;
    }

    private void checkImported(PackageInfo packageInfo) {
        String id = IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion());
        if (this.repositoryService().exists(id)) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
        String dirs = this.subStringBeforeLast(packageInfo.getApplicationId(), "/");
        if (!this.repositoryService().exists(dirs)) {
            throw new ImporterException("The directory structure [%s] specified for the import of application [%s] does not exist.", dirs, this.appName(packageInfo));
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        Object object = !isUpgrade ? BoxesRunTime.boxToBoolean((boolean)toCreateCollector.add((ConfigurationItem)importedPackage.getApplication())) : BoxedUnit.UNIT;
        Version version = importedPackage.getVersion();
        toCreateCollector.add((ConfigurationItem)version);
        this.filterExistingPackages(version).withFilter((Function1 & Serializable & scala.Serializable)pd -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createEntities$1(this, pd))).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            ImporterServiceImpl.$anonfun$createEntities$2(this, toCreateCollector, version, pd);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<PropertyDescriptor> filterExistingPackages(Version version) {
        scala.collection.immutable.Set propertyDescriptors = JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(version.getType().getDescriptor().getPropertyDescriptors()).toSet();
        return !(version instanceof CompositePackage) ? propertyDescriptors : (scala.collection.immutable.Set)propertyDescriptors.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$filterExistingPackages$1(x$3)));
    }

    private void createNestedConfigurationItems(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(propertyDescriptors).withFilter((Function1 & Serializable & scala.Serializable)propertyDescriptor -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$1(this, propertyDescriptor))).foreach((Function1 & Serializable & scala.Serializable)propertyDescriptor -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$2(this, ci, toCreateCollector, propertyDescriptor);
            return BoxedUnit.UNIT;
        });
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        scala.collection.mutable.Set msgs = (scala.collection.mutable.Set)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(toCreate).flatMap((Function1 & Serializable & scala.Serializable)toCreateEntity -> (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.validator().validate(toCreateEntity, (java.util.List)Lists.newArrayList((Iterable)toCreate))).map((Function1 & Serializable & scala.Serializable)msg -> msg, Buffer$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom());
        if (msgs.nonEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", msgs.mkString(", "));
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        boolean bl;
        boolean locationSpecified = packageInfo.getApplicationName().contains("/");
        List applications = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.repositoryService().list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(this.appName(packageInfo)).setAncestor(packageInfo.getApplicationRoot()))).toList();
        int n = applications.length();
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                if (locationSpecified) {
                    String string = ((ConfigurationItemData)applications.head()).getId();
                    String string2 = packageInfo.getApplicationId();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new ImporterException("The manifest contains the path [%s] to import the application into, but the application exists at the path [%s]", packageInfo.getApplicationId(), ((ConfigurationItemData)applications.head()).getId());
                    }
                }
                String appId = ((ConfigurationItemData)applications.head()).getId();
                packageInfo.setDirectories(appId.substring(packageInfo.getApplicationRoot().length(), appId.length() - packageInfo.getApplicationName().length()));
                bl = true;
                break;
            }
            default: {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found more than 1 [", "] with the same name: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((ConfigurationItemData)applications.head()).getType(), applications.mkString(", ")})));
            }
        }
        return bl;
    }

    private String appName(PackageInfo packageInfo) {
        return this.subStringAfterLast(packageInfo.getApplicationId(), "/");
    }

    private String subStringAfterLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(s.lastIndexOf(sep) + sep.length());
    }

    private String subStringBeforeLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(0, s.lastIndexOf(sep));
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        Permission requiredPermission = isUpgrade ? DeployitPermissions.IMPORT_UPGRADE : DeployitPermissions.IMPORT_INITIAL;
        this.checkPermission(requiredPermission, packageInfo.getApplicationId());
    }

    public static final /* synthetic */ boolean $anonfun$isCollectionKind$1(PropertyKind kind) {
        return kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$initImporters$1(Class cls) {
        if (cls.isInterface()) return false;
        if (Modifier.isAbstract(cls.getModifiers())) return false;
        Class clazz = cls;
        Class<XmlManifestDarImporter> clazz2 = XmlManifestDarImporter.class;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$initImporters$2(ImporterServiceImpl $this, Class importerClass) {
        boolean bl;
        try {
            $this.logger().debug("Importer {} registered.", new Object[]{importerClass});
            bl = $this.importers().add((Importer)importerClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate importer: " + importerClass, e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listPackages$1(Importer importer) {
        return importer instanceof ListableImporter;
    }

    public static final /* synthetic */ void $anonfun$scanPlaceholders$1(ImporterServiceImpl $this, SourceArtifact sourceArtifact) {
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
            $this.logger().info("Artifact {} is a resolved artifact", new Object[]{sourceArtifact});
            if (!$this.isArtifactPreEnriched(sourceArtifact)) {
                $this.enricher().enrichArtifact(sourceArtifact);
            }
        } else {
            $this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resolving artifact ", " from url ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceArtifact, sourceArtifact.getFileUri()})));
            $this.resolveAndEnrichArtifact(sourceArtifact);
        }
    }

    public static final /* synthetic */ void $anonfun$resolveAndEnrichArtifact$2(ImporterServiceImpl $this, SourceArtifact sourceArtifact$1, ResolvedArtifactFile resolve$1, InputStream is) {
        if (!$this.isArtifactPreEnriched(sourceArtifact$1)) {
            $this.enricher().enrichArtifact(sourceArtifact$1, new StreamFile(resolve$1.getFileName(), is));
        }
        sourceArtifact$1.setFile(LocalFile.valueOf((File)new File(resolve$1.getFileName())));
    }

    public static final /* synthetic */ boolean $anonfun$createEntities$1(ImporterServiceImpl $this, PropertyDescriptor pd) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)pd.getKind()));
    }

    public static final /* synthetic */ void $anonfun$createEntities$2(ImporterServiceImpl $this, Set toCreateCollector$1, Version version$1, PropertyDescriptor pd) {
        Collection cis = (Collection)pd.get((ConfigurationItem)version$1);
        toCreateCollector$1.addAll(Sets.newHashSet((Iterable)cis));
        cis.forEach(ci -> $this.createNestedConfigurationItems((ConfigurationItem)ci, toCreateCollector$1));
    }

    public static final /* synthetic */ boolean $anonfun$filterExistingPackages$1(PropertyDescriptor x$3) {
        String string = x$3.getName();
        String string2 = "packages";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$1(ImporterServiceImpl $this, PropertyDescriptor propertyDescriptor) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)propertyDescriptor.getKind()));
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$3(Set toCreateCollector$2, ConfigurationItem embedded) {
        return !toCreateCollector$2.contains(embedded);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$4(ImporterServiceImpl $this, Set toCreateCollector$2, ConfigurationItem embedded) {
        toCreateCollector$2.add(embedded);
        $this.createNestedConfigurationItems(embedded, toCreateCollector$2);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$2(ImporterServiceImpl $this, ConfigurationItem ci$1, Set toCreateCollector$2, PropertyDescriptor propertyDescriptor) {
        JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable((Collection)propertyDescriptor.get(ci$1)).withFilter((Function1 & Serializable & scala.Serializable)embedded -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$3(toCreateCollector$2, embedded))).foreach((Function1 & Serializable & scala.Serializable)embedded -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$4($this, toCreateCollector$2, embedded);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, RoleService roleService, Validator validator, SourceArtifactEnricher enricher) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.validator = validator;
        this.enricher = enricher;
        this.importers = Lists.newArrayList();
        this.logger = LoggerFactory.getLogger(ImporterServiceImpl.class);
        this.isCollectionKind = (Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$isCollectionKind$1(kind));
    }
}

