/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.booter.remote.execution.RemoteTaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.xltype.serialization.util.DateUtil;
import com.xebialabs.xltype.serialization.xstream.AbstractTaskWithBlockConverter;
import java.util.ArrayList;

public class TaskWithBlockConverter
extends AbstractTaskWithBlockConverter {
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteTaskWithBlock task = new RemoteTaskWithBlock();
        task.setId(reader.getAttribute("id"));
        task.setFailureCount(Integer.valueOf(reader.getAttribute("failures")));
        task.setState(TaskExecutionState.valueOf((String)reader.getAttribute("state")));
        task.setOwner(reader.getAttribute("owner"));
        boolean hasBlockNode = false;
        ArrayList<String> activeBlocks = new ArrayList<String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("description".equals(reader.getNodeName())) {
                task.setDescription(reader.getValue());
            } else if ("startDate".equals(reader.getNodeName())) {
                task.setStartDate(DateUtil.fromString((String)reader.getValue()));
            } else if ("completionDate".equals(reader.getNodeName())) {
                task.setCompletionDate(DateUtil.fromString((String)reader.getValue()));
            } else if ("scheduledDate".equals(reader.getNodeName())) {
                task.setScheduledDate(DateUtil.fromString((String)reader.getValue()));
            } else if ("metadata".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    task.getMetadata().put(reader.getNodeName(), reader.getValue());
                    reader.moveUp();
                }
            } else if ("activeBlocks".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    activeBlocks.add(reader.getValue());
                    reader.moveUp();
                }
            } else if ("block".equals(reader.getNodeName())) {
                hasBlockNode = true;
                BlockState blockState = (BlockState)context.convertAnother((Object)task, BlockState.class);
                task.setBlock(blockState);
            }
            reader.moveUp();
        }
        if (!hasBlockNode) {
            throw new IllegalArgumentException("Task xml node that was expected to be a TaskWithBlock did not have a block child node, is the xml correct?");
        }
        task.setActiveBlocks(activeBlocks);
        return task;
    }
}

