/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.smb;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.smb.SmbConnection;
import com.xebialabs.overthere.smb.SmbPaths;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbFile
extends BaseOverthereFile<SmbConnection> {
    private final String hostPath;
    private boolean overwrite = true;
    private Map<String, String> pathMappings;
    private static Logger logger = LoggerFactory.getLogger(SmbFile.class);

    public SmbFile(SmbConnection connection, String hostPath, Map<String, String> pathMappings) {
        super(connection);
        this.hostPath = SmbPaths.escapeForwardSlashes(hostPath);
        this.pathMappings = pathMappings;
    }

    @Override
    public String getPath() {
        return this.hostPath;
    }

    @Override
    public String getName() {
        return SmbPaths.getFileName(this.getPathOnShare());
    }

    @Override
    public OverthereFile getFile(String child) {
        return new SmbFile((SmbConnection)this.getConnection(), SmbPaths.join(this.hostPath, child), this.pathMappings);
    }

    @Override
    public OverthereFile getParentFile() {
        SmbFile f = null;
        String parentPath = SmbPaths.getParentPath(this.hostPath);
        if (parentPath != null) {
            f = this.getFileForAbsolutePath(parentPath);
        }
        return f;
    }

    @Override
    public boolean exists() {
        return this.isFile() || this.isDirectory();
    }

    @Override
    public boolean canRead() {
        logger.debug("Checking whether {} can be read", (Object)this.getPath());
        return this.checkAccess(EnumSet.of(AccessMask.GENERIC_READ), AccessMask.FILE_READ_DATA);
    }

    @Override
    public boolean canWrite() {
        logger.debug("Checking whether {} can be write", (Object)this.getPath());
        return this.checkAccess(EnumSet.of(AccessMask.GENERIC_READ, AccessMask.GENERIC_WRITE), AccessMask.FILE_WRITE_DATA);
    }

    @Override
    public boolean canExecute() {
        logger.debug("Checking whether {} can execute", (Object)this.getPath());
        return this.checkAccess(EnumSet.of(AccessMask.GENERIC_EXECUTE), AccessMask.FILE_EXECUTE);
    }

    private boolean checkAccess(Set<AccessMask> requestAccesSet, AccessMask searchAccessMask) {
        try {
            int accessFlags = this.getAccessMask(requestAccesSet);
            return EnumWithValue.EnumUtils.isSet((long)accessFlags, (EnumWithValue)searchAccessMask);
        }
        catch (SMBApiException e) {
            logger.warn("Acces denied to {} : {}", (Object)this.getPath(), (Object)e.getMessage());
            if (e.getStatus() == NtStatus.STATUS_ACCESS_DENIED) {
                return false;
            }
            throw e;
        }
    }

    private int getAccessMask(Set<AccessMask> requestAccesSet) {
        String pathOnShare = this.getPathOnShare();
        try (DiskEntry entry = this.getShare().open(pathOnShare, requestAccesSet, null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            int n = entry.getFileInformation().getAccessInformation().getAccessFlags();
            return n;
        }
    }

    @Override
    public boolean isFile() {
        try {
            return this.getShare().fileExists(this.getPathOnShare());
        }
        catch (SMBApiException e) {
            if (e.getStatus().equals((Object)NtStatus.STATUS_FILE_IS_A_DIRECTORY) || e.getStatus().equals((Object)NtStatus.STATUS_OBJECT_PATH_NOT_FOUND)) {
                return false;
            }
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.getShare().folderExists(this.getPathOnShare());
        }
        catch (SMBApiException e) {
            if (e.getStatus().equals((Object)NtStatus.STATUS_NOT_A_DIRECTORY) || e.getStatus().equals((Object)NtStatus.STATUS_OBJECT_PATH_NOT_FOUND)) {
                return false;
            }
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public boolean isHidden() {
        return this.checkAttributes(FileAttributes.FILE_ATTRIBUTE_HIDDEN);
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return this.getShare().getFileInformation(this.getPathOnShare()).getStandardInformation().getEndOfFile();
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        logger.debug("Opening SMB input stream for {}", (Object)this.getSharePath());
        final File file = this.getShare().openFile(this.getPathOnShare(), EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);
        final InputStream wrapped = file.getInputStream();
        return this.asBuffered(new InputStream(){

            @Override
            public int read() throws IOException {
                return wrapped.read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return wrapped.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return wrapped.read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return wrapped.skip(n);
            }

            @Override
            public void close() throws IOException {
                logger.debug("Closing SMB input stream for {}", (Object)SmbFile.this.getSharePath());
                wrapped.close();
                file.close();
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        logger.debug("Opening SMB output stream for {}", (Object)this.getSharePath());
        SMB2CreateDisposition createDisposition = SMB2CreateDisposition.FILE_OVERWRITE_IF;
        if (!this.overwrite) {
            createDisposition = SMB2CreateDisposition.FILE_CREATE;
        }
        final File file = this.getShare().openFile(this.getPathOnShare(), EnumSet.of(AccessMask.GENERIC_WRITE), null, SMB2ShareAccess.ALL, createDisposition, null);
        final OutputStream wrapped = file.getOutputStream();
        return this.asBuffered(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                wrapped.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                wrapped.write(b, off, len);
            }

            @Override
            public void write(byte[] b) throws IOException {
                wrapped.write(b);
            }

            @Override
            public void flush() throws IOException {
                wrapped.flush();
            }

            @Override
            public void close() throws IOException {
                logger.debug("Closing SMB output stream for {}", (Object)SmbFile.this.getSharePath());
                wrapped.close();
                file.close();
            }
        });
    }

    @Override
    public void setExecutable(boolean executable) {
    }

    @Override
    public void delete() {
        this.delete(false);
    }

    @Override
    public void deleteRecursively() {
        this.delete(true);
    }

    @Override
    public List<OverthereFile> listFiles() {
        String sharePath = this.getPathOnShare();
        logger.debug("Listing directory {}", (Object)sharePath);
        try {
            ArrayList<OverthereFile> files = new ArrayList<OverthereFile>();
            for (FileIdBothDirectoryInformation info : this.getShare().list(sharePath)) {
                if (info.getFileName().equals(".") || info.getFileName().equals("..")) continue;
                files.add(this.getFile(info.getFileName()));
            }
            return files;
        }
        catch (SMBApiException e) {
            throw new RuntimeIOException(String.format("Cannot list directory %s: %s", sharePath, e.toString()), e);
        }
    }

    @Override
    public void mkdir() {
        this.makeDirectory(this.getPathOnShare());
    }

    private void makeDirectory(String path) {
        String sharePath = this.getPathOnShare();
        logger.debug("Creating directory {}", (Object)sharePath);
        try {
            this.getShare().mkdir(path);
        }
        catch (SMBApiException e) {
            throw new RuntimeIOException(String.format("Cannot create directory %s: %s", sharePath, e.toString()), e);
        }
    }

    @Override
    public void mkdirs() {
        String[] paths;
        String sharePath = this.getPathOnShare();
        logger.debug("Creating directories {}", (Object)sharePath);
        for (String p : paths = SmbPaths.getPathListFromOuterToInner(sharePath)) {
            if (this.getShare().folderExists(p)) continue;
            this.makeDirectory(p);
        }
    }

    @Override
    public void renameTo(OverthereFile dest) {
        String srcPathOnShare = this.getPathOnShare();
        logger.debug("Renaming {} to {}", (Object)srcPathOnShare, (Object)dest);
        if (!(dest instanceof SmbFile)) {
            throw new RuntimeIOException(String.format("Cannot move/rename smb:%s: file/directory %s  to non-smb:%s: file/directory %s", ((SmbConnection)this.connection).cifsConnectionType.toString().toLowerCase(), this.getSharePath(), ((SmbConnection)this.connection).cifsConnectionType.toString().toLowerCase(), dest));
        }
        SmbFile destSmbFile = (SmbFile)dest;
        DiskShare destShare = destSmbFile.getShare();
        DiskShare srcShare = this.getShare();
        if (!srcShare.getSmbPath().toUncPath().equalsIgnoreCase(destShare.getSmbPath().toUncPath())) {
            throw new RuntimeIOException(String.format("Cannot move smb:%s: file/directory %s on the other share smb:%s: file/directory %s", ((SmbConnection)this.connection).cifsConnectionType.toString().toLowerCase(), this.getSharePath(), ((SmbConnection)this.connection).cifsConnectionType.toString().toLowerCase(), dest));
        }
        try (File srcEntry = this.isFile() ? srcShare.openFile(srcPathOnShare, EnumSet.of(AccessMask.DELETE), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null) : srcShare.openDirectory(srcPathOnShare, EnumSet.of(AccessMask.DELETE), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            srcEntry.rename(destSmbFile.getPathOnShare());
        }
        catch (SMBApiException exc) {
            throw new RuntimeIOException(String.format("Cannot move/rename %s to %s: %s", srcPathOnShare, dest, exc.toString()), exc);
        }
    }

    public boolean equals(Object that) {
        if (!(that instanceof SmbFile)) {
            return false;
        }
        return this.getPath().equals(((SmbFile)that).getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    public String toString() {
        return this.getConnection() + "/" + this.getPath();
    }

    private void delete(boolean recursive) {
        String sharePath = this.getPathOnShare();
        try {
            if (this.isFile()) {
                logger.debug("deleting file {}", (Object)sharePath);
                this.getShare().rm(sharePath);
            } else {
                logger.debug("deleting directory {}", (Object)sharePath);
                this.getShare().rmdir(sharePath, recursive);
            }
        }
        catch (SMBApiException e) {
            throw new RuntimeIOException(String.format("Cannot delete %s: %s", sharePath, e.toString()), e);
        }
    }

    private String getSharePath() {
        return SmbPaths.getSharePath(this.hostPath, this.pathMappings);
    }

    private String getPathOnShare() {
        return SmbPaths.getPathOnShare(this.getSharePath());
    }

    private DiskShare getShare() {
        String shareName = SmbPaths.getShareName(this.getSharePath());
        return ((SmbConnection)this.connection).getShare(shareName);
    }

    private boolean checkAttributes(FileAttributes mask) {
        long attrMask = this.getShare().getFileInformation(this.getPathOnShare()).getBasicInformation().getFileAttributes();
        return EnumWithValue.EnumUtils.isSet((long)attrMask, (EnumWithValue)mask);
    }

    private SmbFile getFileForAbsolutePath(String path) {
        return new SmbFile((SmbConnection)this.getConnection(), path, this.pathMappings);
    }
}

