/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.services.io.LimitReader;
import org.apache.derby.impl.load.ImportLobFile;
import org.apache.derby.impl.load.LoadError;

class ImportClob
implements Clob {
    private ImportLobFile lobFile;
    private long position;
    private long length;
    private long clobLength;
    private String clobData = null;

    public ImportClob(ImportLobFile importLobFile, long l, long l2) throws IOException {
        this.lobFile = importLobFile;
        this.position = l;
        this.length = l2;
        this.clobLength = importLobFile.getClobDataLength(l, l2);
    }

    public ImportClob(String string) {
        this.clobData = string;
        this.clobLength = string.length();
    }

    @Override
    public long length() throws SQLException {
        return this.clobLength;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        try {
            if (this.clobData != null) {
                StringReader stringReader = new StringReader(this.clobData);
                LimitReader limitReader = new LimitReader(stringReader);
                limitReader.setLimit((int)this.clobLength);
                return limitReader;
            }
            return this.lobFile.getCharacterStream(this.position, this.length);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public long position(String string, long l) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public void truncate(long l) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public void free() throws SQLException {
        throw this.methodNotImplemented();
    }

    private SQLException methodNotImplemented() {
        return LoadError.unexpectedError(new Exception("Method not implemented"));
    }
}

