/*
 * Decompiled with CFR 0.152.
 */
package kamon.trace;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.metric.MetricsModule;
import kamon.trace.Incubator$;
import kamon.trace.LevelOfDetail;
import kamon.trace.LevelOfDetail$MetricsOnly$;
import kamon.trace.MetricsOnlyContext;
import kamon.trace.Status;
import kamon.trace.Status$Open$;
import kamon.trace.TraceContext;
import kamon.trace.TraceInfo;
import kamon.trace.TraceSettings;
import kamon.trace.TraceSettings$;
import kamon.trace.TraceSubscriptions;
import kamon.trace.TracerModule;
import kamon.trace.TracerModuleImpl$;
import kamon.trace.TracingContext;
import kamon.util.LazyActorRef;
import kamon.util.RelativeNanoTimestamp$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055h!B\u0001\u0003\u0001\u00111!\u0001\u0005+sC\u000e,'/T8ek2,\u0017*\u001c9m\u0015\t\u0019A!A\u0003ue\u0006\u001cWMC\u0001\u0006\u0003\u0015Y\u0017-\\8o'\r\u0001q!\u0004\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059yQ\"\u0001\u0002\n\u0005A\u0011!\u0001\u0004+sC\u000e,'/T8ek2,\u0007\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002!5,GO]5dg\u0016CH/\u001a8tS>t7\u0001\u0001\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\ta!\\3ue&\u001c\u0017BA\r\u0017\u00055iU\r\u001e:jGNlu\u000eZ;mK\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\u0004d_:4\u0017n\u001a\t\u0003;\rj\u0011A\b\u0006\u00037}Q!\u0001I\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011AI\u0001\u0004G>l\u0017B\u0001\u0013\u001f\u0005\u0019\u0019uN\u001c4jO\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"2\u0001K\u0015+!\tq\u0001\u0001C\u0003\u0013K\u0001\u0007A\u0003C\u0003\u001cK\u0001\u0007A\u0004C\u0004-\u0001\u0001\u0007I\u0011B\u0017\u0002\u0013}\u001bX\r\u001e;j]\u001e\u001cX#\u0001\u0018\u0011\u00059y\u0013B\u0001\u0019\u0003\u00055!&/Y2f'\u0016$H/\u001b8hg\"9!\u0007\u0001a\u0001\n\u0013\u0019\u0014!D0tKR$\u0018N\\4t?\u0012*\u0017\u000f\u0006\u00025oA\u0011\u0001\"N\u0005\u0003m%\u0011A!\u00168ji\"9\u0001(MA\u0001\u0002\u0004q\u0013a\u0001=%c!1!\b\u0001Q!\n9\n!bX:fiRLgnZ:!Q\tID\b\u0005\u0002\t{%\u0011a(\u0003\u0002\tm>d\u0017\r^5mK\"9\u0001\t\u0001b\u0001\n\u0013\t\u0015AD0tk\n\u001c8M]5qi&|gn]\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tB\u0001\u0005kRLG.\u0003\u0002H\t\naA*\u0019>z\u0003\u000e$xN\u001d*fM\"1\u0011\n\u0001Q\u0001\n\t\u000bqbX:vEN\u001c'/\u001b9uS>t7\u000f\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003B\u0003)y\u0016N\\2vE\u0006$xN\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\"\u0002\u0017}KgnY;cCR|'\u000f\t\u0005\u0006\u001f\u0002!I\u0001U\u0001\t]\u0016<Hk\\6f]V\t\u0011\u000b\u0005\u0002S3:\u00111k\u0016\t\u0003)&i\u0011!\u0016\u0006\u0003-N\ta\u0001\u0010:p_Rt\u0014B\u0001-\n\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005aK\u0001\"B/\u0001\t\u0003q\u0016A\u00038fo\u000e{g\u000e^3yiR\u0011qL\u0019\t\u0003\u001d\u0001L!!\u0019\u0002\u0003\u0019Q\u0013\u0018mY3D_:$X\r\u001f;\t\u000b\rd\u0006\u0019A)\u0002\t9\fW.\u001a\u0005\u0006;\u0002!\t!\u001a\u000b\u0004?\u001a<\u0007\"B2e\u0001\u0004\t\u0006\"\u00025e\u0001\u0004I\u0017!\u0002;pW\u0016t\u0007c\u0001\u0005k#&\u00111.\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bu\u0003A\u0011A7\u0015\t}sw\u000e\u001d\u0005\u0006G2\u0004\r!\u0015\u0005\u0006Q2\u0004\r!\u001b\u0005\u0006c2\u0004\rA]\u0001\u0005i\u0006<7\u000f\u0005\u0003SgF\u000b\u0016B\u0001;\\\u0005\ri\u0015\r\u001d\u0005\u0006;\u0002!\tA\u001e\u000b\t?^D\u0018P_@\u0002\n!)1-\u001ea\u0001#\")\u0001.\u001ea\u0001S\")\u0011/\u001ea\u0001e\")10\u001ea\u0001y\u0006IA/[7fgR\fW\u000e\u001d\t\u0003\u0007vL!A #\u0003+I+G.\u0019;jm\u0016t\u0015M\\8US6,7\u000f^1na\"9\u0011\u0011A;A\u0002\u0005\r\u0011AB:uCR,8\u000fE\u0002\u000f\u0003\u000bI1!a\u0002\u0003\u0005\u0019\u0019F/\u0019;vg\"9\u00111B;A\u0002\u00055\u0011aB5t\u0019>\u001c\u0017\r\u001c\t\u0004\u0011\u0005=\u0011bAA\t\u0013\t9!i\\8mK\u0006t\u0007bBA\u000b\u0001\u0011%\u0011qC\u0001\u0013GJ,\u0017\r^3Ue\u0006\u001cWmQ8oi\u0016DH\u000fF\u0007`\u00033\ti\"a\b\u0002\"\u0005\u0015\u0012q\u0005\u0005\b\u00037\t\u0019\u00021\u0001R\u0003%!(/Y2f\u001d\u0006lW\r\u0003\u0004i\u0003'\u0001\r!\u001b\u0005\tc\u0006M\u0001\u0013!a\u0001e\"I\u00111EA\n!\u0003\u0005\r\u0001`\u0001\u000fgR\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0011)\t\t!a\u0005\u0011\u0002\u0003\u0007\u00111\u0001\u0005\u000b\u0003\u0017\t\u0019\u0002%AA\u0002\u00055\u0001bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\ngV\u00147o\u0019:jE\u0016$2\u0001NA\u0018\u0011!\t\t$!\u000bA\u0002\u0005M\u0012AC:vEN\u001c'/\u001b2feB!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!B1di>\u0014(BAA\u001f\u0003\u0011\t7n[1\n\t\u0005\u0005\u0013q\u0007\u0002\t\u0003\u000e$xN\u001d*fM\"9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013aC;ogV\u00147o\u0019:jE\u0016$2\u0001NA%\u0011!\t\t$a\u0011A\u0002\u0005M\u0002\u0002CA'\u0001\u0011\u0005A!a\u0014\u0002-\u0011L7\u000f]1uG\"$&/Y2j]\u001e\u001cuN\u001c;fqR$2\u0001NA)\u0011\u001d\u0019\u00111\na\u0001\u0003'\u00022ADA+\u0013\r\t9F\u0001\u0002\u000f)J\f7-\u001b8h\u0007>tG/\u001a=u\u0011%\tY\u0006\u0001a\u0001\n\u0013\ti&A\u0004`gf\u001cH/Z7\u0016\u0005\u0005}\u0003\u0003BA\u001b\u0003CJA!a\u0019\u00028\tY\u0011i\u0019;peNK8\u000f^3n\u0011%\t9\u0007\u0001a\u0001\n\u0013\tI'A\u0006`gf\u001cH/Z7`I\u0015\fHc\u0001\u001b\u0002l!I\u0001(!\u001a\u0002\u0002\u0003\u0007\u0011q\f\u0005\t\u0003_\u0002\u0001\u0015)\u0003\u0002`\u0005Aql]=ti\u0016l\u0007\u0005C\u0005\u0002t\u0001\u0001\r\u0011\"\u0003\u0002v\u00059q\f\\8hO\u0016\u0014XCAA<!\u0011\tI(a \u000e\u0005\u0005m$\u0002BA?\u0003w\tQ!\u001a<f]RLA!!!\u0002|\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\b\"CAC\u0001\u0001\u0007I\u0011BAD\u0003-yFn\\4hKJ|F%Z9\u0015\u0007Q\nI\tC\u00059\u0003\u0007\u000b\t\u00111\u0001\u0002x!A\u0011Q\u0012\u0001!B\u0013\t9(\u0001\u0005`Y><w-\u001a:!\u0011)\t\t\n\u0001EC\u0002\u0013%\u00111S\u0001\u0007?N$\u0018M\u001d;\u0016\u0003QBq!a&\u0001\t\u0003\tI*A\u0003ti\u0006\u0014H\u000fF\u00035\u00037\u000by\n\u0003\u0005\u0002\u001e\u0006U\u0005\u0019AA0\u0003\u0019\u0019\u0018p\u001d;f[\"9\u0011\u0011UAK\u0001\u0004a\u0012!\u00038fo\u000e{gNZ5h\u0011%\t)\u000bAI\u0001\n\u0013\t9+\u0001\u000fde\u0016\fG/\u001a+sC\u000e,7i\u001c8uKb$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005%&f\u0001:\u0002,.\u0012\u0011Q\u0016\t\u0005\u0003_\u000bI,\u0004\u0002\u00022*!\u00111WA[\u0003%)hn\u00195fG.,GMC\u0002\u00028&\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY,!-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002@\u0002\t\n\u0011\"\u0003\u0002B\u0006a2M]3bi\u0016$&/Y2f\u0007>tG/\u001a=uI\u0011,g-Y;mi\u0012\"TCAAbU\ra\u00181\u0016\u0005\n\u0003\u000f\u0004\u0011\u0013!C\u0005\u0003\u0013\fAd\u0019:fCR,GK]1dK\u000e{g\u000e^3yi\u0012\"WMZ1vYR$S'\u0006\u0002\u0002L*\"\u00111AAV\u0011%\ty\rAI\u0001\n\u0013\t\t.\u0001\u000fde\u0016\fG/\u001a+sC\u000e,7i\u001c8uKb$H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005M'\u0006BA\u0007\u0003W;\u0001\"a6\u0003\u0011\u0003!\u0011\u0011\\\u0001\u0011)J\f7-\u001a:N_\u0012,H.Z%na2\u00042ADAn\r\u001d\t!\u0001#\u0001\u0005\u0003;\u001c2!a7\b\u0011\u001d1\u00131\u001cC\u0001\u0003C$\"!!7\t\u0011\u0005\u0015\u00181\u001cC\u0001\u0003O\fQ!\u00199qYf$R\u0001KAu\u0003WDaAEAr\u0001\u0004!\u0002BB\u000e\u0002d\u0002\u0007A\u0004")
public class TracerModuleImpl
implements TracerModule {
    private BoxedUnit _start;
    private volatile TraceSettings _settings;
    private final LazyActorRef _subscriptions;
    private final LazyActorRef _incubator;
    private ActorSystem _system;
    private LoggingAdapter _logger;
    private volatile boolean bitmap$0;

    public static TracerModuleImpl apply(MetricsModule metricsModule, Config config) {
        return TracerModuleImpl$.MODULE$.apply(metricsModule, config);
    }

    private TraceSettings _settings() {
        return this._settings;
    }

    private void _settings_$eq(TraceSettings x$1) {
        this._settings = x$1;
    }

    private LazyActorRef _subscriptions() {
        return this._subscriptions;
    }

    private LazyActorRef _incubator() {
        return this._incubator;
    }

    private String newToken() {
        return (String)this._settings().tokenGenerator().apply();
    }

    @Override
    public TraceContext newContext(String name) {
        return this.createTraceContext(name, (Option<String>)None$.MODULE$, this.createTraceContext$default$3(), this.createTraceContext$default$4(), this.createTraceContext$default$5(), this.createTraceContext$default$6());
    }

    @Override
    public TraceContext newContext(String name, Option<String> token) {
        return this.createTraceContext(name, token, this.createTraceContext$default$3(), this.createTraceContext$default$4(), this.createTraceContext$default$5(), this.createTraceContext$default$6());
    }

    @Override
    public TraceContext newContext(String name, Option<String> token, Map<String, String> tags) {
        return this.createTraceContext(name, token, tags, this.createTraceContext$default$4(), this.createTraceContext$default$5(), this.createTraceContext$default$6());
    }

    @Override
    public TraceContext newContext(String name, Option<String> token, Map<String, String> tags, long timestamp, Status status, boolean isLocal) {
        return this.createTraceContext(name, token, tags, timestamp, status, isLocal);
    }

    private TraceContext createTraceContext(String traceName, Option<String> token, Map<String, String> tags, long startTimestamp, Status status, boolean isLocal) {
        String traceToken = (String)token.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.newToken());
        LevelOfDetail levelOfDetail = this._settings().levelOfDetail();
        TraceContext traceContext = LevelOfDetail$MetricsOnly$.MODULE$.equals(levelOfDetail) ? this.newMetricsOnlyContext$1(traceToken, traceName, tags, startTimestamp, status) : (!isLocal || !this._settings().sampler().shouldTrace() ? this.newMetricsOnlyContext$1(traceToken, traceName, tags, startTimestamp, status) : new TracingContext(traceName, traceToken, tags, Status$Open$.MODULE$, this._settings().levelOfDetail(), isLocal, startTimestamp, this._logger(), (Function1<TracingContext, BoxedUnit>)(Function1 & Serializable & scala.Serializable)trace -> {
            this.dispatchTracingContext(trace);
            return BoxedUnit.UNIT;
        }));
        return traceContext;
    }

    private Map<String, String> createTraceContext$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private long createTraceContext$default$4() {
        return RelativeNanoTimestamp$.MODULE$.now();
    }

    private Status createTraceContext$default$5() {
        return Status$Open$.MODULE$;
    }

    private boolean createTraceContext$default$6() {
        return true;
    }

    @Override
    public void subscribe(ActorRef subscriber) {
        TraceSubscriptions.Subscribe x$1 = new TraceSubscriptions.Subscribe(subscriber);
        ActorRef x$2 = this._subscriptions().tell$default$2(x$1);
        this._subscriptions().tell(x$1, x$2);
    }

    @Override
    public void unsubscribe(ActorRef subscriber) {
        TraceSubscriptions.Unsubscribe x$3 = new TraceSubscriptions.Unsubscribe(subscriber);
        ActorRef x$4 = this._subscriptions().tell$default$2(x$3);
        this._subscriptions().tell(x$3, x$4);
    }

    public void dispatchTracingContext(TracingContext trace) {
        block2: {
            if (!this._settings().sampler().shouldReport(trace.elapsedTime())) break block2;
            if (trace.shouldIncubate()) {
                TracingContext x$5 = trace;
                ActorRef x$6 = this._incubator().tell$default$2(x$5);
                this._incubator().tell(x$5, x$6);
            } else {
                TraceInfo x$7 = trace.generateTraceInfo();
                ActorRef x$8 = this._subscriptions().tell$default$2(x$7);
                this._subscriptions().tell(x$7, x$8);
            }
        }
    }

    private ActorSystem _system() {
        return this._system;
    }

    private void _system_$eq(ActorSystem x$1) {
        this._system = x$1;
    }

    private LoggingAdapter _logger() {
        return this._logger;
    }

    private void _logger_$eq(LoggingAdapter x$1) {
        this._logger = x$1;
    }

    private void _start$lzycompute() {
        TracerModuleImpl tracerModuleImpl = this;
        synchronized (tracerModuleImpl) {
            if (!this.bitmap$0) {
                ActorRef subscriptions = this._system().actorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(TraceSubscriptions.class)), "trace-subscriptions");
                this._subscriptions().point(subscriptions);
                this._incubator().point(this._system().actorOf(Incubator$.MODULE$.props(subscriptions)));
                this.bitmap$0 = true;
            }
        }
    }

    private void _start() {
        block0: {
            if (this.bitmap$0) break block0;
            this._start$lzycompute();
        }
    }

    public synchronized void start(ActorSystem system, Config newConfig) {
        this._settings_$eq(TraceSettings$.MODULE$.apply(newConfig));
        this._system_$eq(system);
        this._logger_$eq(Logging$.MODULE$.apply(this._system(), (Object)"TracerModule", LogSource$.MODULE$.fromString()));
        this._start();
        this._system_$eq(null);
    }

    private final TraceContext newMetricsOnlyContext$1(String token, String traceName$1, Map tags$1, long startTimestamp$1, Status status$1) {
        return new MetricsOnlyContext(traceName$1, token, (Map<String, String>)tags$1, status$1, this._settings().levelOfDetail(), startTimestamp$1, this._logger());
    }

    public TracerModuleImpl(MetricsModule metricsExtension, Config config) {
        this._settings = TraceSettings$.MODULE$.apply(config);
        this._subscriptions = new LazyActorRef();
        this._incubator = new LazyActorRef();
        this._system = null;
        this._logger = null;
    }
}

