/*
 * Decompiled with CFR 0.152.
 */
package kamon.jsr166;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import kamon.jsr166.Striped64;

public class LongMaxUpdater
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    @Override
    final long fn(long l, long l2) {
        return l > l2 ? l : l2;
    }

    public LongMaxUpdater() {
        this.base = Long.MIN_VALUE;
    }

    public LongMaxUpdater(long l) {
        this.base = l;
    }

    public void update(long l) {
        long l2;
        Striped64.Cell[] cellArray = this.cells;
        if (this.cells != null || (l2 = this.base) < l && !this.casBase(l2, l)) {
            long l3;
            Striped64.Cell cell;
            int n;
            boolean bl = true;
            Striped64.HashCode hashCode = (Striped64.HashCode)threadHashCode.get();
            int n2 = hashCode.code;
            if (cellArray == null || (n = cellArray.length) < 1 || (cell = cellArray[n - 1 & n2]) == null || (l3 = cell.value) < l && !(bl = cell.cas(l3, l))) {
                this.retryUpdate(l, hashCode, bl);
            }
        }
    }

    public long max() {
        Striped64.Cell[] cellArray = this.cells;
        long l = this.base;
        if (cellArray != null) {
            for (Striped64.Cell cell : cellArray) {
                long l2;
                if (cell == null || (l2 = cell.value) <= l) continue;
                l = l2;
            }
        }
        return l;
    }

    public void reset() {
        this.internalReset(Long.MIN_VALUE);
    }

    public long maxThenReset(long l) {
        Striped64.Cell[] cellArray = this.cells;
        long l2 = this.base;
        this.base = l;
        if (cellArray != null) {
            for (Striped64.Cell cell : cellArray) {
                if (cell == null) continue;
                long l3 = cell.value;
                cell.value = l;
                if (l3 <= l2) continue;
                l2 = l3;
            }
        }
        return l2;
    }

    public String toString() {
        return Long.toString(this.max());
    }

    @Override
    public long longValue() {
        return this.max();
    }

    @Override
    public int intValue() {
        return (int)this.max();
    }

    @Override
    public float floatValue() {
        return this.max();
    }

    @Override
    public double doubleValue() {
        return this.max();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeLong(this.max());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = objectInputStream.readLong();
    }
}

