/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import akka.actor.ActorSystem;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.plugin.satellite.SatelliteCommunicatorSystem;
import com.xebialabs.xlplatform.akka25.Akka25;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import scala.concurrent.duration.Duration;

@Configuration
@Lazy
public class EngineBeanBuilder {
    @Autowired
    private Archive archive;
    @Autowired
    private RepositoryFactory repositoryAdapter;
    private final ActorSystem system = SatelliteCommunicatorSystem.actorSystem();

    @Bean
    @DependsOn(value={"upgrader"})
    public TaskExecutionEngine engine() {
        return new TaskExecutionEngine(this.archive, this.repositoryAdapter, this.system);
    }

    @PreDestroy
    public void destroy() {
        Akka25.terminate((ActorSystem)this.system, (Duration)Duration.Inf());
    }
}

