/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.Configuration;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.status.AtomicCounter;

public abstract class UdpChannelTransport
implements AutoCloseable {
    protected final UdpChannel udpChannel;
    protected final AtomicCounter invalidPackets;
    protected final DistinctErrorLog errorLog;
    protected UdpTransportPoller transportPoller;
    protected SelectionKey selectionKey;
    protected InetSocketAddress bindAddress;
    protected InetSocketAddress endPointAddress;
    protected InetSocketAddress connectAddress;
    protected DatagramChannel sendDatagramChannel;
    protected DatagramChannel receiveDatagramChannel;
    protected int multicastTtl = 0;
    protected boolean isClosed = false;

    public UdpChannelTransport(UdpChannel udpChannel, InetSocketAddress endPointAddress, InetSocketAddress bindAddress, InetSocketAddress connectAddress, DistinctErrorLog errorLog, AtomicCounter invalidPackets) {
        this.udpChannel = udpChannel;
        this.errorLog = errorLog;
        this.endPointAddress = endPointAddress;
        this.bindAddress = bindAddress;
        this.connectAddress = connectAddress;
        this.invalidPackets = invalidPackets;
    }

    public void openDatagramChannel(AtomicCounter statusIndicator) {
        try {
            this.receiveDatagramChannel = this.sendDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
            if (this.udpChannel.isMulticast()) {
                if (null != this.connectAddress) {
                    this.receiveDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
                }
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                this.receiveDatagramChannel.bind(new InetSocketAddress(this.endPointAddress.getPort()));
                this.receiveDatagramChannel.join(this.endPointAddress.getAddress(), this.udpChannel.localInterface());
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, this.udpChannel.localInterface());
                if (0 != this.udpChannel.multicastTtl()) {
                    this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.udpChannel.multicastTtl());
                    this.multicastTtl = this.sendDatagramChannel.getOption(StandardSocketOptions.IP_MULTICAST_TTL);
                }
            } else {
                this.sendDatagramChannel.bind(this.bindAddress);
            }
            if (null != this.connectAddress) {
                this.sendDatagramChannel.connect(this.connectAddress);
            }
            if (0 != Configuration.SOCKET_SNDBUF_LENGTH) {
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)Configuration.SOCKET_SNDBUF_LENGTH);
            }
            if (0 != Configuration.SOCKET_RCVBUF_LENGTH) {
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)Configuration.SOCKET_RCVBUF_LENGTH);
            }
            this.sendDatagramChannel.configureBlocking(false);
            this.receiveDatagramChannel.configureBlocking(false);
        }
        catch (IOException ex) {
            statusIndicator.setOrdered(-1L);
            CloseHelper.quietClose((AutoCloseable)this.sendDatagramChannel);
            if (this.receiveDatagramChannel != this.sendDatagramChannel) {
                CloseHelper.quietClose((AutoCloseable)this.receiveDatagramChannel);
            }
            this.sendDatagramChannel = null;
            this.receiveDatagramChannel = null;
            throw new RuntimeException("Channel error: " + ex.getMessage() + " (at " + ex.getStackTrace()[0].toString() + "): " + this.udpChannel.originalUriString(), ex);
        }
    }

    public void registerForRead(UdpTransportPoller transportPoller) {
        this.transportPoller = transportPoller;
        this.selectionKey = transportPoller.registerForRead(this);
    }

    public UdpChannel udpChannel() {
        return this.udpChannel;
    }

    public DatagramChannel receiveDatagramChannel() {
        return this.receiveDatagramChannel;
    }

    public int multicastTtl() {
        return this.multicastTtl;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            try {
                if (null != this.selectionKey) {
                    this.selectionKey.cancel();
                }
                if (null != this.transportPoller) {
                    this.transportPoller.cancelRead(this);
                    this.transportPoller.selectNowWithoutProcessing();
                }
                if (null != this.sendDatagramChannel) {
                    this.sendDatagramChannel.close();
                }
                if (this.receiveDatagramChannel != this.sendDatagramChannel && null != this.receiveDatagramChannel) {
                    this.receiveDatagramChannel.close();
                }
            }
            catch (IOException ex) {
                this.errorLog.record((Throwable)ex);
            }
        }
    }

    public boolean isMulticast() {
        return this.udpChannel.isMulticast();
    }

    public boolean isValidFrame(UnsafeBuffer buffer, int length) {
        boolean isFrameValid = true;
        if (FrameDescriptor.frameVersion((UnsafeBuffer)buffer, (int)0) != 0) {
            isFrameValid = false;
            this.invalidPackets.increment();
        } else if (length < 8) {
            isFrameValid = false;
            this.invalidPackets.increment();
        }
        return isFrameValid;
    }

    public InetSocketAddress receive(ByteBuffer buffer) {
        buffer.clear();
        InetSocketAddress address = null;
        try {
            address = (InetSocketAddress)this.receiveDatagramChannel.receive(buffer);
        }
        catch (PortUnreachableException | ClosedChannelException iOException) {
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return address;
    }
}

