/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereFileTransmitter;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;

public final class OverthereFileCopier
extends OverthereFileTransmitter {
    private static final String SOURCE = "Source";
    private static final String DESTINATION = "Destination";
    private Stack<OverthereFile> dstDirStack = new Stack();
    private OverthereFile srcDir;

    private OverthereFileCopier() {
    }

    private OverthereFileCopier(OverthereFile srcDir, OverthereFile dstDir) {
        super(srcDir, dstDir);
    }

    public static void copy(OverthereFile src, OverthereFile dst) {
        if (src.isDirectory()) {
            OverthereFileCopier.copyDirectory(src, dst);
        } else {
            new OverthereFileCopier().transmitFile(src, dst);
        }
    }

    private static void copyDirectory(OverthereFile srcDir, OverthereFile dstDir) throws RuntimeIOException {
        OverthereFileCopier dirCopier = new OverthereFileCopier(srcDir, dstDir);
        dirCopier.startTransmission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transmitFile(OverthereFile srcFile, OverthereFile dstFile) throws RuntimeIOException {
        this.checkFileExists(srcFile, SOURCE);
        this.checkReallyIsAFile(dstFile, DESTINATION);
        this.logger.debug("Copying file {} to {}", (Object)srcFile, (Object)dstFile);
        if (dstFile.exists()) {
            this.logger.trace("About to overwrite existing file {}", (Object)dstFile);
        }
        try {
            InputStream is = srcFile.getInputStream();
            try {
                OutputStream os = dstFile.getOutputStream();
                try {
                    OverthereUtils.write(is, os);
                }
                finally {
                    OverthereUtils.closeQuietly(os);
                }
            }
            finally {
                OverthereUtils.closeQuietly(is);
            }
        }
        catch (RuntimeIOException exc) {
            throw new RuntimeIOException("Cannot copy " + srcFile + " to " + dstFile, exc.getCause());
        }
    }
}

