/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.plugins.server.servlet.Cleanable;
import org.jboss.resteasy.plugins.server.servlet.Cleanables;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.NoContent;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class DataSourceProvider
extends AbstractEntityProvider<DataSource> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource readDataSource(InputStream in, MediaType mediaType) throws IOException {
        byte[] buffer;
        int count;
        byte[] memoryBuffer = new byte[4096];
        int readCount = in.read(memoryBuffer, 0, memoryBuffer.length);
        File tempFile = null;
        if (readCount > 0 && (count = in.read(buffer = new byte[4096], 0, buffer.length)) > -1) {
            tempFile = File.createTempFile("resteasy-provider-datasource", null);
            fos.write(buffer, 0, count);
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                ProviderHelper.writeTo(in, fos);
            }
        }
        if (readCount == -1) {
            readCount = 0;
        }
        return new SequencedDataSource(memoryBuffer, 0, readCount, tempFile, mediaType.toString());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    public DataSource readFrom(Class<DataSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", this.getClass().getName());
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return DataSourceProvider.readDataSource(new ByteArrayInputStream(new byte[0]), mediaType);
        }
        return DataSourceProvider.readDataSource(entityStream, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(DataSource dataSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", this.getClass().getName());
        try (InputStream in = dataSource.getInputStream();){
            ProviderHelper.writeTo(in, entityStream);
        }
    }

    private static class CleanableSequenceInputStream
    extends SequenceInputStream
    implements Cleanable {
        private File tempFile;

        public CleanableSequenceInputStream(InputStream is1, InputStream is2, File tempFile) {
            super(is1, is2);
            this.tempFile = tempFile;
        }

        @Override
        public void clean() throws Exception {
            this.deleteTempFile();
        }

        private void deleteTempFile() {
            if (this.tempFile.exists() && !this.tempFile.delete()) {
                this.tempFile.deleteOnExit();
            }
        }
    }

    protected static class SequencedDataSource
    implements DataSource {
        private final byte[] byteBuffer;
        private final int byteBufferOffset;
        private final int byteBufferLength;
        private final File tempFile;
        private final String type;

        protected SequencedDataSource(byte[] byteBuffer, int byteBufferOffset, int byteBufferLength, File tempFile, String type) {
            this.byteBuffer = byteBuffer;
            this.byteBufferOffset = byteBufferOffset;
            this.byteBufferLength = byteBufferLength;
            this.tempFile = tempFile;
            this.type = type;
        }

        public String getContentType() {
            return this.type;
        }

        public InputStream getInputStream() throws IOException {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.byteBuffer, this.byteBufferOffset, this.byteBufferLength);
            if (this.tempFile == null) {
                return bis;
            }
            FileInputStream fis = new FileInputStream(this.tempFile);
            CleanableSequenceInputStream csis = new CleanableSequenceInputStream(bis, fis, this.tempFile);
            Cleanables cleanables = ResteasyProviderFactory.getContextData(Cleanables.class);
            if (cleanables != null) {
                cleanables.addCleanable(csis);
            }
            return csis;
        }

        public String getName() {
            return "";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException(Messages.MESSAGES.noOutputStreamAllowed());
        }
    }
}

