/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.xlplatform.utils.SecureRandomHolder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitKeyStore {
    private static final AtomicReference<KeyStore> KEYSTORE = new AtomicReference();
    private static final String DEPLOYIT_PASSWORD_KEY = "deployit-passsword-key";
    private static final String KEYSTORE_TYPE = "JCEKS";
    private static final String KEYSTORE_FILE = "repository-keystore";
    private static final String passwordKeyEntryPassword = "deployit";
    private static final Logger logger = LoggerFactory.getLogger(DeployitKeyStore.class);

    private DeployitKeyStore() {
    }

    public static void generateRandomKeyStore(File parentDir, String password) {
        byte[] keyBytes = SecureRandomHolder.getRandomByteArray((int)16);
        SecretKeySpec aesKey = new SecretKeySpec(keyBytes, "AES");
        DeployitKeyStore.createKeyStoreFile(aesKey, password, parentDir);
    }

    static void createKeyStoreFile(SecretKey key, String password, File parentDir) {
        FileOutputStream out = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(null);
            keyStore.setKeyEntry(DEPLOYIT_PASSWORD_KEY, key, passwordKeyEntryPassword.toCharArray(), null);
            File file = DeployitKeyStore.getFile(parentDir);
            logger.info("Creating key store in " + file.getAbsolutePath());
            out = new FileOutputStream(file);
            keyStore.store(out, password.toCharArray());
            KEYSTORE.set(keyStore);
        }
        catch (Exception e) {
            try {
                throw new DeployitKeyStoreException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(out);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)out);
    }

    public static void load(char[] password) {
        DeployitKeyStore.load(new File("conf"), password);
    }

    static void load(File parentDir, char[] password) {
        if (KEYSTORE.get() != null) {
            return;
        }
        File file = DeployitKeyStore.getFile(parentDir);
        if (file.exists()) {
            int tries = 0;
            char[] pwd = password;
            while (true) {
                try {
                    ++tries;
                    KEYSTORE.compareAndSet(null, DeployitKeyStore.tryLoad(file, pwd));
                }
                catch (DeployitKeyStoreException dkse) {
                    logger.debug("Could not load the encryption key for the repository.", (Throwable)dkse);
                    if (password.length > 0) {
                        throw dkse;
                    }
                    if (tries > 1) {
                        System.out.println("\nThe password was incorrect.");
                    }
                    if (tries <= 3) {
                        pwd = DeployitKeyStore.promptForPassword();
                        continue;
                    }
                    throw dkse;
                }
                break;
            }
        }
    }

    private static KeyStore tryLoad(File file, char[] password) {
        KeyStore keyStore;
        FileInputStream in = null;
        try {
            KeyStore keyStore2 = KeyStore.getInstance(KEYSTORE_TYPE);
            logger.debug("Loading password encryption key from {}", (Object)file.getAbsolutePath());
            in = new FileInputStream(file);
            keyStore2.load(in, password);
            keyStore = keyStore2;
        }
        catch (IOException | GeneralSecurityException e) {
            try {
                throw new DeployitKeyStoreException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        return keyStore;
    }

    private static char[] promptForPassword() {
        System.out.println("\nPlease enter the password to unlock the encryption key.");
        if (System.console() != null) {
            return System.console().readPassword("Password: ", new Object[0]);
        }
        throw new DeployitKeyStoreException("No Console present to read from, please ensure the password to open the XL Deploy keystore is passed on the command line");
    }

    public static SecretKey getPasswordEncryptionKey() {
        if (KEYSTORE.get() == null) {
            throw new DeployitKeyStoreException("Please load the password encryption key store before accessing a key.");
        }
        try {
            return (SecretKey)KEYSTORE.get().getKey(DEPLOYIT_PASSWORD_KEY, passwordKeyEntryPassword.toCharArray());
        }
        catch (Exception e) {
            throw new DeployitKeyStoreException(e);
        }
    }

    static File getFile(File parentDir) {
        return new File(parentDir, "repository-keystore." + KEYSTORE_TYPE.toLowerCase());
    }
}

