/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.exception.UnknownRevisionException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemRevision;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository$;
import com.xebialabs.deployit.repository.sql.HistoryQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

@Repository
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0001\u0003\u00015\u00111cQ5ISN$xN]=SKB|7/\u001b;pefT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u001dA\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u001d!K7\u000f^8ssF+XM]5fg\"A\u0011\u0004\u0001BC\u0002\u0013\u0005!$\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001\u001c!\taR%D\u0001\u001e\u0015\tqr$\u0001\u0003d_J,'B\u0001\u0011\"\u0003\u0011QGMY2\u000b\u0005\t\u001a\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0011\n1a\u001c:h\u0013\t1SD\u0001\u0007KI\n\u001cG+Z7qY\u0006$X\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u001c\u00035QGMY2UK6\u0004H.\u0019;fA!A!\u0006\u0001BC\u0002\u0013\u00051&\u0001\u0004nCB\u0004XM]\u000b\u0002YA\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\tI\u0006$\u0018MY5oI*\u0011\u0011GM\u0001\bU\u0006\u001c7n]8o\u0015\t\u0019$\"A\u0005gCN$XM\u001d=nY&\u0011QG\f\u0002\r\u001f\nTWm\u0019;NCB\u0004XM\u001d\u0005\to\u0001\u0011\t\u0011)A\u0005Y\u00059Q.\u00199qKJ\u0004\u0003\u0002C\u001d\u0001\u0005\u000b\u0007I1\u0001\u001e\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/F\u0001<!\tat(D\u0001>\u0015\t\u0019aH\u0003\u0002\u001f\r%\u0011\u0001)\u0010\u0002\u000b'FdG)[1mK\u000e$\b\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u0017M\fH\u000eR5bY\u0016\u001cG\u000f\t\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019[\u0006\r\u0006\u0002H\u0011B\u0011Q\u0003\u0001\u0005\u0006s\r\u0003\u001da\u000f\u0015\u0005\u0011*#V\u000b\u0005\u0002L%6\tAJ\u0003\u0002N\u001d\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005=\u0003\u0016a\u00024bGR|'/\u001f\u0006\u0003#\u0006\nQAY3b]NL!a\u0015'\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%\u0001,\u0002\u001d5\f\u0017N\\*rY\u0012K\u0017\r\\3di\"\u0012\u0001\n\u0017\t\u0003\u0017fK!A\u0017'\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B\rD\u0001\u0004Y\u0002\u0006B.K)v\u000b\u0013AX\u0001\u0011[\u0006LgN\u00133cGR+W\u000e\u001d7bi\u0016D#a\u0017-\t\u000b)\u001a\u0005\u0019\u0001\u0017)\t\u0001TEKY\u0011\u0002G\u0006i\u0001.[:u_JLX*\u00199qKJD#\u0001\u0019-\t\u000b\u0019\u0004A\u0011A4\u0002'\u001d,GOV3sg&|gNU3wSNLwN\\:\u0015\u0005!$\bcA5oa6\t!N\u0003\u0002lY\u0006!Q\u000f^5m\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c6\u0003\t1K7\u000f\u001e\t\u0003cJl\u0011\u0001B\u0005\u0003g\u0012\u0011\u0011dQ8oM&<WO]1uS>t\u0017\n^3n%\u00164\u0018n]5p]\")Q/\u001aa\u0001m\u0006\u0011\u0011\u000e\u001a\t\u0003ozt!\u0001\u001f?\u0011\u0005e\u0004R\"\u0001>\u000b\u0005md\u0011A\u0002\u001fs_>$h(\u0003\u0002~!\u00051\u0001K]3eK\u001aL1a`A\u0001\u0005\u0019\u0019FO]5oO*\u0011Q\u0010\u0005\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0003E1W\r^2i%\u00164\u0018n]5p]\u0012\u000bG/\u0019\u000b\u0005\u0003\u0013\t9\u0005\u0005\u0003j]\u0006-\u0001CC\b\u0002\u000e\u0005E\u0011qCA!m&\u0019\u0011q\u0002\t\u0003\rQ+\b\u000f\\35!\ry\u00111C\u0005\u0004\u0003+\u0001\"aA%oiB!\u0011\u0011DA\u001e\u001d\u0011\tY\"!\u000e\u000f\t\u0005u\u0011\u0011\u0007\b\u0005\u0003?\tyC\u0004\u0003\u0002\"\u00055b\u0002BA\u0012\u0003WqA!!\n\u0002*9\u0019\u00110a\n\n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!C\u0002\u00024\t\tAAY1tK&!\u0011qGA\u001d\u0003\u001d\u0001\u0018mY6bO\u0016T1!a\r\u0003\u0013\u0011\ti$a\u0010\u0003\u0011\rK\u0007k\u0013+za\u0016TA!a\u000e\u0002:A\u0019\u0011.a\u0011\n\u0007\u0005\u0015#N\u0001\u0005DC2,g\u000eZ1s\u0011\u0019)\u00181\u0001a\u0001m\"9\u00111\n\u0001\u0005\n\u00055\u0013aD2sK\u0006$XMU3wSNLwN\\:\u0015\t\u0005=\u0013Q\u000b\t\u0005S\u0006E\u0003/C\u0002\u0002T)\u0014\u0011\"\u0011:sCfd\u0015n\u001d;\t\u0011\u0005]\u0013\u0011\na\u0001\u0003\u0013\tQ!\u001b;f[NDq!a\u0017\u0001\t\u0003\ti&\u0001\u0007sK\u0006$'+\u001a<jg&|g.\u0006\u0003\u0002`\u0005\u0015DCBA1\u0003\u000b\u000b9\t\u0005\u0003\u0002d\u0005\u0015D\u0002\u0001\u0003\t\u0003O\nIF1\u0001\u0002j\t\tA+\u0005\u0003\u0002l\u0005E\u0004cA\b\u0002n%\u0019\u0011q\u000e\t\u0003\u000f9{G\u000f[5oOB!\u00111OAA\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014aA;e[*!\u00111PA?\u0003\r\t\u0007/\u001b\u0006\u0004\u0003\u007f2\u0011A\u00029mk\u001eLg.\u0003\u0003\u0002\u0004\u0006U$!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\"1Q/!\u0017A\u0002YDq!!#\u0002Z\u0001\u0007a/\u0001\u0007sKZL7/[8o\u001d\u0006lW\rC\u0004\u0002\u000e\u0002!\t!a$\u0002\r%t7/\u001a:u))\t\t*a&\u0002\u001c\u0006}\u00151\u0017\t\u0004\u001f\u0005M\u0015bAAK!\t!QK\\5u\u0011!\tI*a#A\u0002\u0005]\u0011A\u00019l\u0011!\ti*a#A\u0002\u0005E\u0014AA2j\u0011!\t\t+a#A\u0002\u0005\r\u0016a\u00018poB!\u0011QUAX\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016\u0001\u0002;j[\u0016T1!!,$\u0003\u0011Qw\u000eZ1\n\t\u0005E\u0016q\u0015\u0002\t\t\u0006$X\rV5nK\"9\u0011QWAF\u0001\u00041\u0018\u0001C;tKJt\u0015-\\3\t\u000f\u0005e\u0006\u0001\"\u0001\u0002<\u00061A-\u001a7fi\u0016$B!!%\u0002>\"A\u0011\u0011TA\\\u0001\u0004\t9\u0002\u000b\u0004\u0001\u0003\u0003$\u0016q\u001a\t\u0005\u0003\u0007\fY-\u0004\u0002\u0002F*\u0019Q*a2\u000b\u0007\u0005%\u0017%A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BAg\u0003\u000b\u0014Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017EAAi\u0003Yi\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\bf\u0002\u0001\u0002V\u0006\r\u0018Q\u001d\t\u0005\u0003/\fy.\u0004\u0002\u0002Z*\u0019Q*a7\u000b\u0007\u0005u\u0017%A\u0004d_:$X\r\u001f;\n\t\u0005\u0005\u0018\u0011\u001c\u0002\u0006'\u000e|\u0007/Z\u0001\naJ|\u00070_'pI\u0016$#!a:\n\t\u0005%\u00181^\u0001\r)\u0006\u0013v)\u0012+`\u00072\u000b5k\u0015\u0006\u0005\u0003[\fI.A\bTG>\u0004X\r\u001a)s_bLXj\u001c3fQ\r\u0001\u0011\u0011\u001f\t\u0005\u0003g\fI0\u0004\u0002\u0002v*\u0019\u0011q_\u0011\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002|\u0006U(A\u0003*fa>\u001c\u0018\u000e^8ss\u001e9\u0011q \u0002\t\u0002\t\u0005\u0011aE\"j\u0011&\u001cHo\u001c:z%\u0016\u0004xn]5u_JL\bcA\u000b\u0003\u0004\u00191\u0011A\u0001E\u0001\u0005\u000b\u00192Aa\u0001\u000f\u0011\u001d!%1\u0001C\u0001\u0005\u0013!\"A!\u0001\t\u0011\t5!1\u0001C\u0001\u0005\u001f\t1#\u001b8eKb$vNU3wSNLwN\u001c(b[\u0016$2A\u001eB\t\u0011!\u0011\u0019Ba\u0003A\u0002\u0005E\u0011aA5eq\"Q!q\u0003B\u0002\u0005\u0004%)A!\u0007\u0002\u00139\fW.\u001a*fO\u0016DXC\u0001B\u000e!\u0011\u0011iB!\n\u000e\u0005\t}!\u0002\u0002B\u0011\u0005G\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0003WBIAAa\n\u0003 \t)!+Z4fq\"I!1\u0006B\u0002A\u00035!1D\u0001\u000b]\u0006lWMU3hKb\u0004\u0003\u0002\u0003B\u0018\u0005\u0007!\tA!\r\u0002\u001bMDw.\u001e7e-\u0016\u00148/[8o)\u0019\u0011\u0019D!\u000f\u0003<A\u0019qB!\u000e\n\u0007\t]\u0002CA\u0004C_>dW-\u00198\t\rU\u0014i\u00031\u0001w\u0011!\u0011iD!\fA\u0002\t}\u0012AB2j)f\u0004X\r\u0005\u0003\u0003B\t\u001dSB\u0001B\"\u0015\u0011\u0011)%!\u001f\u0002\u000fI,g\r\\3di&!!\u0011\nB\"\u0005\u0011!\u0016\u0010]3")
public class CiHistoryRepository
implements HistoryQueries {
    private final JdbcTemplate jdbcTemplate;
    private final ObjectMapper mapper;
    private final SqlDialect sqlDialect;
    private String INSERT;
    private String DELETE;
    private String SELECT_CI;
    private String SELECT_REVISIONS;
    private volatile byte bitmap$0;

    public static boolean shouldVersion(String string, Type type) {
        return CiHistoryRepository$.MODULE$.shouldVersion(string, type);
    }

    public static Regex nameRegex() {
        return CiHistoryRepository$.MODULE$.nameRegex();
    }

    public static String indexToRevisionName(int n) {
        return CiHistoryRepository$.MODULE$.indexToRevisionName(n);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    private String INSERT$lzycompute() {
        CiHistoryRepository ciHistoryRepository = this;
        synchronized (ciHistoryRepository) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.INSERT = HistoryQueries.INSERT$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String DELETE$lzycompute() {
        CiHistoryRepository ciHistoryRepository = this;
        synchronized (ciHistoryRepository) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.DELETE = HistoryQueries.DELETE$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String SELECT_CI$lzycompute() {
        CiHistoryRepository ciHistoryRepository = this;
        synchronized (ciHistoryRepository) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.SELECT_CI = HistoryQueries.SELECT_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.SELECT_CI;
    }

    @Override
    public String SELECT_CI() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.SELECT_CI$lzycompute() : this.SELECT_CI;
    }

    private String SELECT_REVISIONS$lzycompute() {
        CiHistoryRepository ciHistoryRepository = this;
        synchronized (ciHistoryRepository) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.SELECT_REVISIONS = HistoryQueries.SELECT_REVISIONS$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.SELECT_REVISIONS;
    }

    @Override
    public String SELECT_REVISIONS() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.SELECT_REVISIONS$lzycompute() : this.SELECT_REVISIONS;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public List<ConfigurationItemRevision> getVersionRevisions(String id) {
        return this.createRevisions(this.fetchRevisionData(id));
    }

    private List<Tuple4<Object, Integer, Calendar, String>> fetchRevisionData(String id) {
        return this.jdbcTemplate().query(this.SELECT_REVISIONS(), (rs, row) -> {
            Integer pk = package$.MODULE$.asCiPKType(BoxesRunTime.boxToInteger((int)rs.getInt(1)));
            Calendar timestamp = com.xebialabs.deployit.core.sql.package$.MODULE$.toCalendar(rs.getTimestamp(2));
            String username = rs.getString(3);
            return new Tuple4((Object)BoxesRunTime.boxToInteger((int)row), (Object)pk, (Object)timestamp, (Object)username);
        }, new Object[]{package$.MODULE$.idToPath(id)});
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<ConfigurationItemRevision> createRevisions(List<Tuple4<Object, Integer, Calendar, String>> items) {
        void var3_2;
        ArrayList<ConfigurationItemRevision> result = new ArrayList<ConfigurationItemRevision>(items.size());
        Iterator<Tuple4<Object, Integer, Calendar, String>> itr = items.iterator();
        while (itr.hasNext()) {
            Tuple4<Object, Integer, Calendar, String> tuple4 = itr.next();
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            int row = BoxesRunTime.unboxToInt((Object)tuple4._1());
            Calendar timestamp = (Calendar)tuple4._3();
            String username = (String)tuple4._4();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)row), (Object)timestamp, (Object)username);
            Tuple3 tuple32 = tuple3;
            int row2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            Calendar timestamp2 = (Calendar)tuple32._2();
            String username2 = (String)tuple32._3();
            result.add(itr.hasNext() ? new ConfigurationItemRevision(CiHistoryRepository$.MODULE$.indexToRevisionName(row2), timestamp2, username2) : new ConfigurationItemRevision("current", timestamp2, username2));
        }
        return var3_2;
    }

    public <T extends ConfigurationItem> T readRevision(String id, String revisionName) {
        String string = revisionName;
        Option option = CiHistoryRepository$.MODULE$.nameRegex().unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw CiHistoryRepository.throwUnknownRevision$1(id, revisionName);
        }
        String res = (String)((LinearSeqOptimized)option.get()).apply(0);
        int n = new StringOps(Predef$.MODULE$.augmentString(res)).toInt();
        int idx = n;
        List<Tuple4<Object, Integer, Calendar, String>> revisions = this.fetchRevisionData(id);
        if (revisions.size() < idx) {
            throw CiHistoryRepository.throwUnknownRevision$1(id, revisionName);
        }
        Integer pk = (Integer)revisions.get(idx)._2();
        List result = this.jdbcTemplate().queryForList(this.SELECT_CI(), String.class, new Object[]{pk, package$.MODULE$.idToPath(id)});
        String ci_json = (String)result.get(0);
        return (T)((ConfigurationItem)this.mapper().readValue(ci_json, ConfigurationItem.class));
    }

    public void insert(Integer pk, ConfigurationItem ci, DateTime now, String userName) {
        block0: {
            if (!CiHistoryRepository$.MODULE$.shouldVersion(ci.getId(), ci.getType())) break block0;
            this.jdbcTemplate().update(this.INSERT(), new Object[]{pk, com.xebialabs.deployit.core.sql.package$.MODULE$.toCalendar(now), Option$.MODULE$.apply((Object)userName).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<system>"), this.mapper().writerFor(ConfigurationItem.class).writeValueAsString((Object)ci)});
        }
    }

    public void delete(Integer pk) {
        this.jdbcTemplate().update(this.DELETE(), new Object[]{pk});
    }

    private static final Nothing$ throwUnknownRevision$1(String id$1, String revisionName$1) {
        throw new UnknownRevisionException("Cannot find revision [%s] for configuration item [%s]", new Object[]{revisionName$1, id$1});
    }

    public CiHistoryRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="historyMapper") ObjectMapper mapper, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.mapper = mapper;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        HistoryQueries.$init$(this);
    }
}

